/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.Counter;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class CounterGroup
implements Writable,
Iterable<Counter> {
    private String name;
    private String displayName;
    private TreeMap<String, Counter> counters = new TreeMap();
    private ResourceBundle bundle = null;

    private static ResourceBundle getResourceBundle(String enumClassName) {
        String bundleName = enumClassName.replace('$', '_');
        return ResourceBundle.getBundle(bundleName);
    }

    protected CounterGroup(String name) {
        this.name = name;
        try {
            this.bundle = CounterGroup.getResourceBundle(name);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        this.displayName = this.localize("CounterGroupName", name);
    }

    public CounterGroup(String name, String displayName) {
        this.name = name;
        this.displayName = displayName;
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized String getDisplayName() {
        return this.displayName;
    }

    public synchronized void addCounter(Counter counter) {
        this.counters.put(counter.getName(), counter);
    }

    public Counter findCounter(String counterName, String displayName) {
        Counter result = this.counters.get(counterName);
        if (result == null) {
            result = new Counter(counterName, displayName);
            this.counters.put(counterName, result);
        }
        return result;
    }

    public synchronized Counter findCounter(String counterName) {
        Counter result = this.counters.get(counterName);
        if (result == null) {
            String displayName = this.localize(counterName, counterName);
            result = new Counter(counterName, displayName);
            this.counters.put(counterName, result);
        }
        return result;
    }

    @Override
    public synchronized Iterator<Counter> iterator() {
        return this.counters.values().iterator();
    }

    public synchronized void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.displayName);
        WritableUtils.writeVInt((DataOutput)out, (int)this.counters.size());
        for (Counter counter : this.counters.values()) {
            counter.write(out);
        }
    }

    public synchronized void readFields(DataInput in) throws IOException {
        this.displayName = Text.readString((DataInput)in);
        this.counters.clear();
        int size = WritableUtils.readVInt((DataInput)in);
        for (int i = 0; i < size; ++i) {
            Counter counter = new Counter();
            counter.readFields(in);
            this.counters.put(counter.getName(), counter);
        }
    }

    private String localize(String key, String defaultValue) {
        String result = defaultValue;
        if (this.bundle != null) {
            try {
                result = this.bundle.getString(key);
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
        }
        return result;
    }

    public synchronized int size() {
        return this.counters.size();
    }

    public synchronized boolean equals(Object genericRight) {
        if (genericRight instanceof CounterGroup) {
            Iterator<Counter> right = ((CounterGroup)genericRight).counters.values().iterator();
            Iterator<Counter> left = this.counters.values().iterator();
            while (left.hasNext()) {
                if (right.hasNext() && left.next().equals(right.next())) continue;
                return false;
            }
            return !right.hasNext();
        }
        return false;
    }

    public synchronized int hashCode() {
        return this.counters.hashCode();
    }

    public synchronized void incrAllCounters(CounterGroup rightGroup) {
        for (Counter right : rightGroup.counters.values()) {
            Counter left = this.findCounter(right.getName(), right.getDisplayName());
            left.increment(right.getValue());
        }
    }
}

