/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import org.apache.avro.util.Utf8;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptUnsuccessfulCompletion;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TaskAttemptUnsuccessfulCompletionEvent
implements HistoryEvent {
    private TaskAttemptUnsuccessfulCompletion datum = new TaskAttemptUnsuccessfulCompletion();

    public TaskAttemptUnsuccessfulCompletionEvent(TaskAttemptID id, TaskType taskType, String status, long finishTime, String hostname, String error) {
        this.datum.taskid = new Utf8(id.getTaskID().toString());
        this.datum.taskType = new Utf8(taskType.name());
        this.datum.attemptId = new Utf8(id.toString());
        this.datum.finishTime = finishTime;
        this.datum.hostname = new Utf8(hostname);
        this.datum.error = new Utf8(error);
        this.datum.status = new Utf8(status);
    }

    TaskAttemptUnsuccessfulCompletionEvent() {
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (TaskAttemptUnsuccessfulCompletion)((Object)datum);
    }

    public TaskID getTaskId() {
        return TaskID.forName(this.datum.taskid.toString());
    }

    public TaskType getTaskType() {
        return TaskType.valueOf(this.datum.taskType.toString());
    }

    public TaskAttemptID getTaskAttemptId() {
        return TaskAttemptID.forName(this.datum.attemptId.toString());
    }

    public long getFinishTime() {
        return this.datum.finishTime;
    }

    public String getHostname() {
        return this.datum.hostname.toString();
    }

    public String getError() {
        return this.datum.error.toString();
    }

    public String getTaskStatus() {
        return this.datum.status.toString();
    }

    @Override
    public EventType getEventType() {
        boolean failed = TaskStatus.State.FAILED.toString().equals(this.getTaskStatus());
        return this.getTaskId().getTaskType() == TaskType.MAP ? (failed ? EventType.MAP_ATTEMPT_FAILED : EventType.MAP_ATTEMPT_KILLED) : (failed ? EventType.REDUCE_ATTEMPT_FAILED : EventType.REDUCE_ATTEMPT_KILLED);
    }
}

