/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import org.apache.avro.util.Utf8;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.EventReader;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.EventWriter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFinished;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TaskFinishedEvent
implements HistoryEvent {
    private TaskFinished datum = new TaskFinished();

    public TaskFinishedEvent(TaskID id, long finishTime, TaskType taskType, String status, Counters counters) {
        this.datum.taskid = new Utf8(id.toString());
        this.datum.finishTime = finishTime;
        this.datum.counters = EventWriter.toAvro(counters);
        this.datum.taskType = new Utf8(taskType.name());
        this.datum.status = new Utf8(status);
    }

    TaskFinishedEvent() {
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (TaskFinished)((Object)datum);
    }

    public TaskID getTaskId() {
        return TaskID.forName(this.datum.taskid.toString());
    }

    public long getFinishTime() {
        return this.datum.finishTime;
    }

    Counters getCounters() {
        return EventReader.fromAvro(this.datum.counters);
    }

    public TaskType getTaskType() {
        return TaskType.valueOf(this.datum.taskType.toString());
    }

    public String getTaskStatus() {
        return this.datum.status.toString();
    }

    @Override
    public EventType getEventType() {
        return EventType.TASK_FINISHED;
    }
}

