/*
 * Decompiled with CFR 0.152.
 */
package fuse.okuyamafs;

import fuse.okuyamafs.OkuyamaFilesystem;
import fuse.okuyamafs.OkuyamaSendWorker;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import okuyama.imdst.client.OkuyamaClient;
import okuyama.imdst.client.OkuyamaClientException;
import okuyama.imdst.client.OkuyamaClientFactory;

public class BufferedOkuyamaClient
extends OkuyamaClient {
    protected static boolean bufferedFlg = false;
    protected static Map putBufferedDataMap = new ConcurrentHashMap(350);
    protected static Map deleteBufferedDataMap = new ConcurrentHashMap(350);
    protected static ArrayBlockingQueue okuyamaRequestQueue = null;
    protected static OkuyamaClientFactory factory = null;
    protected static OkuyamaSendWorker[] workerList = null;
    protected static Object[] sendSyncObject = null;
    protected static volatile int parallel = 10;
    protected static volatile int syncParallel = 100;
    protected OkuyamaClient client = null;
    static boolean stripingDataBlock = false;
    static int stripingLevel = 8;
    static int stripingMinBlockSize = 128;
    private OkuyamaClient[] stripingDataClient = new OkuyamaClient[4];

    public BufferedOkuyamaClient(OkuyamaClient client) {
        this.client = client;
        if (stripingDataBlock) {
            try {
                this.stripingDataClient[0] = factory.getClient(300000);
                this.stripingDataClient[1] = factory.getClient(300000);
                this.stripingDataClient[2] = factory.getClient(300000);
                this.stripingDataClient[3] = factory.getClient(300000);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String[] setNewValue(String key, String value) throws OkuyamaClientException {
        return this.client.setNewValue(key, value);
    }

    public String[] setNewObjectValue(String key, Object value) throws OkuyamaClientException {
        return this.client.setNewObjectValue(key, value);
    }

    public static void initClientMaster(OkuyamaClientFactory factory, boolean bufferedFlg, boolean stripingDataBlock) throws Exception {
        BufferedOkuyamaClient.stripingDataBlock = stripingDataBlock;
        BufferedOkuyamaClient.factory = factory;
        if (!bufferedFlg) {
            BufferedOkuyamaClient.bufferedFlg = bufferedFlg;
        } else {
            int idx;
            BufferedOkuyamaClient.bufferedFlg = true;
            workerList = new OkuyamaSendWorker[parallel];
            sendSyncObject = new Object[syncParallel];
            for (idx = 0; idx < parallel; ++idx) {
                BufferedOkuyamaClient.workerList[idx] = new OkuyamaSendWorker();
                workerList[idx].start();
            }
            for (idx = 0; idx < syncParallel; ++idx) {
                BufferedOkuyamaClient.sendSyncObject[idx] = new Object();
            }
        }
    }

    public void close() throws OkuyamaClientException {
        this.client.close();
        if (stripingDataBlock) {
            try {
                this.stripingDataClient[0].close();
                this.stripingDataClient[1].close();
                this.stripingDataClient[2].close();
                this.stripingDataClient[3].close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setValue(String key, String value) throws OkuyamaClientException {
        if (!bufferedFlg) {
            return this.client.setValue(key, value);
        }
        try {
            while (true) {
                Object object = sendSyncObject[(key.hashCode() << 1 >>> 1) % syncParallel];
                synchronized (object) {
                    Object[] request = new Object[]{new Integer(1), key, value};
                    if (okuyamaRequestQueue.offer(request)) {
                        putBufferedDataMap.put(key, value);
                        deleteBufferedDataMap.remove(key);
                        return true;
                    }
                }
            }
        }
        catch (Exception ee) {
            throw new OkuyamaClientException((Throwable)ee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getValue(String key) throws OkuyamaClientException {
        if (!bufferedFlg) {
            return this.client.getValue(key);
        }
        String[] ret = null;
        try {
            Object object = sendSyncObject[(key.hashCode() << 1 >>> 1) % syncParallel];
            synchronized (object) {
                Object value = putBufferedDataMap.get(key);
                String[] realClientRet = null;
                if (value == null && (realClientRet = this.client.getValue(key)) != null && realClientRet[0].equals("true")) {
                    value = realClientRet[1];
                }
                if (value != null && deleteBufferedDataMap.containsKey(key)) {
                    value = null;
                }
                ret = value == null ? new String[]{"false"} : new String[]{"true", value.toString()};
            }
        }
        catch (Exception ee) {
            throw new OkuyamaClientException((Throwable)ee);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getObjectValue(String key) throws OkuyamaClientException {
        if (!bufferedFlg) {
            return this.client.getObjectValue(key);
        }
        Object[] ret = null;
        try {
            Object object = sendSyncObject[(key.hashCode() << 1 >>> 1) % syncParallel];
            synchronized (object) {
                Object value = putBufferedDataMap.get(key);
                Object[] realClientRet = null;
                if (value == null && (realClientRet = this.client.getObjectValue(key)) != null && realClientRet[0].equals("true")) {
                    value = realClientRet[1];
                }
                if (value != null && deleteBufferedDataMap.containsKey(key)) {
                    value = null;
                }
                ret = value == null ? new Object[]{"false"} : new Object[]{"true", value};
            }
        }
        catch (Exception ee) {
            throw new OkuyamaClientException((Throwable)ee);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setObjectValue(String key, Object value) throws OkuyamaClientException {
        if (!bufferedFlg) {
            return this.client.setObjectValue(key, value);
        }
        try {
            while (true) {
                Object object = sendSyncObject[(key.hashCode() << 1 >>> 1) % syncParallel];
                synchronized (object) {
                    Object[] request = new Object[]{new Integer(2), key, value};
                    if (okuyamaRequestQueue.offer(request)) {
                        putBufferedDataMap.put(key, value);
                        deleteBufferedDataMap.remove(key);
                        return true;
                    }
                }
            }
        }
        catch (Exception ee) {
            throw new OkuyamaClientException((Throwable)ee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sendByteValue(String key, byte[] value) throws OkuyamaClientException {
        if (!bufferedFlg) {
            return this.client.sendByteValue(key, value);
        }
        try {
            while (true) {
                Object object = sendSyncObject[(key.hashCode() << 1 >>> 1) % syncParallel];
                synchronized (object) {
                    Object[] request = new Object[]{new Integer(3), key, value};
                    if (okuyamaRequestQueue.offer(request)) {
                        putBufferedDataMap.put(key, value);
                        deleteBufferedDataMap.remove(key);
                        return true;
                    }
                }
            }
        }
        catch (Exception ee) {
            throw new OkuyamaClientException((Throwable)ee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] removeValue(String key) throws OkuyamaClientException {
        if (!bufferedFlg) {
            return this.client.removeValue(key);
        }
        String[] ret = null;
        try {
            while (true) {
                Object object = sendSyncObject[(key.hashCode() << 1 >>> 1) % syncParallel];
                synchronized (object) {
                    Object[] request = new Object[]{new Integer(4), key};
                    if (okuyamaRequestQueue.offer(request)) {
                        String[] realClientRmRet;
                        ret = new String[2];
                        ret[0] = "true";
                        Object removeRet = putBufferedDataMap.remove(key);
                        if (removeRet == null && (realClientRmRet = this.client.getValue(key))[0].equals("false")) {
                            ret = new String[]{"false"};
                            return ret;
                        }
                        deleteBufferedDataMap.put(key, new Integer(1));
                        return ret;
                    }
                }
            }
        }
        catch (Exception ee) {
            throw new OkuyamaClientException((Throwable)ee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean requestRemoveValue(String key) throws OkuyamaClientException {
        if (!bufferedFlg) {
            return this.client.requestRemoveValue(key);
        }
        try {
            while (true) {
                Object object = sendSyncObject[(key.hashCode() << 1 >>> 1) % syncParallel];
                synchronized (object) {
                    Object[] request = new Object[]{new Integer(4), key};
                    if (okuyamaRequestQueue.offer(request)) {
                        putBufferedDataMap.remove(key);
                        deleteBufferedDataMap.put(key, new Integer(1));
                        return true;
                    }
                }
            }
        }
        catch (Exception ee) {
            throw new OkuyamaClientException((Throwable)ee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] responseRemoveValue(String key) throws OkuyamaClientException {
        if (!bufferedFlg) {
            return this.client.responseRemoveValue(key);
        }
        String[] ret = null;
        try {
            int i = 0;
            while (true) {
                ++i;
                Object object = sendSyncObject[(key.hashCode() << 1 >>> 1) % syncParallel];
                synchronized (object) {
                    if (!deleteBufferedDataMap.containsKey(key)) {
                        break;
                    }
                    if (i % 100 == 0) {
                        Thread.sleep(10L);
                    }
                }
            }
            ret = new String[2];
            ret[0] = "true";
        }
        catch (Exception ee) {
            throw new OkuyamaClientException((Throwable)ee);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] readByteValue(String key) throws OkuyamaClientException {
        if (!bufferedFlg) {
            return this.client.readByteValue(key);
        }
        Object[] ret = null;
        try {
            Object object = sendSyncObject[(key.hashCode() << 1 >>> 1) % syncParallel];
            synchronized (object) {
                byte[] value = (byte[])putBufferedDataMap.get(key);
                if (value == null) {
                    if (!stripingDataBlock) {
                        Object[] realClientRet = this.client.readByteValue(key);
                        if (realClientRet != null && realClientRet[0].equals("true")) {
                            value = (byte[])realClientRet[1];
                        }
                    } else {
                        value = this.readStripingBlock(key);
                        if (value.length == 0) {
                            value = null;
                        }
                    }
                }
                if (value != null && deleteBufferedDataMap.containsKey(key)) {
                    value = null;
                }
                ret = value == null ? new Object[]{"false"} : new Object[]{"true", value};
            }
        }
        catch (Exception ee) {
            throw new OkuyamaClientException((Throwable)ee);
        }
        return ret;
    }

    private byte[] readStripingBlock(String key) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int strpngIndex = 0;
        for (int idx = 0; idx < stripingLevel / 4; ++idx) {
            this.stripingDataClient[0].requestReadByteValue(key + "\t" + strpngIndex);
            this.stripingDataClient[1].requestReadByteValue(key + "\t" + ++strpngIndex);
            this.stripingDataClient[2].requestReadByteValue(key + "\t" + ++strpngIndex);
            this.stripingDataClient[3].requestReadByteValue(key + "\t" + ++strpngIndex);
            boolean endRead = false;
            long start = System.nanoTime();
            Object[] stripingRet1 = this.stripingDataClient[0].responseReadByteValue(key + "\t" + (++strpngIndex - 4));
            if (!endRead && stripingRet1[0].equals("true")) {
                System.out.println("1Len=" + ((byte[])stripingRet1[1]).length);
                baos.write((byte[])stripingRet1[1]);
            } else {
                endRead = true;
            }
            Object[] stripingRet2 = this.stripingDataClient[1].responseReadByteValue(key + "\t" + (strpngIndex - 3));
            if (!endRead && stripingRet2[0].equals("true")) {
                System.out.println("2Len=" + ((byte[])stripingRet2[1]).length);
                baos.write((byte[])stripingRet2[1]);
            } else {
                endRead = true;
            }
            Object[] stripingRet3 = this.stripingDataClient[2].responseReadByteValue(key + "\t" + (strpngIndex - 2));
            if (!endRead && stripingRet3[0].equals("true")) {
                System.out.println("3Len=" + ((byte[])stripingRet3[1]).length);
                baos.write((byte[])stripingRet3[1]);
            } else {
                endRead = true;
            }
            Object[] stripingRet4 = this.stripingDataClient[3].responseReadByteValue(key + "\t" + (strpngIndex - 1));
            if (!endRead && stripingRet4[0].equals("true")) {
                System.out.println("4Len=" + ((byte[])stripingRet4[1]).length);
                baos.write((byte[])stripingRet4[1]);
            } else {
                endRead = true;
            }
            long end = System.nanoTime();
            System.out.println("StripingGet=" + (end - start));
            if (!endRead) {
                continue;
            }
            break;
        }
        return baos.toByteArray();
    }

    static {
        if (OkuyamaFilesystem.blockSize > 49152) {
            parallel = 4;
            okuyamaRequestQueue = new ArrayBlockingQueue(40);
        } else if (OkuyamaFilesystem.blockSize > 24576) {
            parallel = 10;
            okuyamaRequestQueue = new ArrayBlockingQueue(500);
        } else {
            okuyamaRequestQueue = new ArrayBlockingQueue(4000);
            parallel = 16;
        }
    }
}

