/*
 * Decompiled with CFR 0.152.
 */
package fuse.okuyamafs;

import fuse.okuyamafs.IFsMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import okuyama.imdst.util.SystemUtil;

public class NativeFsMap
implements IFsMap {
    private int type = -1;
    private Object putSync = new Object();
    private Object delSync = new Object();
    private Map dataMap = null;
    private boolean complessMode = true;

    public NativeFsMap(int type, String[] masterNodeInfos) {
        this.type = type;
        this.dataMap = new ConcurrentHashMap(1000000, 9800000.0f, 64);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putNewString(Object key, String value) {
        Object object = this.putSync;
        synchronized (object) {
            if (this.dataMap.containsKey(key)) {
                return false;
            }
            this.dataMap.put(key, value);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putNewMap(Object key, Map value) {
        Object object = this.putSync;
        synchronized (object) {
            if (this.dataMap.containsKey(key)) {
                return false;
            }
            this.dataMap.put(key, value);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putNewBytes(Object key, byte[] value) {
        Object object = this.putSync;
        synchronized (object) {
            if (this.dataMap.containsKey(key)) {
                return false;
            }
            if (this.complessMode) {
                this.dataMap.put(key, SystemUtil.dataCompress((byte[])value));
            } else {
                this.dataMap.put(key, value);
            }
        }
        return true;
    }

    @Override
    public Object putBytes(Object key, byte[] value) {
        if (this.complessMode) {
            return this.dataMap.put(key, SystemUtil.dataCompress((byte[])value));
        }
        this.dataMap.put(key, value);
        return null;
    }

    @Override
    public Object putMap(Object key, Map value) {
        return this.dataMap.put(key, value);
    }

    @Override
    public Object putString(Object key, String value) {
        return this.dataMap.put(key, value);
    }

    @Override
    public String getString(Object key) {
        return (String)this.dataMap.get(key);
    }

    @Override
    public Map getMap(Object key) {
        return (Map)this.dataMap.get(key);
    }

    @Override
    public byte[] getBytes(Object key) {
        byte[] ret = (byte[])this.dataMap.get(key);
        if (this.complessMode) {
            if (ret != null) {
                return SystemUtil.dataDecompress((byte[])ret);
            }
        } else if (ret != null) {
            return ret;
        }
        return null;
    }

    @Override
    public Object remove(Object key) {
        return this.dataMap.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeExistObject(Object key) {
        Object object = this.delSync;
        synchronized (object) {
            if (!this.dataMap.containsKey(key)) {
                return false;
            }
            this.dataMap.remove(key);
        }
        return true;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.dataMap.containsKey(key);
    }
}

