/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import okuyama.imdst.util.ImdstDefine;

public class DiskBaseCacheMap
extends LinkedHashMap {
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    private RandomAccessFile raf = null;
    private ArrayBlockingQueue freeCacheSpaceQueue = null;
    private ArrayBlockingQueue readOnlyFpQueue = null;
    private int readOnlyFpQueueSize = 4;
    private String cacheStoreFilePath = null;
    private File cacheStoreFile = null;
    private int maxCacheSize = 8192;
    public boolean errorFlg = false;

    public DiskBaseCacheMap(int maxCacheCapacity, File cacheFile) throws FileNotFoundException {
        super(maxCacheCapacity, 0.75f, true);
        this.maxCacheSize = maxCacheCapacity;
        this.cacheStoreFile = cacheFile;
        this.freeCacheSpaceQueue = new ArrayBlockingQueue(this.maxCacheSize);
        this.raf = new RandomAccessFile(this.cacheStoreFile, "rw");
        long freeSpacePoint = 0L;
        for (long i = 0L; i < (long)this.maxCacheSize; ++i) {
            this.freeCacheSpaceQueue.offer(new Long(freeSpacePoint));
            freeSpacePoint += (long)ImdstDefine.dataFileWriteMaxSize;
        }
        this.cacheStoreFilePath = this.cacheStoreFile.getAbsolutePath();
        this.readOnlyFpQueue = new ArrayBlockingQueue(this.readOnlyFpQueueSize);
        try {
            for (int i = 0; i < this.readOnlyFpQueueSize; ++i) {
                this.readOnlyFpQueue.put(new RandomAccessFile(this.cacheStoreFile, "r"));
            }
        }
        catch (Exception ee) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key, Object value) {
        if (this.freeCacheSpaceQueue.size() < 1) {
            return null;
        }
        this.w.lock();
        try {
            Long freeSpacePoint;
            if (!super.containsKey(key) && (freeSpacePoint = (Long)this.freeCacheSpaceQueue.poll()) != null) {
                this.raf.seek(freeSpacePoint);
                this.raf.write((byte[])value);
                Long l = super.put(key, freeSpacePoint);
                return l;
            }
        }
        catch (Exception e) {
            this.errorFlg = true;
            e.printStackTrace();
        }
        finally {
            this.w.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        this.r.lock();
        try {
            boolean bl = super.containsKey(key);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        byte[] retData = null;
        RandomAccessFile useRaf = null;
        this.r.lock();
        try {
            Long cacheSeekPoint = (Long)super.get(key);
            if (cacheSeekPoint != null) {
                useRaf = (RandomAccessFile)this.readOnlyFpQueue.poll(100L, TimeUnit.MILLISECONDS);
                if (useRaf == null) {
                    Object var5_8 = null;
                    return var5_8;
                }
                if (ImdstDefine.dataFileWriteMaxSize > 4096) {
                    useRaf.seek(cacheSeekPoint);
                    int readCount = ImdstDefine.dataFileWriteMaxSize / 4096;
                    int assist = ImdstDefine.dataFileWriteMaxSize % 4096;
                    if (assist > 0) {
                        ++readCount;
                    }
                    byte[] baos = new byte[(readCount - 1) * 4096 + assist];
                    useRaf.read(baos);
                    retData = baos;
                } else {
                    retData = new byte[ImdstDefine.dataFileWriteMaxSize];
                    useRaf.seek(cacheSeekPoint);
                    useRaf.read(retData);
                }
            }
        }
        catch (Exception e) {
            this.errorFlg = true;
            retData = null;
            e.printStackTrace();
        }
        finally {
            try {
                if (this.errorFlg) {
                    useRaf.close();
                    useRaf = null;
                }
                if (useRaf != null) {
                    this.readOnlyFpQueue.offer(useRaf);
                }
            }
            catch (Exception ee) {}
            this.r.unlock();
        }
        return retData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object key) {
        this.w.lock();
        Object ret = null;
        try {
            ret = super.remove(key);
            if (ret != null) {
                this.freeCacheSpaceQueue.offer(ret);
            }
        }
        catch (Exception e) {
            this.errorFlg = true;
            ret = null;
        }
        finally {
            this.w.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.w.lock();
        try {
            super.clear();
            this.freeCacheSpaceQueue = new ArrayBlockingQueue(this.maxCacheSize);
            this.cacheStoreFile.delete();
            this.cacheStoreFile = null;
            this.raf = null;
            this.cacheStoreFile = new File(this.cacheStoreFilePath);
            this.raf = new RandomAccessFile(this.cacheStoreFile, "rw");
            long freeSpacePoint = 0L;
            for (long i = 0L; i < (long)this.maxCacheSize; ++i) {
                this.freeCacheSpaceQueue.offer(new Long(freeSpacePoint));
                freeSpacePoint += (long)ImdstDefine.dataFileWriteMaxSize;
            }
            this.errorFlg = false;
        }
        catch (Exception e) {
            this.errorFlg = true;
        }
        finally {
            this.w.unlock();
        }
    }

    public void existsCacheFile() {
        try {
            File checkCacheFile = new File(this.cacheStoreFilePath);
            if (!checkCacheFile.exists()) {
                this.errorFlg = true;
            }
        }
        catch (Exception e) {
            this.errorFlg = true;
        }
    }

    protected boolean removeEldestEntry(Map.Entry eldest) {
        Long ret;
        if (this.maxCacheSize - 1 < super.size() && (ret = (Long)super.remove(eldest.getKey())) != null) {
            this.freeCacheSpaceQueue.offer(ret);
        }
        return false;
    }
}

