/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util.protocol;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import okuyama.imdst.util.StatusUtil;
import okuyama.imdst.util.SystemUtil;
import okuyama.imdst.util.io.CustomReader;
import okuyama.imdst.util.protocol.AbstractProtocolTaker;
import okuyama.imdst.util.protocol.IProtocolTaker;

public class OkuyamaProtocolTaker
extends AbstractProtocolTaker
implements IProtocolTaker {
    private int nextExec = 0;
    private boolean methodMatch = true;
    private StringBuilder retParamBuf = new StringBuilder(512);
    private String clientInfo = null;
    private static String checkSetMethodCodeSet = "1";
    private static String checkSetMethodCodeAdd = "6";

    @Override
    public void init() {
        this.nextExec = 0;
        this.methodMatch = true;
    }

    @Override
    public void setClientInfo(String clientInfo) {
        this.clientInfo = clientInfo;
    }

    public String[] takeRequestLine(InputStream is, PrintWriter pw) throws Exception {
        String[] retStrs = new String[5];
        byte[] data = new byte[1];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int counter = 0;
        while (is.read(data, 0, 1) != -1) {
            if (data[0] == 44) {
                retStrs[counter] = baos.toString().trim();
                baos = new ByteArrayOutputStream();
                ++counter;
                continue;
            }
            if (data[0] == 10) {
                retStrs[counter] = baos.toString().trim();
                break;
            }
            if (data[0] == 13) continue;
            baos.write(data, 0, 1);
        }
        if (retStrs[0] == null || retStrs[0].equals("") || retStrs[0].equals("(&imdst9999&)")) {
            this.nextExec = 3;
        }
        if (StatusUtil.getDebugOption()) {
            SystemUtil.debugLine("Request  : " + retStrs.toString());
        }
        return retStrs;
    }

    @Override
    public String takeRequestLine(BufferedReader br, PrintWriter pw) throws Exception {
        return null;
    }

    @Override
    public String takeRequestLine(CustomReader br, PrintWriter pw) throws Exception {
        String retStr = null;
        retStr = br.readLine();
        if (retStr == null || retStr.equals("") || retStr.equals("(&imdst9999&)")) {
            this.nextExec = 3;
        }
        if (StatusUtil.getDebugOption()) {
            SystemUtil.debugLine(this.clientInfo + " : Request  : " + retStr);
        }
        return retStr;
    }

    @Override
    public String[] takeRequestLine4List(CustomReader br, PrintWriter pw) throws Exception {
        String retStr = null;
        retStr = br.readLine();
        if (retStr == null || retStr.equals("") || retStr.equals("(&imdst9999&)")) {
            this.nextExec = 3;
        }
        if (StatusUtil.getDebugOption()) {
            SystemUtil.debugLine(this.clientInfo + " : Request  : " + retStr);
        }
        return this.okuyamaMethodCnv(retStr);
    }

    private String[] okuyamaMethodCnv(String executeMethodStr) {
        int methodLen = executeMethodStr.length();
        String[] splitMethodSet = null;
        splitMethodSet = executeMethodStr.indexOf("2,") == 0 ? new String[]{"2", executeMethodStr.substring(2)} : (executeMethodStr.indexOf("1,") == 0 ? SystemUtil.fastSplit(executeMethodStr, ",") : executeMethodStr.split(","));
        if (splitMethodSet[0].equals(checkSetMethodCodeSet) || splitMethodSet[0].equals(checkSetMethodCodeAdd)) {
            if (executeMethodStr.charAt(methodLen - 1) == ',') {
                String[] retMethod = new String[5];
                StringBuilder requestStrBuf = new StringBuilder(methodLen + 20);
                executeMethodStr = null;
                retMethod[0] = splitMethodSet[0];
                retMethod[1] = splitMethodSet[1];
                retMethod[2] = splitMethodSet[2];
                retMethod[3] = splitMethodSet[3];
                requestStrBuf.append(splitMethodSet[4]);
                requestStrBuf.append(",");
                requestStrBuf.append("0");
                requestStrBuf.append(AbstractProtocolTaker.metaColumnSep).append(AbstractProtocolTaker.calcExpireTime(splitMethodSet[5])).append(AbstractProtocolTaker.metaColumnSep).append(splitMethodSet[5]);
                retMethod[4] = requestStrBuf.toString();
                return retMethod;
            }
            return splitMethodSet;
        }
        return splitMethodSet;
    }

    @Override
    public String takeResponseLine(String[] retParams, BufferedOutputStream bos) throws Exception {
        return this.takeResponseLine(retParams);
    }

    @Override
    public String takeResponseLine(String[] retParams) throws Exception {
        if (this.retParamBuf.length() > 0) {
            this.retParamBuf.delete(0, Integer.MAX_VALUE);
        }
        if (retParams != null && retParams.length > 1) {
            if (retParams[0].equals("2") || retParams[0].equals("15") || retParams[0].equals("17")) {
                String[] metaColumns = null;
                String[] valueSplit = null;
                int metaDataSepPoint = retParams[2].indexOf(",");
                valueSplit = metaDataSepPoint != -1 ? new String[]{retParams[2].substring(0, metaDataSepPoint), retParams[2].substring(metaDataSepPoint + 1)} : new String[]{retParams[2]};
                if (valueSplit.length > 1) {
                    metaColumns = valueSplit[1].split(AbstractProtocolTaker.metaColumnSep);
                }
                if (valueSplit.length < 2 || AbstractProtocolTaker.expireCheck(metaColumns[1])) {
                    this.retParamBuf.append(retParams[0]);
                    this.retParamBuf.append(",");
                    this.retParamBuf.append(retParams[1]);
                    this.retParamBuf.append(",");
                    if (retParams.length > 2 && retParams[2] != null) {
                        this.retParamBuf.append(retParams[2].split(",")[0]);
                    }
                    if (retParams.length > 3 && retParams[3] != null) {
                        this.retParamBuf.append(",");
                        this.retParamBuf.append(retParams[3]);
                    }
                } else {
                    this.retParamBuf.append(retParams[0]);
                    this.retParamBuf.append(",");
                    this.retParamBuf.append("false");
                    this.retParamBuf.append(",");
                }
            } else if (retParams[0].equals("22")) {
                String[] metaColumns = null;
                String[] valueSplit = retParams[2].split(",");
                if (valueSplit.length > 1) {
                    metaColumns = valueSplit[1].split(AbstractProtocolTaker.metaColumnSep);
                }
                if (valueSplit.length < 2 || AbstractProtocolTaker.expireCheck(metaColumns[1])) {
                    this.retParamBuf.append(retParams[0]);
                    this.retParamBuf.append(",");
                    this.retParamBuf.append(retParams[1]);
                    this.retParamBuf.append(",");
                    if (retParams.length > 2 && retParams[2] != null) {
                        this.retParamBuf.append(retParams[2].split(",")[0]);
                    }
                    if (retParams.length > 3 && retParams[3] != null) {
                        this.retParamBuf.append(",");
                        this.retParamBuf.append(retParams[3]);
                    }
                } else {
                    this.retParamBuf.append(retParams[0]);
                    this.retParamBuf.append(",");
                    this.retParamBuf.append("false");
                    this.retParamBuf.append(",");
                }
                this.retParamBuf.append("\n");
            } else if (retParams[0].equals("22-f")) {
                String[] metaColumns = null;
                String[] valueSplit = retParams[2].split(",");
                retParams[0] = "22";
                if (valueSplit.length > 1) {
                    metaColumns = valueSplit[1].split(AbstractProtocolTaker.metaColumnSep);
                }
                if (valueSplit.length < 2 || AbstractProtocolTaker.expireCheck(metaColumns[1])) {
                    this.retParamBuf.append(retParams[0]);
                    this.retParamBuf.append(",");
                    this.retParamBuf.append(retParams[1]);
                    this.retParamBuf.append(",");
                    if (retParams.length > 2 && retParams[2] != null) {
                        this.retParamBuf.append(retParams[2].split(",")[0]);
                    }
                    if (retParams.length > 3 && retParams[3] != null) {
                        this.retParamBuf.append(",");
                        this.retParamBuf.append(retParams[3]);
                    }
                } else {
                    this.retParamBuf.append(retParams[0]);
                    this.retParamBuf.append(",");
                    this.retParamBuf.append("false");
                    this.retParamBuf.append(",");
                }
                this.retParamBuf.append("\n");
                this.retParamBuf.append("END");
            } else if (retParams[0].equals("23")) {
                String[] metaColumns = null;
                String[] valueSplit = retParams[3].split(",");
                if (valueSplit.length > 1) {
                    metaColumns = valueSplit[1].split(AbstractProtocolTaker.metaColumnSep);
                }
                if (valueSplit.length < 2 || AbstractProtocolTaker.expireCheck(metaColumns[1])) {
                    this.retParamBuf.append(retParams[0]);
                    this.retParamBuf.append(",");
                    this.retParamBuf.append(retParams[1]);
                    this.retParamBuf.append(",");
                    this.retParamBuf.append(retParams[2]);
                    this.retParamBuf.append(",");
                    if (retParams.length > 3 && retParams[3] != null) {
                        this.retParamBuf.append(retParams[3].split(",")[0]);
                    }
                    this.retParamBuf.append("\n");
                } else {
                    this.retParamBuf.append("");
                }
            } else if (retParams[0].equals("23-f")) {
                if (retParams.length < 4 || retParams[1].equals("false")) {
                    this.retParamBuf.append("END");
                } else {
                    String[] metaColumns = null;
                    String[] valueSplit = retParams[3].split(",");
                    retParams[0] = "23";
                    if (valueSplit.length > 1) {
                        metaColumns = valueSplit[1].split(AbstractProtocolTaker.metaColumnSep);
                    }
                    if (!retParams[1].equals("true")) {
                        this.retParamBuf.append("");
                    } else if (valueSplit.length < 2 || AbstractProtocolTaker.expireCheck(metaColumns[1])) {
                        this.retParamBuf.append(retParams[0]);
                        this.retParamBuf.append(",");
                        this.retParamBuf.append(retParams[1]);
                        this.retParamBuf.append(",");
                        this.retParamBuf.append(retParams[2]);
                        this.retParamBuf.append(",");
                        if (retParams.length > 3 && retParams[3] != null) {
                            this.retParamBuf.append(retParams[3].split(",")[0]);
                        }
                        this.retParamBuf.append("\n");
                    } else {
                        this.retParamBuf.append("");
                    }
                    this.retParamBuf.append("END");
                }
            } else {
                this.retParamBuf.append(retParams[0]);
                this.retParamBuf.append(",");
                this.retParamBuf.append(retParams[1]);
                this.retParamBuf.append(",");
                if (retParams.length > 2 && retParams[2] != null) {
                    this.retParamBuf.append(retParams[2].split(",")[0]);
                }
                if (retParams.length > 3 && retParams[3] != null) {
                    this.retParamBuf.append(",");
                    this.retParamBuf.append(retParams[3]);
                }
            }
            this.nextExec = 1;
        }
        if (StatusUtil.getDebugOption()) {
            SystemUtil.debugLine(this.clientInfo + " : Response : " + this.retParamBuf);
        }
        return this.retParamBuf.toString();
    }

    @Override
    public int nextExecution() {
        return this.nextExec;
    }

    @Override
    public boolean isMatchMethod() {
        return this.methodMatch;
    }
}

