/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util.serializemap;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import okuyama.imdst.util.ICoreStorage;
import okuyama.imdst.util.ImdstDefine;
import okuyama.imdst.util.serializemap.ISerializer;
import okuyama.imdst.util.serializemap.SerializeMapSet;

public class SerializeMap
extends AbstractMap
implements Cloneable,
Serializable,
ICoreStorage {
    private AtomicInteger nowSize = new AtomicInteger(0);
    int parallelControl = 19999;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    final Lock r = this.rwl.readLock();
    final Lock w = this.rwl.writeLock();
    private Integer[] syncObjs = null;
    private Map baseMap = null;
    private ISerializer serializer = null;
    private boolean classFix = false;
    private Class keyClass = null;
    private Class valueClass = null;
    private static HashMap uniqueNameMap = new HashMap(10);
    public static long bucketJvm1MBMemoryFactor = ImdstDefine.serializeMapBucketSizeMemoryFactor;

    public SerializeMap(int size, int upper, int multi, String serializeClassName) {
        System.out.println("SerializeMap BucketSize= " + multi);
        System.out.println("SerializeMap SerializerClassName= " + serializeClassName);
        String uniqueName = SerializeMap.createUniqueName();
        System.out.println("SerializeMap UniqueName = " + uniqueName);
        this.parallelControl = multi;
        this.syncObjs = new Integer[multi];
        for (int i = 0; i < this.parallelControl; ++i) {
            this.syncObjs[i] = new Integer(i);
        }
        this.baseMap = new ConcurrentHashMap(multi, multi - 1, 64);
        try {
            if (serializeClassName.indexOf(";") == -1) {
                this.serializer = (ISerializer)Class.forName(serializeClassName).newInstance();
                this.serializer.setInstanceCreateMapName(uniqueName);
            } else {
                Class[] constructorTypes = new Class[]{String.class};
                Object[] constructorArgs = new Object[1];
                String[] classCreateWork = serializeClassName.split(";");
                String className = classCreateWork[0];
                String constructorParam = classCreateWork[1];
                constructorArgs[0] = constructorParam;
                Class<?> serializeClazz = Class.forName(className);
                Constructor<?> constructor = serializeClazz.getConstructor(constructorTypes);
                this.serializer = (ISerializer)constructor.newInstance(constructorArgs);
                this.serializer.setInstanceCreateMapName(uniqueName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int hashPointCalc(int hash) {
        return (hash << 1 >>> 1) % this.parallelControl;
    }

    public byte[] dataSerialize(Map data, Class keyClazz, Class valueClazz, Object key, int uniqueNo) {
        return this.serializer.serialize(data, keyClazz, valueClazz, key, uniqueNo);
    }

    public Map dataDeserialize(byte[] data, Object key, int uniqueNo) {
        return this.serializer.deSerialize(data, key, uniqueNo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key, Object value) {
        boolean incrFlg = false;
        this.r.lock();
        if (!this.classFix) {
            this.classFix = true;
            this.keyClass = key.getClass();
            this.valueClass = value.getClass();
        }
        try {
            int poitnInt = this.hashPointCalc(key.hashCode());
            Integer point = new Integer(poitnInt);
            byte[] target = null;
            Integer n = this.syncObjs[poitnInt];
            synchronized (n) {
                target = (byte[])this.baseMap.get(point);
                if (target != null) {
                    Map targetMap = this.dataDeserialize(target, key, poitnInt);
                    if (!targetMap.containsKey(key)) {
                        incrFlg = true;
                    }
                    targetMap.put(key, value);
                    target = this.dataSerialize(targetMap, this.keyClass, this.valueClass, key, poitnInt);
                } else {
                    HashMap<Object, Object> targetMap = new HashMap<Object, Object>();
                    targetMap.put(key, value);
                    target = this.dataSerialize(targetMap, this.keyClass, this.valueClass, key, poitnInt);
                    incrFlg = true;
                }
                this.baseMap.put(point, target);
            }
            if (incrFlg) {
                this.nowSize.incrementAndGet();
            }
        }
        finally {
            this.r.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        this.r.lock();
        try {
            int poitnInt = this.hashPointCalc(key.hashCode());
            Integer point = new Integer(poitnInt);
            byte[] target = null;
            Integer n = this.syncObjs[poitnInt];
            synchronized (n) {
                target = (byte[])this.baseMap.get(point);
            }
            if (target == null) {
                n = null;
                return n;
            }
            Map targetMap = this.dataDeserialize(target, key, poitnInt);
            Object v = targetMap.get(key);
            return v;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object key) {
        boolean decrFlg = false;
        Object ret = null;
        this.r.lock();
        try {
            int poitnInt = this.hashPointCalc(key.hashCode());
            Integer point = new Integer(poitnInt);
            byte[] target = null;
            Integer n = this.syncObjs[poitnInt];
            synchronized (n) {
                block10: {
                    target = (byte[])this.baseMap.get(point);
                    if (target != null) break block10;
                    Object var8_8 = null;
                    return var8_8;
                }
                Map targetMap = this.dataDeserialize(target, key, poitnInt);
                ret = targetMap.remove(key);
                if (ret != null) {
                    target = this.dataSerialize(targetMap, this.keyClass, this.valueClass, key, poitnInt);
                    decrFlg = true;
                }
                this.baseMap.put(point, target);
            }
            if (decrFlg) {
                this.nowSize.decrementAndGet();
            }
        }
        finally {
            this.r.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        boolean ret = false;
        this.r.lock();
        try {
            int poitnInt = this.hashPointCalc(key.hashCode());
            Integer point = new Integer(poitnInt);
            byte[] target = null;
            Integer n = this.syncObjs[poitnInt];
            synchronized (n) {
                block8: {
                    target = (byte[])this.baseMap.get(point);
                    if (target != null) break block8;
                    boolean bl = false;
                    return bl;
                }
                Map targetMap = this.dataDeserialize(target, key, poitnInt);
                ret = targetMap.containsKey(key);
            }
        }
        finally {
            this.r.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.w.lock();
        try {
            this.baseMap.clear();
            this.serializer.clearParentMap();
            this.nowSize = new AtomicInteger(0);
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public int size() {
        return this.nowSize.intValue();
    }

    @Override
    public Set entrySet() {
        return new SerializeMapSet(this.baseMap.entrySet(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createUniqueName() {
        String retStr = null;
        HashMap hashMap = uniqueNameMap;
        synchronized (hashMap) {
            int rndInt;
            String uniqueKey;
            Random rnd = new Random();
            do {
                rndInt = rnd.nextInt(19999);
            } while (uniqueNameMap.containsKey(uniqueKey = "SerializeMapName_" + rndInt));
            retStr = uniqueKey;
            uniqueNameMap.put(retStr, null);
        }
        return retStr;
    }
}

