/*
 * Decompiled with CFR 0.152.
 */
package test.job;

import okuyama.base.job.AbstractJob;
import okuyama.base.job.IJob;
import okuyama.base.lang.BatchException;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;
import okuyama.imdst.client.OkuyamaQueueClient;

public class QueueClientTestJob
extends AbstractJob
implements IJob {
    private int checkCycle = 5000;
    private String masterNodeInfo = null;
    private static ILogger logger = LoggerFactory.createLogger(QueueClientTestJob.class);

    @Override
    public void initJob(String initValue) {
        logger.debug("QueueClientTestJob - initJob - start");
        this.masterNodeInfo = initValue;
        logger.debug("QueueClientTestJob - initJob - end");
    }

    @Override
    public String executeJob(String optionParam) throws BatchException {
        logger.debug("QueueClientTestJob - executeJob - start");
        String ret = SUCCESS;
        String[] parameterList = optionParam.split(",");
        try {
            int idx;
            OkuyamaQueueClient queueClient = new OkuyamaQueueClient();
            queueClient.setConnectionInfos(this.masterNodeInfo.split(","));
            queueClient.autoConnect();
            queueClient.createQueueSpace(parameterList[2]);
            queueClient.setValue("key", "0");
            queueClient.close();
            int putHelperCount = Integer.parseInt(parameterList[0]);
            int takeHelperCount = Integer.parseInt(parameterList[1]);
            for (idx = 0; idx < putHelperCount; ++idx) {
                queueClient = new OkuyamaQueueClient();
                queueClient.setConnectionInfos(this.masterNodeInfo.split(","));
                queueClient.autoConnect();
                Object[] queuePutHelperParams = new Object[]{queueClient, parameterList[2], new Integer(parameterList[3]), parameterList[2] + "_" + "p" + idx};
                super.executeHelper("QueueClientPutTestHelper", queuePutHelperParams);
            }
            Thread.sleep(10000L);
            for (idx = 0; idx < takeHelperCount; ++idx) {
                queueClient = new OkuyamaQueueClient();
                queueClient.setConnectionInfos(this.masterNodeInfo.split(","));
                queueClient.autoConnect();
                Object[] queueTakeHelperParams = new Object[]{queueClient, parameterList[2]};
                super.executeHelper("QueueClientTakeTestHelper", queueTakeHelperParams);
            }
        }
        catch (Exception e) {
            logger.error("QueueClientTestJob - executeJob - Error", e);
            throw new BatchException(e);
        }
        logger.debug("QueueClientTestJob - executeJob - end");
        return ret;
    }
}

