//////////////////////////////////////////////////////////
//
//	MglProjectionMatrixManager
//		- DirectX Graphics ǗNX
//
//////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MglProjectionMatrixManager.h"

//	RXgN^
CMglProjectionMatrixManager::CMglProjectionMatrixManager()
{
	m_fAspectRatio = 640.0f/480.0f;
	m_fViewingAngle = 45.0f;
	m_fClipNear = 0.01f;
	m_fClipFar = 100.0f;
}

//	fXgN^
CMglProjectionMatrixManager::~CMglProjectionMatrixManager()
{
}

//	J
void CMglProjectionMatrixManager::Release()
{
}

//	
void CMglProjectionMatrixManager::Init( CMglGraphicManager* in_myudg )
{
	CMglDgBase::Init(in_myudg);

	//	Projection̐ݒ
	SetupProjection( (m_myudg->GetWidth()*1.0f) / m_myudg->GetHeight());
}

//	Projection̐ݒ
void CMglProjectionMatrixManager::SetupProjection( float fAspectRatio, float fViewingAngle, float fClipNear, float fClipFar )
{
	InitCheck();

	//D3DXMATRIX matPrj;
#if _MGL3D_COORDINATE_USE == _MGL3D_COORDINATE_LEFT_HAND
	D3DXMatrixPerspectiveFovLH(
#else
	D3DXMatrixPerspectiveFovRH(
#endif	
					&m_projection,
					D3DXToRadian(fViewingAngle),		// p
					fAspectRatio,			// AXyNgicA䗦j
					fClipNear,				// Near Nbv
					fClipFar);				// Far  Nbv
	/*				D3DXToRadian(45.0),		// p
					640.0f / 480.0f,		// AXyNgicA䗦j
					clip_near,				// Near Nbv
					clip_far);				// Far  Nbv*/
	MyuAssert( m_pD3dDev->SetTransform(D3DTS_PROJECTION, &m_projection), D3D_OK,
		"CMglProjectionMatrixManager::SetupProjection()  SetTransform()Ɏs" );

	m_fAspectRatio = fAspectRatio;
	m_fViewingAngle = fViewingAngle;
	m_fClipNear = fClipNear;
	m_fClipFar = fClipFar;

//D3D_COORDINATE	g_WorldFrame(D3DXVECTOR3(1,1,1), D3DXVECTOR3(0,0,0), D3DXVECTOR3(0,0,0));
}

//	ReTransform
void CMglProjectionMatrixManager::ReTransform()
{
	InitCheck();

	//	vWFNV
	MyuAssert( m_pD3dDev->SetTransform(D3DTS_PROJECTION, &m_projection), D3D_OK,
		"CMglProjectionMatrixManager::SetupProjection()  SetTransform()Ɏs" );
}

//	Projectionݒ
void CMglProjectionMatrixManager::SetProjectionMatrix(D3DXMATRIX &matProjection)
{
	InitCheck();
	m_projection = matProjection;
	MyuAssert( m_pD3dDev->SetTransform(D3DTS_PROJECTION, &m_projection), D3D_OK,
		"CMglProjectionMatrixManager::SetupProjection()  SetTransform()Ɏs" );
}
