//////////////////////////////////////////////////////////
//
//	MglLayer3
//		- MglGraphicManager C[NX
//
//////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MglLayer3.h"

//	RXgN^
CMglLayer3::CMglLayer3()
{
	m_myudg = NULL;
	m_d3d = NULL;
}

//	fXgN^
CMglLayer3::~CMglLayer3()
{

}

///////////////////////////////////////////////////////

//	o^
void CMglLayer3::Regist( CMglImage *pImage, int depth, float x, float y, 
	BOOL bShow, D3DCOLOR color, float fScaleX, float fScaleY, float fAngle )
{
	if ( m_list.find(depth) != m_list.end() )
		MyuThrow( 66126, "CMglLayer3::Regist() depth=%d ͊ɂ܂B", depth );

	LAYERINFO t;
	ZeroMemory(&t,sizeof(t));

	/*
	t.bShow = bShow;
	t.color = color;
	t.x = x;
	t.y = y;
	t.fScaleX = fScaleX;
	t.fScaleY = fScaleY;
	t.fAngle = fAngle;
	*/
	t.pImage = pImage;

	m_list[depth] = t;

	SetParam(depth,x,y,bShow,color,fScaleX,fScaleY,fAngle);
}

//	p[^ݒ
void CMglLayer3::SetParam( int depth, float x, float y, 
	BOOL bShow, D3DCOLOR color, float fScaleX, float fScaleY, float fAngle )
{
	ExistChk(depth);

	m_list[depth].bShow = bShow;
	m_list[depth].color = color;
	m_list[depth].x = x;
	m_list[depth].y = y;
	m_list[depth].fScaleX = fScaleX;
	m_list[depth].fScaleY = fScaleY;
	m_list[depth].fAngle = fAngle;

	m_list[depth].fRotationCenterX = 0.5f;
	m_list[depth].fRotationCenterY = 0.5f;
}

//	ړ
void CMglLayer3::Move( int depth, float x, float y )
{
	ExistChk(depth);
	m_list[depth].x += x;
	m_list[depth].y += y;
}

//	p[^ݒiʒuj
void CMglLayer3::SetPos( int depth, float x, float y )
{
	ExistChk(depth);
	m_list[depth].x = x;
	m_list[depth].y = y;
}

//	p[^ݒiFj
void CMglLayer3::SetColor( int depth, D3DCOLOR color )
{
	ExistChk(depth);
	m_list[depth].color = color;
}

//	p[^ݒikڗj
void CMglLayer3::SetScale( int depth, float fScaleX, float fScaleY )
{
	ExistChk(depth);
	m_list[depth].fScaleX = fScaleX;
	m_list[depth].fScaleY = fScaleY;
}

//	p[^ݒipxj
void CMglLayer3::SetAngle( int depth, float fAngle )
{
	ExistChk(depth);
	m_list[depth].fAngle = fAngle;
}

//	p[^ݒi`j
void CMglLayer3::SetRect( int depth, RECT rect )
{
	ExistChk(depth);
	m_list[depth].rect = rect;
}

//	p[^ݒi]̒Sj
void CMglLayer3::SetRotationCenter( int depth, float fRotationCenterX, float fRotationCenterY )
{
	ExistChk(depth);
	m_list[depth].fRotationCenterX = fRotationCenterX;
	m_list[depth].fRotationCenterY = fRotationCenterY;
}

////////////////////////////////////////////////////////////////

//	`
void CMglLayer3::Rendering()
{
	InitCheck();

	//	2008/02/17  \̏ԋtƎvEEEi끁Ԑ[̂`悵Ăׂj
	//	[v
	//for ( LIST_ITR it = m_list.begin(); it != m_list.end(); it++ )
	/*LIST_ITR it = m_list.end();
	for(;;)*/
	for( LIST_RITR it = m_list.rbegin(); it != m_list.rend(); it++ )
	{
		//it--;

		LAYERINFO& t = it->second;
		CMglImage* pImage = t.pImage;

		if ( t.bShow == TRUE )
		{
			//pSfc->XDraw();
			//pSfc->Draw( pInfo->rect.left, pInfo->rect.top, NULL, pInfo->color );

			RECT* pRect = &t.rect;
			if ( pRect->left == 0 && pRect->right == 0 && pRect->top == 0 && pRect->bottom == 0 )
				pRect = NULL;

			//	`
			pImage->Draw(t.x, t.y, pRect, t.color,
				t.fScaleX, t.fScaleY, t.fRotationCenterX, t.fRotationCenterY, t.fAngle );

			/*
			if ( pInfo->rect.left == pInfo->rect.right || pInfo->rect.top == pInfo->rect.bottom )
				pSfc->Draw( pInfo->rect.left, pInfo->rect.top, NULL, pInfo->color );
			else
				pSfc->Draw( pInfo->rect.left, pInfo->rect.top, &pInfo->rect, pInfo->color );
			*/
		}

		/*if ( it == m_list.begin() )
			break;*/
	}

	m_myudg->UpdateScreen();
}

