//////////////////////////////////////////////////////////
//
//	AugustSound
//		- MglGraphicManager C[NX
//
//////////////////////////////////////////////////////////

#include "stdafx.h"
#include "AugustSound.h"

#include "MglAudio.h"
#include "MglCoManager.h"
#include "AugustScreen2.h"

#include <time.h>

using namespace agh;
using namespace std;

///////////////////////////////////////////////////////////////////////

//	RXgN^
CAugustSoundManager::CAugustSoundManager()
{
	m_pCore = new _MGL_AUGUST_SOUND_CORE_IMPL();
}

//	fXgN^
CAugustSoundManager::~CAugustSoundManager()
{
	delete m_pCore;
}

//	o^InitĂяo
void CAugustSoundManager::OnRegist()
{
	//CoInitialize(NULL);
	g_coManager.Init();

	HWND hWnd = (HWND)MyuAssertNull(GetValPtr(MWLAGH_VALKEY_ROOT_WINDOW_HWND),
		"CAugustSoundManager::OnRegist()  EChEnhGetValPtr()Ɏs");

	((_MGL_AUGUST_SOUND_CORE_IMPL*)m_pCore)->Init(hWnd);

	//	2009/09/05  EChEOReleaseĂ炤悤ɂ
	CAugustScreen2_X* pScreen = (CAugustScreen2_X*)MyuAssertNull(GetValPtr(AUGUST_VALKEY_SCREEN),
		"CAugustSoundManager::OnRegist()  CAugustScreen2GetValPtr()Ɏs");
	pScreen->AddToReleaseList( m_pCore );

	//	2009/09/26
	SetValPtr(AUGUST_VALKEY_P_SOUNDMGR, this);
	pScreen->SetValPtr(AUGUST_VALKEY_P_SOUNDMGR, this);
}

void CAugustSoundManager::Load( const char* szAudioFile, const char* szAlias ){ m_pCore->Load(szAudioFile, szAlias); }
void CAugustSoundManager::Play( const char* szName ){ m_pCore->Play(szName); }
void CAugustSoundManager::LoopPlay( const char* szName, unsigned long nLoopCount ){ m_pCore->LoopPlay(szName, nLoopCount); }
void CAugustSoundManager::Stop( const char* szName ){ m_pCore->Stop(szName); }
void CAugustSoundManager::SetVolume( float fVolume ){ m_pCore->SetVolume((fVolume-100)*10); }
void CAugustSoundManager::Disable(){ m_pCore->Disable(); }
void CAugustSoundManager::Enable(){ m_pCore->Enable(); }
bool CAugustSoundManager::IsAlreadyUsedAlias( const char* szName ){ return WINBOOL_TO_CPPBOOL( m_pCore->IsExist(szName) ); }



/**************************************************************************************************/

//	RXgN^
CAugustSound::CAugustSound()
	: CAugustControlBase("CAugustSound")
{
	m_pMgr = NULL;
	m_bMultiplePlay = true;
}

//	o^InitĂяo
void CAugustSound::OnRegist()
{
	m_pMgr = (CAugustSoundManager*)MyuAssertNull(GetValPtr(AUGUST_VALKEY_P_SOUNDMGR),
		"CAugustSound::OnRegist()  AUGUST_VALKEY_P_SOUNDMGR GetValPtr()Ɏs");
}

void CAugustSound::Load( const char* szAudioFile )
{
	RegistedCheck();

	m_name = szAudioFile;
	mtsrand();
	SelectUniqueName( /*szAudioFile*/ );

	m_pMgr->Load(szAudioFile);
}

void CAugustSound::SelectUniqueName( /*const char* szName*/ )
{
	if ( m_pMgr->IsAlreadyUsedAlias( m_name.c_str() ) )
	{
		m_name += mtrand();

		SelectUniqueName( /*szAudioFile*/ );
	}
}

void CAugustSound::Play()
{
	RegistedCheck();
	if ( !m_bMultiplePlay )
		Stop();
	m_pMgr->Play( m_name.c_str() );
}

void CAugustSound::LoopPlay( unsigned long nLoopCount )
{
	RegistedCheck();
	if ( !m_bMultiplePlay )
		Stop();
	m_pMgr->LoopPlay( m_name.c_str(), nLoopCount );
}

void CAugustSound::Stop()
{
	RegistedCheck();
	m_pMgr->Stop( m_name.c_str() );
}
