/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tm.impl;

import java.rmi.RemoteException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Status;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.Resource;
import tyrex.services.Clock;
import tyrex.tm.TyrexTransaction;
import tyrex.tm.XAResourceCallback;
import tyrex.tm.impl.ControlImpl;
import tyrex.tm.impl.NestedSystemException;
import tyrex.tm.impl.ResourceImpl;
import tyrex.tm.impl.ThreadContext;
import tyrex.tm.impl.TransactionDomainImpl;
import tyrex.tm.impl.Util;
import tyrex.tm.impl.XAResourceHelper;
import tyrex.tm.impl.XAResourceHelperManager;
import tyrex.tm.impl.XAResourceHolder;
import tyrex.tm.xid.BaseXid;
import tyrex.tm.xid.XidUtils;
import tyrex.util.Messages;

final class TransactionImpl
implements TyrexTransaction,
Status {
    protected final BaseXid _xid;
    protected final int _hashCode;
    private Synchronization[] _syncs;
    private InternalXAResourceHolder _enlisted;
    private InternalXAResourceHolder _delisted;
    private Resource[] _resources;
    protected int _status;
    protected SystemException _sysError;
    private boolean _timedOut;
    private final PropagationContext _pgContext;
    protected int _heuristic = 0;
    private ControlImpl _control;
    protected final TransactionDomainImpl _txDomain;
    protected final TransactionImpl _parent;
    private boolean _twoPhase;
    protected long _timeout;
    protected final long _started;
    protected TransactionImpl _nextEntry;

    TransactionImpl(BaseXid baseXid, TransactionImpl transactionImpl, TransactionDomainImpl transactionDomainImpl, long l) {
        if (baseXid == null) {
            throw new IllegalArgumentException("Argument xid is null");
        }
        if (transactionDomainImpl == null) {
            throw new IllegalArgumentException("Argument txDomain is null");
        }
        this._xid = baseXid;
        this._hashCode = baseXid.hashCode();
        this._txDomain = transactionDomainImpl;
        this._pgContext = null;
        this._parent = transactionImpl;
        this._status = 0;
        this._started = Clock.clock();
        this._timeout = this._started + l;
        if (transactionImpl != null) {
            try {
                transactionImpl.registerResource(new ResourceImpl(this));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    TransactionImpl(BaseXid baseXid, PropagationContext propagationContext, TransactionDomainImpl transactionDomainImpl, long l) throws Inactive {
        if (baseXid == null) {
            throw new IllegalArgumentException("Argument xid is null");
        }
        if (transactionDomainImpl == null) {
            throw new IllegalArgumentException("Argument txDomain is null");
        }
        if (propagationContext == null) {
            throw new IllegalArgumentException("Argument pgContext is null");
        }
        this._xid = baseXid;
        this._hashCode = baseXid.hashCode();
        this._txDomain = transactionDomainImpl;
        this._pgContext = propagationContext;
        this._parent = null;
        this._status = 0;
        this._started = Clock.clock();
        this._timeout = this._started + l;
        try {
            ResourceImpl resourceImpl = new ResourceImpl(this);
            if (this._txDomain._orb != null) {
                this._txDomain._orb.connect((Object)resourceImpl);
            }
            this._pgContext.current.coord.register_resource((Resource)resourceImpl);
        }
        catch (RuntimeException runtimeException) {
            throw new Inactive();
        }
        catch (Inactive inactive) {
            throw inactive;
        }
        this._control = new ControlImpl(this, this._pgContext);
    }

    TransactionImpl(BaseXid baseXid, int n, TransactionDomainImpl transactionDomainImpl) {
        if (baseXid == null) {
            throw new IllegalArgumentException("Argument xid is null");
        }
        if (transactionDomainImpl == null) {
            throw new IllegalArgumentException("Argument txDomain is null");
        }
        this._xid = baseXid;
        this._hashCode = baseXid.hashCode();
        this._txDomain = transactionDomainImpl;
        this._pgContext = null;
        this._parent = null;
        this._started = 0L;
        this._timeout = 0L;
        switch (n) {
            case 0: 
            case 3: {
                this._heuristic = 1;
                this._status = 2;
                break;
            }
            case 7: {
                this._heuristic = 1;
                this._status = 3;
                break;
            }
            case 6: {
                this._heuristic = 2;
                this._status = 4;
                break;
            }
            case 5: {
                this._heuristic = 4;
                this._status = 4;
                break;
            }
            case 8: {
                this._heuristic = 8;
                this._status = 4;
                break;
            }
            case 106: {
                this._heuristic = 16;
                this._status = 4;
                break;
            }
            default: {
                this._heuristic = n >= 100 && n <= 107 ? 2 : 32;
                this._sysError = new SystemException(Util.getHeuristic(n));
                this._status = 4;
            }
        }
        this._twoPhase = true;
    }

    public String toString() {
        return this._xid.toString();
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(java.lang.Object object) {
        return this == object;
    }

    public int getStatus() {
        return this._status;
    }

    public synchronized void registerSynchronization(Synchronization synchronization) throws RollbackException, IllegalStateException, SystemException {
        if (synchronization == null) {
            throw new IllegalArgumentException("Argument sync is null");
        }
        if (this._timedOut) {
            throw new RollbackException(Messages.message("tyrex.tx.timedOut"));
        }
        switch (this._status) {
            case 0: {
                break;
            }
            case 1: {
                throw new RollbackException(Messages.message("tyrex.tx.markedRollback"));
            }
            case 2: 
            case 7: 
            case 8: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inCommit"));
            }
            default: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inactive"));
            }
        }
        if (this._syncs == null) {
            this._syncs = new Synchronization[2];
            this._syncs[0] = synchronization;
        } else {
            Synchronization[] synchronizationArray = this._syncs;
            int n = synchronizationArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (synchronizationArray[n2] == synchronization) {
                    return;
                }
                if (synchronizationArray[n2] == null) {
                    synchronizationArray[n2] = synchronization;
                    return;
                }
                ++n2;
            }
            synchronizationArray = new Synchronization[n * 2];
            int n3 = n;
            while (n3-- > 0) {
                synchronizationArray[n3] = this._syncs[n3];
            }
            synchronizationArray[n] = synchronization;
            this._syncs = synchronizationArray;
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        if (this._status == 1) {
            try {
                this.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RollbackException(Messages.message("tyrex.tx.rolledback"));
        }
        if (this._status == 4 || this._status == 9) {
            throw new RollbackException(Messages.message("tyrex.tx.rolledback"));
        }
        if (this._parent != null || this._pgContext != null) {
            return;
        }
        this.commit(this.canUseOnePhaseCommit());
    }

    public synchronized void rollback() throws IllegalStateException, SystemException {
        try {
            this.internalRollback();
            java.lang.Object var2_1 = null;
            this._txDomain.notifyRollback(this);
        }
        catch (Throwable throwable) {
            java.lang.Object var2_2 = null;
            this._txDomain.notifyRollback(this);
            try {
                this.forget(2);
            }
            catch (IllegalStateException illegalStateException) {
                this._txDomain._category.error((java.lang.Object)"Internal error", (Throwable)illegalStateException);
            }
            throw throwable;
        }
        try {
            this.forget(2);
        }
        catch (IllegalStateException illegalStateException) {
            this._txDomain._category.error((java.lang.Object)"Internal error", (Throwable)illegalStateException);
        }
        if (this._parent != null) {
            this._parent.unregisterResource(new ResourceImpl(this));
        }
        if (this._sysError != null) {
            throw this._sysError;
        }
    }

    public boolean enlistResource(XAResource xAResource) throws IllegalStateException, SystemException, RollbackException {
        return this.enlistResource(xAResource, null);
    }

    synchronized boolean enlistResource(XAResource xAResource, XAResourceCallback xAResourceCallback) throws IllegalStateException, SystemException, RollbackException {
        if (xAResource == null) {
            throw new IllegalArgumentException("Argument xaResource is null");
        }
        if (this._timedOut) {
            throw new RollbackException(Messages.message("tyrex.tx.timedOut"));
        }
        switch (this._status) {
            case 0: {
                break;
            }
            case 1: {
                throw new RollbackException(Messages.message("tyrex.tx.markedRollback"));
            }
            case 2: 
            case 7: 
            case 8: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inCommit"));
            }
            default: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inactive"));
            }
        }
        if (this._enlisted != null) {
            InternalXAResourceHolder internalXAResourceHolder = this._enlisted;
            InternalXAResourceHolder internalXAResourceHolder2 = null;
            while (internalXAResourceHolder != null) {
                if (internalXAResourceHolder._xaResource == xAResource) {
                    if (internalXAResourceHolder._endFlag == 0x2000000) {
                        try {
                            xAResource.start(internalXAResourceHolder._xid, 0x8000000);
                            internalXAResourceHolder._endFlag = 0;
                            return true;
                        }
                        catch (XAException xAException) {
                            xAException.printStackTrace();
                            throw new NestedSystemException(xAException);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            throw new NestedSystemException(exception);
                        }
                    }
                    return false;
                }
                internalXAResourceHolder2 = internalXAResourceHolder;
                internalXAResourceHolder = internalXAResourceHolder._nextHolder;
            }
            internalXAResourceHolder = this._delisted;
            while (internalXAResourceHolder != null) {
                if (internalXAResourceHolder._xaResource == xAResource) {
                    if (internalXAResourceHolder._endFlag == 0x4000000) {
                        try {
                            xAResource.start(internalXAResourceHolder._xid, 0x200000);
                            internalXAResourceHolder._endFlag = 0;
                            if (null == internalXAResourceHolder2) {
                                this._delisted = internalXAResourceHolder._nextHolder;
                            } else {
                                internalXAResourceHolder2._nextHolder = internalXAResourceHolder._nextHolder;
                            }
                            internalXAResourceHolder._nextHolder = null == this._enlisted ? null : this._enlisted._nextHolder;
                            this._enlisted = internalXAResourceHolder;
                            return true;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            throw new NestedSystemException(exception);
                        }
                    }
                    return false;
                }
                internalXAResourceHolder = internalXAResourceHolder._nextHolder;
            }
        }
        return this.addNewResource(xAResource, xAResourceCallback);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean delistResource(XAResource xAResource, int n) throws IllegalStateException, SystemException {
        if (xAResource == null) {
            throw new IllegalArgumentException("Argument xaResource is null");
        }
        switch (this._status) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inCommit"));
            }
            default: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inactive"));
            }
        }
        InternalXAResourceHolder internalXAResourceHolder = this._enlisted;
        InternalXAResourceHolder internalXAResourceHolder2 = null;
        while (internalXAResourceHolder != null && internalXAResourceHolder._xaResource != xAResource) {
            internalXAResourceHolder2 = internalXAResourceHolder;
            internalXAResourceHolder = internalXAResourceHolder._nextHolder;
        }
        if (internalXAResourceHolder == null) {
            return false;
        }
        switch (n) {
            case 0x2000000: {
                try {
                    xAResource.end(internalXAResourceHolder._xid, 0x2000000);
                    internalXAResourceHolder._endFlag = 0x2000000;
                    return true;
                }
                catch (XAException xAException) {
                    return false;
                }
                catch (Exception exception) {
                    throw new NestedSystemException(exception);
                }
            }
            case 0x4000000: 
            case 0x20000000: {
                boolean bl;
                try {
                    try {
                        if (internalXAResourceHolder2 == null) {
                            this._enlisted = internalXAResourceHolder._nextHolder;
                        } else {
                            internalXAResourceHolder2._nextHolder = internalXAResourceHolder._nextHolder;
                        }
                        if (n == 0x20000000) {
                            xAResource.end(internalXAResourceHolder._xid, 0x20000000);
                            if (null != internalXAResourceHolder._callback) {
                                internalXAResourceHolder._callback.fail(internalXAResourceHolder._xid);
                            }
                        } else {
                            xAResource.end(internalXAResourceHolder._xid, 0x4000000);
                            internalXAResourceHolder._nextHolder = this._delisted;
                            this._delisted = internalXAResourceHolder;
                        }
                        internalXAResourceHolder._endFlag = n;
                        bl = true;
                        java.lang.Object var8_11 = null;
                        if (n != 0x20000000) return bl;
                    }
                    catch (XAException xAException) {
                        boolean bl2 = false;
                        java.lang.Object var8_12 = null;
                        if (n != 0x20000000) return bl2;
                        this.setRollbackOnly();
                        return bl2;
                    }
                    catch (Exception exception) {
                        throw new NestedSystemException(exception);
                    }
                }
                catch (Throwable throwable) {
                    java.lang.Object var8_13 = null;
                    if (n == 0x20000000) {
                        this.setRollbackOnly();
                    }
                    throw throwable;
                }
                this.setRollbackOnly();
                return bl;
            }
        }
        throw new IllegalArgumentException(Messages.message("tyrex.tx.invalidFlag"));
    }

    public synchronized void setRollbackOnly() throws IllegalStateException, SystemException {
        switch (this._status) {
            case 0: 
            case 1: {
                this._status = 1;
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inCommit"));
            }
            case 4: 
            case 9: {
                return;
            }
            default: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inactive"));
            }
        }
    }

    public void setTransactionTimeout(int n) {
        this._txDomain.setTransactionTimeout(this, n);
    }

    public synchronized void asyncCommit() throws SystemException, SecurityException, RollbackException {
        this.suspendTransaction();
        if (this._status == 1) {
            this._heuristic = 2;
            throw new RollbackException(Messages.message("tyrex.tx.rolledback"));
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                boolean bl = false;
                TransactionImpl transactionImpl = TransactionImpl.this;
                synchronized (transactionImpl) {
                    try {
                        TransactionImpl.this.commit();
                    }
                    catch (Exception exception) {
                        bl = true;
                    }
                }
            }
        });
        thread.start();
    }

    public synchronized void asyncRollback() throws IllegalStateException, SystemException, SecurityException {
        this.suspendTransaction();
        if (null != this._sysError) {
            throw this._sysError;
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                boolean bl = false;
                TransactionImpl transactionImpl = TransactionImpl.this;
                synchronized (transactionImpl) {
                    try {
                        TransactionImpl.this.rollback();
                    }
                    catch (Exception exception) {
                        bl = true;
                    }
                }
            }
        });
        this._txDomain.enlistThread(this, ThreadContext.getThreadContext(thread), thread);
        thread.start();
    }

    public boolean canUseOnePhaseCommit() {
        if (null != this._resources && 1 < this._resources.length) {
            return false;
        }
        if (null == this._enlisted && null == this._delisted) {
            return true;
        }
        if (null != this._resources && (null != this._enlisted || null != this._delisted)) {
            return false;
        }
        if (null != this._enlisted && this._enlisted._nextHolder != null && null == this._delisted) {
            return true;
        }
        if (null != this._delisted && this._delisted._nextHolder != null && null == this._enlisted) {
            return true;
        }
        if (null != this._enlisted) {
            if (!this.areXaResourcesShared(this._enlisted, false)) {
                return false;
            }
            if (null != this._delisted) {
                return this.areXaResourcesShared(this._delisted, true);
            }
            return true;
        }
        if (null != this._delisted) {
            return this.areXaResourcesShared(this._delisted, false);
        }
        return true;
    }

    public synchronized void onePhaseCommit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        Thread thread = Thread.currentThread();
        ThreadContext threadContext = ThreadContext.getThreadContext(thread);
        if (this._status == 1) {
            try {
                this.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RollbackException(Messages.message("tyrex.tx.rolledback"));
        }
        if (this._status == 4 || this._status == 9) {
            throw new RollbackException(Messages.message("tyrex.tx.rolledback"));
        }
        if (this._parent != null || this._pgContext != null) {
            return;
        }
        this.commit(true);
        this._txDomain.delistThread(threadContext, thread);
    }

    public Transaction getParent() {
        return this._parent;
    }

    public Transaction getTopLevel() {
        if (this._parent == null) {
            return this;
        }
        return this._parent.getTopLevel();
    }

    public long getTimeout() {
        return this._timeout;
    }

    public long getStarted() {
        return this._started;
    }

    public Xid getXid() {
        return this._xid;
    }

    public synchronized Control getControl() {
        if (this._control == null) {
            this._control = new ControlImpl(this);
            if (this._txDomain._orb != null) {
                this._txDomain._orb.connect((Object)this._control);
            }
        }
        return this._control;
    }

    protected void prepare() throws IllegalStateException, RollbackException {
        InternalXAResourceHolder internalXAResourceHolder;
        if (this._timedOut) {
            throw new RollbackException(Messages.message("tyrex.tx.timedOut"));
        }
        switch (this._status) {
            case 0: {
                break;
            }
            case 2: {
                return;
            }
            case 7: 
            case 8: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inCommit"));
            }
            case 1: {
                this._heuristic = 2;
                return;
            }
            case 4: {
                throw new RollbackException(Messages.message("tyrex.tx.rolledback"));
            }
            case 9: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inRollback"));
            }
            default: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inactive"));
            }
        }
        if (this._syncs != null) {
            this.beforeCompletion();
            if (this._status == 1) {
                this._heuristic = 2;
                return;
            }
        }
        this._heuristic = 0;
        this._status = 7;
        int n = 0;
        if (this._resources != null) {
            int n2 = this._resources.length;
            while (n2-- > 0) {
                if (this._heuristic != 0 && this._heuristic != 1) break;
                Resource resource = this._resources[n2];
                if (resource == null) continue;
                try {
                    int n3 = resource.prepare().value();
                    if (n3 == 2) {
                        this._resources[n2] = null;
                        continue;
                    }
                    if (n3 == 0) {
                        ++n;
                        continue;
                    }
                    if (n3 != 1) continue;
                    this._heuristic |= 2;
                    this._resources[n2] = null;
                }
                catch (HeuristicMixed heuristicMixed) {
                    this._heuristic |= 4;
                }
                catch (HeuristicHazard heuristicHazard) {
                    this._heuristic |= 8;
                }
                catch (Exception exception) {
                    if (exception instanceof TRANSACTION_ROLLEDBACK) {
                        this._heuristic |= 2;
                        continue;
                    }
                    this._heuristic |= 8;
                    this.error(exception);
                }
            }
        }
        if ((internalXAResourceHolder = this._enlisted) != null) {
            this.endEnlistedResourcesForCommit();
            internalXAResourceHolder = this._enlisted;
            while (internalXAResourceHolder != null) {
                if (this._heuristic != 0 && this._heuristic != 1) break;
                try {
                    if (!internalXAResourceHolder._shared) {
                        if (internalXAResourceHolder._xaResource.prepare(internalXAResourceHolder._xid) == 3) {
                            internalXAResourceHolder._readOnly = true;
                        } else {
                            ++n;
                        }
                    }
                }
                catch (XAException xAException) {
                    this.xaError(internalXAResourceHolder, xAException);
                }
                catch (Exception exception) {
                    this._heuristic |= 8;
                    this.error(exception);
                }
                internalXAResourceHolder = internalXAResourceHolder._nextHolder;
            }
        }
        if ((internalXAResourceHolder = this._delisted) != null) {
            while (internalXAResourceHolder != null) {
                if (this._heuristic != 0 && this._heuristic != 1) break;
                try {
                    if (!internalXAResourceHolder._shared) {
                        if (internalXAResourceHolder._xaResource.prepare(internalXAResourceHolder._xid) == 3) {
                            internalXAResourceHolder._readOnly = true;
                        } else {
                            ++n;
                        }
                    }
                }
                catch (XAException xAException) {
                    this.xaError(internalXAResourceHolder, xAException);
                }
                catch (Exception exception) {
                    this._heuristic |= 8;
                    this.error(exception);
                }
                internalXAResourceHolder = internalXAResourceHolder._nextHolder;
            }
        }
        this._status = 2;
        this._heuristic = this._heuristic == 0 && n > 0 ? 1 : this.normalize(this._heuristic);
        if (this._heuristic != 0) {
            this._twoPhase = true;
            if (this._txDomain._journal != null) {
                int n4;
                switch (this._heuristic) {
                    case 1: {
                        n4 = 7;
                        break;
                    }
                    case 2: {
                        n4 = 6;
                        break;
                    }
                    case 4: {
                        n4 = 5;
                        break;
                    }
                    case 8: {
                        n4 = 8;
                        break;
                    }
                    default: {
                        n4 = 104;
                    }
                }
                try {
                    this._txDomain._journal.prepare(this._xid, n4);
                }
                catch (SystemException systemException) {
                    this.error(systemException);
                }
            }
        }
    }

    protected void internalCommit(boolean bl) throws IllegalStateException {
        if (this._status == 3 || this._status == 4) {
            return;
        }
        if (!bl && this._status != 2 || bl && this._status != 8) {
            throw new IllegalStateException(Messages.message("tyrex.tx.notPrepared"));
        }
        this._status = 8;
        this._heuristic = 0;
        if (this._resources != null) {
            int n = this._resources.length;
            while (n-- > 0) {
                Resource resource = this._resources[n];
                if (resource == null) continue;
                try {
                    if (bl) {
                        resource.commit_one_phase();
                    } else {
                        resource.commit();
                    }
                    this._heuristic |= 1;
                }
                catch (HeuristicMixed heuristicMixed) {
                    this._heuristic |= 4;
                }
                catch (HeuristicHazard heuristicHazard) {
                    this._heuristic |= 8;
                }
                catch (HeuristicRollback heuristicRollback) {
                    this._heuristic |= 2;
                }
                catch (Exception exception) {
                    if (exception instanceof TRANSACTION_ROLLEDBACK) {
                        this._heuristic |= 2;
                        continue;
                    }
                    this._heuristic |= 8;
                    this.error(exception);
                }
            }
        }
        if (this._enlisted != null) {
            this.commitXAResources(this._enlisted, bl);
        }
        if (this._delisted != null) {
            this.commitXAResources(this._delisted, bl);
        }
        this._status = 3;
        this._heuristic = this.normalize(this._heuristic);
        this._txDomain.notifyCompletion(this, this._heuristic);
        if (this._txDomain._journal != null) {
            int n;
            switch (this._heuristic) {
                case 1: {
                    n = 7;
                    break;
                }
                case 2: {
                    n = 6;
                    this._twoPhase = true;
                    break;
                }
                case 4: {
                    n = 5;
                    this._twoPhase = true;
                    break;
                }
                case 8: {
                    n = 8;
                    this._twoPhase = true;
                    break;
                }
                default: {
                    n = 104;
                    this._twoPhase = true;
                }
            }
            if (this._twoPhase) {
                try {
                    this._txDomain._journal.commit(this._xid, n);
                }
                catch (SystemException systemException) {
                    this.error(systemException);
                }
            }
        }
    }

    protected void internalRollback() {
        InternalXAResourceHolder internalXAResourceHolder;
        switch (this._status) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inCommit"));
            }
            case 9: {
                this._heuristic = 2;
                return;
            }
            default: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inactive"));
            }
            case 3: 
            case 4: {
                return;
            }
        }
        this._status = 9;
        this._heuristic = 0;
        if (this._resources != null) {
            int n = this._resources.length;
            while (n-- > 0) {
                Resource resource = this._resources[n];
                if (resource == null) continue;
                try {
                    resource.rollback();
                    this._heuristic |= 2;
                    this._resources[n] = null;
                }
                catch (HeuristicMixed heuristicMixed) {
                    this._heuristic |= 4;
                }
                catch (HeuristicHazard heuristicHazard) {
                    this._heuristic |= 8;
                }
                catch (HeuristicCommit heuristicCommit) {
                    this._heuristic |= 1;
                }
                catch (Exception exception) {
                    this._heuristic |= 8;
                    this.error(exception);
                }
            }
        }
        if ((internalXAResourceHolder = this._enlisted) != null) {
            while (internalXAResourceHolder != null) {
                try {
                    this.endForTransactionBoundary(internalXAResourceHolder);
                }
                catch (XAException xAException) {
                    this.xaError(internalXAResourceHolder, xAException);
                }
                catch (Exception exception) {
                    this._heuristic |= 8;
                    this.error(exception);
                }
                internalXAResourceHolder = internalXAResourceHolder._nextHolder;
            }
            this.rollbackXAResources(this._enlisted);
        }
        if (this._delisted != null) {
            this.rollbackXAResources(this._delisted);
        }
        this._status = 4;
        this._heuristic = this.normalize(this._heuristic);
        this._txDomain.notifyCompletion(this, this._heuristic);
        if (this._txDomain._journal != null) {
            if (this._timedOut || this._heuristic != 2) {
                this._twoPhase = true;
            }
            if (this._twoPhase) {
                try {
                    this._txDomain._journal.rollback(this._xid);
                }
                catch (SystemException systemException) {
                    this.error(systemException);
                }
            }
        }
    }

    protected synchronized void suspendResources() throws IllegalStateException, SystemException {
        switch (this._status) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inCommit"));
            }
            default: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inactive"));
            }
        }
        InternalXAResourceHolder internalXAResourceHolder = this._enlisted;
        while (internalXAResourceHolder != null) {
            if (internalXAResourceHolder._endFlag == 0) {
                try {
                    internalXAResourceHolder._xaResource.end(internalXAResourceHolder._xid, 0x2000000);
                    internalXAResourceHolder._endFlag = 0x2000000;
                }
                catch (XAException xAException) {
                    this.xaError(internalXAResourceHolder, xAException);
                    throw new NestedSystemException(xAException);
                }
                catch (Exception exception) {
                    throw new NestedSystemException(exception);
                }
            }
            internalXAResourceHolder = internalXAResourceHolder._nextHolder;
        }
    }

    protected synchronized void resumeAndEnlistResources(XAResourceHolder[] xAResourceHolderArray) throws IllegalStateException, SystemException, RollbackException {
        block10: {
            block9: {
                if (this._enlisted == null) break block9;
                InternalXAResourceHolder internalXAResourceHolder = this._enlisted;
                while (internalXAResourceHolder != null) {
                    if (internalXAResourceHolder._endFlag == 0x2000000) {
                        try {
                            internalXAResourceHolder._xaResource.start(internalXAResourceHolder._xid, 0x8000000);
                            internalXAResourceHolder._endFlag = 0;
                        }
                        catch (XAException xAException) {
                            this.xaError(internalXAResourceHolder, xAException);
                        }
                        catch (Exception exception) {
                            throw new NestedSystemException(exception);
                        }
                    }
                    internalXAResourceHolder = internalXAResourceHolder._nextHolder;
                }
                if (null == xAResourceHolderArray) break block10;
                int n = xAResourceHolderArray.length;
                while (n-- > 0) {
                    XAResourceHolder xAResourceHolder = xAResourceHolderArray[n];
                    internalXAResourceHolder = this._enlisted;
                    while (internalXAResourceHolder != null) {
                        if (internalXAResourceHolder._xaResource == xAResourceHolder._xaResource) break;
                        internalXAResourceHolder = internalXAResourceHolder._nextHolder;
                    }
                    if (internalXAResourceHolder != null) continue;
                    this.addNewResource(xAResourceHolder._xaResource, xAResourceHolder._callback);
                }
                break block10;
            }
            if (null != xAResourceHolderArray) {
                int n = xAResourceHolderArray.length;
                while (n-- > 0) {
                    this.addNewResource(xAResourceHolderArray[n]._xaResource, xAResourceHolderArray[n]._callback);
                }
            }
        }
    }

    protected synchronized void registerResource(Resource resource) throws IllegalStateException {
        if (resource == null) {
            throw new IllegalArgumentException("Argument resource is null");
        }
        switch (this._status) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inCommit"));
            }
            default: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inactive"));
            }
        }
        if (this._resources == null) {
            this._resources = new Resource[]{resource};
        } else {
            int n = this._resources.length;
            while (n-- > 0) {
                if (this._resources[n] != resource) continue;
                return;
            }
            Resource[] resourceArray = new Resource[this._resources.length + 1];
            int n2 = this._resources.length;
            while (n2-- > 0) {
                resourceArray[n2] = this._resources[n2];
            }
            resourceArray[this._resources.length] = resource;
            this._resources = resourceArray;
        }
    }

    protected int normalize(int n) {
        if ((n & 8) != 0) {
            return 8;
        }
        if ((n & 4) != 0) {
            return 4;
        }
        if ((n & 0x20) != 0) {
            return 32;
        }
        if ((n & 3) == 3) {
            return 4;
        }
        return n;
    }

    protected int getHeuristic() {
        return this._heuristic;
    }

    protected void internalSetTransactionTimeout(int n) {
        InternalXAResourceHolder internalXAResourceHolder = this._enlisted;
        while (internalXAResourceHolder != null) {
            try {
                internalXAResourceHolder._xaResource.setTransactionTimeout(n);
            }
            catch (XAException xAException) {
                // empty catch block
            }
            internalXAResourceHolder = internalXAResourceHolder._nextHolder;
        }
    }

    protected synchronized void timedOut() {
        if (!this._timedOut) {
            this._timedOut = true;
            try {
                this.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected boolean getTimedOut() {
        return this._timedOut;
    }

    protected PropagationContext getPropagationContext() {
        return this._pgContext;
    }

    protected synchronized String[] listResources() {
        InternalXAResourceHolder internalXAResourceHolder = this._enlisted;
        int n = 0;
        while (internalXAResourceHolder != null) {
            internalXAResourceHolder = internalXAResourceHolder._nextHolder;
            ++n;
        }
        String[] stringArray = new String[n + (this._resources == null ? 0 : this._resources.length)];
        internalXAResourceHolder = this._enlisted;
        n = 0;
        while (internalXAResourceHolder != null) {
            stringArray[n] = internalXAResourceHolder._xaResource.toString();
            if (internalXAResourceHolder._endFlag != 0) {
                stringArray[n] = stringArray[n] + "[" + (internalXAResourceHolder._endFlag == 0x2000000 ? "suspended" : (internalXAResourceHolder._endFlag == 0x4000000 ? "ended" : "failed")) + "]";
            }
            internalXAResourceHolder = internalXAResourceHolder._nextHolder;
            ++n;
        }
        if (this._resources != null) {
            int n2 = this._resources.length;
            while (n2-- > 0) {
                stringArray[n] = this._resources[n2].toString();
                ++n;
            }
        }
        return stringArray;
    }

    protected void endResources() throws IllegalStateException, RollbackException {
        if (this._timedOut) {
            throw new RollbackException(Messages.message("tyrex.tx.timedOut"));
        }
        switch (this._status) {
            case 0: {
                break;
            }
            case 2: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inOnePhaseCommit"));
            }
            case 7: 
            case 8: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inCommit"));
            }
            case 1: {
                this._heuristic = 2;
                return;
            }
            case 4: {
                throw new RollbackException(Messages.message("tyrex.tx.rolledback"));
            }
            case 9: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inRollback"));
            }
            default: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inactive"));
            }
        }
        if (this._syncs != null) {
            this.beforeCompletion();
            if (this._status == 1) {
                this._heuristic = 2;
                return;
            }
        }
        this._status = 8;
        this._heuristic = 0;
        if (this._enlisted != null) {
            this.endEnlistedResourcesForCommit();
        }
        this._heuristic = this._heuristic == 0 ? 1 : this.normalize(this._heuristic);
    }

    protected void forget(int n) throws IllegalStateException {
        if (this._status != 3 && this._status != 4) {
            throw new IllegalStateException(Messages.message("tyrex.tx.cannotForget"));
        }
        if (this._heuristic != n && this._twoPhase && (this._heuristic == 2 || this._heuristic == 1 || this._heuristic == 4 || this._heuristic == 8)) {
            InternalXAResourceHolder internalXAResourceHolder = this._enlisted;
            while (internalXAResourceHolder != null) {
                try {
                    if (!internalXAResourceHolder._shared) {
                        internalXAResourceHolder._xaResource.forget(internalXAResourceHolder._xid);
                    }
                }
                catch (XAException xAException) {
                    this.xaError(internalXAResourceHolder, xAException);
                }
                catch (Exception exception) {
                    this.error(exception);
                }
                internalXAResourceHolder = internalXAResourceHolder._nextHolder;
            }
            internalXAResourceHolder = this._delisted;
            while (internalXAResourceHolder != null) {
                try {
                    if (!internalXAResourceHolder._shared) {
                        internalXAResourceHolder._xaResource.forget(internalXAResourceHolder._xid);
                    }
                }
                catch (XAException xAException) {
                    this.xaError(internalXAResourceHolder, xAException);
                }
                catch (Exception exception) {
                    this.error(exception);
                }
                internalXAResourceHolder = internalXAResourceHolder._nextHolder;
            }
            if (this._resources != null) {
                int n2 = this._resources.length;
                while (n2-- > 0) {
                    Resource resource = this._resources[n2];
                    if (resource == null) continue;
                    try {
                        resource.forget();
                    }
                    catch (Exception exception) {
                        this.error(exception);
                    }
                    this._resources[n2] = null;
                }
            }
        }
        this._enlisted = null;
        this._resources = null;
        this._delisted = null;
        if (this._syncs != null) {
            Transaction transaction = this.makeCurrentTransactionIfNecessary();
            int n3 = 0;
            while (n3 < this._syncs.length) {
                Synchronization synchronization = this._syncs[n3];
                if (synchronization == null) break;
                try {
                    synchronization.afterCompletion(this._status);
                }
                catch (Exception exception) {
                    this.error(exception);
                }
                ++n3;
            }
            this._syncs = null;
            if (transaction != null) {
                this.resumeTransaction(transaction);
            }
        }
        if (this._twoPhase && this._txDomain._journal != null) {
            try {
                this._txDomain._journal.forget(this._xid);
            }
            catch (SystemException systemException) {
                this.error(systemException);
            }
        }
        if (this._parent == null) {
            this._txDomain.forgetTransaction(this);
        }
    }

    protected void addRecovery(XAResource xAResource, Xid xid) {
        if (xAResource == null) {
            throw new IllegalArgumentException("Argument xaResource is null");
        }
        if (xid == null) {
            throw new IllegalArgumentException("Argument xid is null");
        }
        InternalXAResourceHolder internalXAResourceHolder = new InternalXAResourceHolder(xAResource, null, xid, false);
        internalXAResourceHolder._nextHolder = this._enlisted;
        internalXAResourceHolder._endFlag = 0x4000000;
        this._enlisted = internalXAResourceHolder;
    }

    private void suspendTransaction() {
        try {
            if (this._txDomain._txManager.getTransaction() == this) {
                this._txDomain._txManager.suspend();
            }
        }
        catch (Exception exception) {
            this._status = 1;
            this.error(exception);
        }
    }

    private boolean areXaResourcesShared(InternalXAResourceHolder internalXAResourceHolder, boolean bl) {
        boolean bl2 = false;
        while (internalXAResourceHolder != null) {
            if (!internalXAResourceHolder._shared) {
                if (bl2 || bl) {
                    return false;
                }
                bl2 = true;
            }
            internalXAResourceHolder = internalXAResourceHolder._nextHolder;
        }
        return true;
    }

    private void commit(boolean bl) throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        try {
            this._txDomain.notifyCommit(this);
            if (!bl) {
                this.prepare();
            } else {
                this.endResources();
            }
        }
        catch (RollbackException rollbackException) {
            this._heuristic = 2;
        }
        switch (this._heuristic) {
            case 0: {
                try {
                    this._txDomain.notifyCompletion(this, this._heuristic);
                    this._status = 3;
                    java.lang.Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    java.lang.Object var4_4 = null;
                    try {
                        this.forget(0);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    this.forget(0);
                }
                catch (IllegalStateException illegalStateException) {}
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 32: {
                try {
                    this._status = 1;
                    this.internalRollback();
                    throw new HeuristicRollbackException(Messages.message("tyrex.tx.rolledback"));
                }
                catch (Throwable throwable) {
                    java.lang.Object var7_9 = null;
                    try {
                        this.forget(2);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            default: {
                try {
                    this.internalCommit(bl);
                    java.lang.Object var10_11 = null;
                }
                catch (Throwable throwable) {
                    java.lang.Object var10_12 = null;
                    try {
                        this.forget(1);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    this.forget(1);
                }
                catch (IllegalStateException illegalStateException) {}
                break;
            }
        }
        switch (this._heuristic) {
            case 2: {
                throw new HeuristicRollbackException(Messages.message("tyrex.tx.heuristicRollback"));
            }
            case 4: {
                throw new HeuristicMixedException(Messages.message("tyrex.tx.heuristicMixed"));
            }
            case 8: {
                throw new HeuristicMixedException(Messages.message("tyrex.tx.heuristicHazard"));
            }
            case 32: {
                if (this._sysError != null) {
                    throw this._sysError;
                }
                throw new SystemException("Unknown exception occurred");
            }
        }
        if (this._sysError != null) {
            throw this._sysError;
        }
    }

    private Transaction makeCurrentTransactionIfNecessary() {
        Transaction transaction = null;
        try {
            if (this._txDomain._txManager.getTransaction() != this) {
                transaction = this._txDomain._txManager.suspend();
                this._txDomain._txManager.internalResume(this);
            }
        }
        catch (Exception exception) {
            this._status = 1;
            this.error(exception);
        }
        return transaction;
    }

    private void resumeTransaction(Transaction transaction) {
        try {
            this._txDomain._txManager.suspend();
        }
        catch (Exception exception) {
            this.error(exception);
        }
        try {
            this._txDomain._txManager.resume(transaction);
        }
        catch (Exception exception) {
            this._status = 1;
            this.error(exception);
        }
    }

    private void beforeCompletion() {
        if (this._syncs != null) {
            Transaction transaction = this.makeCurrentTransactionIfNecessary();
            if (this._status != 1) {
                int n = 0;
                while (n < this._syncs.length) {
                    Synchronization synchronization = this._syncs[n];
                    if (synchronization == null) break;
                    try {
                        synchronization.beforeCompletion();
                    }
                    catch (Exception exception) {
                        this.error(exception);
                        this._status = 1;
                    }
                    ++n;
                }
            }
            if (transaction != null) {
                this.resumeTransaction(transaction);
            }
            if (this._status == 1) {
                this._heuristic = 2;
                return;
            }
        }
    }

    private void endEnlistedResourcesForCommit() {
        InternalXAResourceHolder internalXAResourceHolder = this._enlisted;
        while (internalXAResourceHolder != null) {
            try {
                this.endForTransactionBoundary(internalXAResourceHolder);
            }
            catch (Exception exception) {
                this._heuristic |= 2;
                this.error(exception);
            }
            internalXAResourceHolder = internalXAResourceHolder._nextHolder;
        }
    }

    private void endForTransactionBoundary(InternalXAResourceHolder internalXAResourceHolder) throws SystemException, XAException {
        if (internalXAResourceHolder._endFlag == 0 || internalXAResourceHolder._endFlag == 0x2000000) {
            if (internalXAResourceHolder._endFlag == 0x2000000) {
                internalXAResourceHolder._xaResource.start(internalXAResourceHolder._xid, 0x8000000);
            }
            internalXAResourceHolder._xaResource.end(internalXAResourceHolder._xid, 0x4000000);
            internalXAResourceHolder._endFlag = 0x4000000;
        } else if (internalXAResourceHolder._endFlag != 0x4000000) {
            throw new SystemException("XA resource is not in the proper state to be ended");
        }
    }

    private String getXAErrorString(XAException xAException) {
        return XAResourceHelperManager.getHelper(xAException).getXAErrorString(xAException);
    }

    private void xaError(InternalXAResourceHolder internalXAResourceHolder, XAException xAException) {
        if (xAException.errorCode == 5) {
            this._heuristic |= 4;
            this._txDomain._category.error((java.lang.Object)("XAResource " + internalXAResourceHolder._xaResource + " reported mixed heuristic on transaction branch " + internalXAResourceHolder._xid + this.getXAErrorString(xAException)), (Throwable)xAException);
        } else if (xAException.errorCode == 8) {
            this._heuristic |= 8;
            this._txDomain._category.error((java.lang.Object)("XAResource " + internalXAResourceHolder._xaResource + " reported hazard heuristic on transaction branch " + internalXAResourceHolder._xid + this.getXAErrorString(xAException)), (Throwable)xAException);
        } else if (xAException.errorCode != 3) {
            if (xAException.errorCode >= 100 && xAException.errorCode <= 107) {
                this._txDomain._category.error((java.lang.Object)("XAResource " + internalXAResourceHolder._xaResource + " reported rollback heuristic on transaction branch " + internalXAResourceHolder._xid + this.getXAErrorString(xAException)), (Throwable)xAException);
                this._heuristic |= 2;
            } else if (xAException.errorCode == 7) {
                this._heuristic |= 1;
                this._txDomain._category.error((java.lang.Object)("XAResource " + internalXAResourceHolder._xaResource + " reported commit heuristic on transaction branch " + internalXAResourceHolder._xid + this.getXAErrorString(xAException)), (Throwable)xAException);
            } else {
                this._heuristic |= 0x20;
                this.error(xAException);
            }
        }
    }

    private void commitXAResources(InternalXAResourceHolder internalXAResourceHolder, boolean bl) {
        while (internalXAResourceHolder != null) {
            try {
                if (!internalXAResourceHolder._shared && !internalXAResourceHolder._readOnly) {
                    internalXAResourceHolder._xaResource.commit(internalXAResourceHolder._xid, bl);
                    this._heuristic |= 1;
                }
                if (null != internalXAResourceHolder._callback) {
                    internalXAResourceHolder._callback.boundary(internalXAResourceHolder._xid, true);
                }
            }
            catch (XAException xAException) {
                this.xaError(internalXAResourceHolder, xAException);
            }
            catch (Exception exception) {
                this._heuristic |= 8;
                this.error(exception);
            }
            internalXAResourceHolder = internalXAResourceHolder._nextHolder;
        }
    }

    private void rollbackXAResources(InternalXAResourceHolder internalXAResourceHolder) {
        while (internalXAResourceHolder != null) {
            try {
                if (!internalXAResourceHolder._shared && !internalXAResourceHolder._readOnly) {
                    internalXAResourceHolder._xaResource.rollback(internalXAResourceHolder._xid);
                    this._heuristic |= 2;
                }
                if (null != internalXAResourceHolder._callback) {
                    internalXAResourceHolder._callback.boundary(internalXAResourceHolder._xid, false);
                }
            }
            catch (XAException xAException) {
                this.xaError(internalXAResourceHolder, xAException);
            }
            catch (Exception exception) {
                this._heuristic |= 8;
                this.error(exception);
            }
            internalXAResourceHolder = internalXAResourceHolder._nextHolder;
        }
    }

    private boolean shareResource(XAResource xAResource, XAResourceCallback xAResourceCallback, InternalXAResourceHolder internalXAResourceHolder) throws XAException, SystemException {
        try {
            while (internalXAResourceHolder != null) {
                if (!internalXAResourceHolder._shared && internalXAResourceHolder._xaResource.isSameRM(xAResource)) {
                    XAResourceHelper xAResourceHelper = XAResourceHelperManager.getHelper(xAResource);
                    boolean bl = xAResourceHelper.useDifferentBranchesForSharedResources();
                    InternalXAResourceHolder internalXAResourceHolder2 = bl ? new InternalXAResourceHolder(xAResource, xAResourceCallback, XAResourceHelperManager.getHelper(xAResource).getXid(xAResource, XidUtils.newBranch(internalXAResourceHolder._xid)), xAResourceHelper.treatDifferentBranchesForSharedResourcesAsShared()) : new InternalXAResourceHolder(xAResource, xAResourceCallback, internalXAResourceHolder._xid, true);
                    if (bl) {
                        internalXAResourceHolder2._xaResource.start(internalXAResourceHolder2._xid, 0);
                        if (null != xAResourceCallback) {
                            xAResourceCallback.enlist(internalXAResourceHolder2._xid);
                        }
                    } else {
                        if (0x2000000 == internalXAResourceHolder._endFlag) {
                            internalXAResourceHolder._xaResource.start(internalXAResourceHolder._xid, 0x8000000);
                            internalXAResourceHolder._endFlag = 0;
                        }
                        internalXAResourceHolder2._xaResource.start(internalXAResourceHolder2._xid, 0x200000);
                    }
                    internalXAResourceHolder2._nextHolder = this._enlisted;
                    this._enlisted = internalXAResourceHolder2;
                    return true;
                }
                internalXAResourceHolder = internalXAResourceHolder._nextHolder;
            }
        }
        catch (XAException xAException) {
            if (xAException.errorCode == -3 || xAException.errorCode == -7) {
                throw new NestedSystemException(xAException);
            }
            throw xAException;
        }
        return false;
    }

    private boolean addNewResource(XAResource xAResource, XAResourceCallback xAResourceCallback) throws SystemException, RollbackException {
        try {
            if (this.shareResource(xAResource, xAResourceCallback, this._enlisted) || this.shareResource(xAResource, xAResourceCallback, this._delisted)) {
                return true;
            }
        }
        catch (XAException xAException) {
            return false;
        }
        Xid xid = this._xid.newBranch();
        try {
            xid = XAResourceHelperManager.getHelper(xAResource).getXid(xAResource, xid);
        }
        catch (XAException xAException) {
            throw new NestedSystemException(xAException);
        }
        InternalXAResourceHolder internalXAResourceHolder = new InternalXAResourceHolder(xAResource, xAResourceCallback, xid, false);
        try {
            xAResource.start(xid, 0);
            internalXAResourceHolder._nextHolder = this._enlisted;
            this._enlisted = internalXAResourceHolder;
            if (null != xAResourceCallback) {
                xAResourceCallback.enlist(xid);
            }
            return true;
        }
        catch (XAException xAException) {
            this.xaError(internalXAResourceHolder, xAException);
            return false;
        }
        catch (Exception exception) {
            throw new NestedSystemException(exception);
        }
    }

    private synchronized void unregisterResource(Resource resource) {
        if (this._resources != null) {
            if (this._resources.length == 1 && this._resources[0].equals(resource)) {
                this._resources = null;
            } else {
                int n = this._resources.length;
                while (n-- > 0) {
                    if (!this._resources[n].equals(resource)) continue;
                    this._resources[n] = this._resources[this._resources.length - 1];
                    Resource[] resourceArray = new Resource[this._resources.length - 1];
                    System.arraycopy(this._resources, 0, resourceArray, 0, this._resources.length - 1);
                    this._resources = resourceArray;
                }
            }
        }
    }

    private void error(Throwable throwable) {
        if (throwable instanceof RemoteException && ((RemoteException)throwable).detail != null) {
            throwable = ((RemoteException)throwable).detail;
        }
        Throwable throwable2 = throwable;
        if (throwable instanceof XAException) {
            switch (((XAException)throwable).errorCode) {
                case 100: {
                    throwable = new SystemException(Messages.message("tyrex.xa.rbrollback"));
                    break;
                }
                case 106: {
                    throwable = new SystemException(Messages.message("tyrex.xa.rbtimeout"));
                    break;
                }
                case 101: {
                    throwable = new SystemException(Messages.message("tyrex.xa.rbcommfail"));
                    break;
                }
                case 102: {
                    throwable = new SystemException(Messages.message("tyrex.xa.rbdeadlock"));
                    break;
                }
                case 103: {
                    throwable = new SystemException(Messages.message("tyrex.xa.rbintegrity"));
                    break;
                }
                case 104: {
                    throwable = new SystemException(Messages.message("tyrex.xa.rbother"));
                    break;
                }
                case 105: {
                    throwable = new SystemException(Messages.message("tyrex.xa.rbproto"));
                    break;
                }
                case 8: {
                    throwable = new SystemException(Messages.message("tyrex.xa.heurhaz"));
                    break;
                }
                case 7: {
                    throwable = new SystemException(Messages.message("tyrex.xa.heurcom"));
                    break;
                }
                case 6: {
                    throwable = new SystemException(Messages.message("tyrex.xa.heurrb"));
                    break;
                }
                case 5: {
                    throwable = new SystemException(Messages.message("tyrex.xa.heurmix"));
                    break;
                }
                case 3: {
                    throwable = new SystemException(Messages.message("tyrex.xa.rdonly"));
                    break;
                }
                case -4: {
                    throwable = new SystemException(Messages.message("tyrex.xa.nota"));
                    break;
                }
                default: {
                    throwable = new SystemException(Messages.format("tyrex.xa.unknown", throwable));
                }
            }
        }
        if (!(throwable2 instanceof XAException)) {
            this._txDomain._category.error((java.lang.Object)("Error " + throwable2.toString() + " reported in transaction " + this._xid), throwable2);
        } else {
            this._txDomain._category.error((java.lang.Object)("Error " + throwable2.toString() + "[code " + ((XAException)throwable2).errorCode + " - " + throwable.getMessage() + "] reported in transaction " + this._xid + this.getXAErrorString((XAException)throwable2)), throwable2);
        }
        if (this._sysError == null) {
            this._sysError = throwable instanceof SystemException ? (SystemException)throwable : new NestedSystemException(throwable);
        }
    }

    private static class InternalXAResourceHolder
    extends XAResourceHolder {
        final Xid _xid;
        int _endFlag = 0;
        boolean _shared;
        boolean _readOnly;
        InternalXAResourceHolder _nextHolder;

        InternalXAResourceHolder(XAResource xAResource, XAResourceCallback xAResourceCallback, Xid xid, boolean bl) {
            super(xAResource, xAResourceCallback);
            this._xid = xid;
            this._shared = bl;
        }
    }
}

