package services
import models._
import forms._
import org.squeryl._
import org.squeryl.PrimitiveTypeMode._

case class PartManager() {
  
  def insert(part: PartForm):Part = {
    val project = ProjectManager().getByName(part.projectName)
    val newPart = PartsListDb.parts.insert(Part(part.name, part.atach, project.id))
    return newPart
  }
  
  def update(part: PartForm, id: Long):Part = {
    val project =ProjectManager().getByName(part.projectName)
    val updPart = getById(id)
    updPart.name = part.name
    updPart.projectId = project.id
    PartsListDb.parts.update(updPart)
    return updPart
  }
  
  def getById(id: Long):Part = {
    return PartsListDb.parts.where(p => p.id === id).head
  }
  
  def getByName(name: String):Part ={
    return PartsListDb.parts.where(p => p.name === name).head
  }
}