/*
 * Decompiled with CFR 0.152.
 */
package play.data.format;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import play.data.Form;
import play.data.format.Formatters;

public class Formats {

    public static class AnnotationNonEmptyFormatter
    extends Formatters.AnnotationFormatter<NonEmpty, String> {
        @Override
        public String parse(NonEmpty nonEmpty, String string, Locale locale) throws ParseException {
            if (string == null || string.trim().isEmpty()) {
                return null;
            }
            return string;
        }

        @Override
        public String print(NonEmpty nonEmpty, String string, Locale locale) {
            if (string == null) {
                return "";
            }
            return string;
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface NonEmpty {
    }

    public static class AnnotationDateFormatter
    extends Formatters.AnnotationFormatter<DateTime, Date> {
        @Override
        public Date parse(DateTime dateTime, String string, Locale locale) throws ParseException {
            if (string == null || string.trim().isEmpty()) {
                return null;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateTime.pattern(), locale);
            simpleDateFormat.setLenient(false);
            return simpleDateFormat.parse(string);
        }

        @Override
        public String print(DateTime dateTime, Date date, Locale locale) {
            if (date == null) {
                return "";
            }
            return new SimpleDateFormat(dateTime.pattern(), locale).format(date);
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Form.Display(name="format.date", attributes={"pattern"})
    public static @interface DateTime {
        public String pattern();
    }

    public static class DateFormatter
    extends Formatters.SimpleFormatter<Date> {
        private final String pattern;

        public DateFormatter(String string) {
            this.pattern = string;
        }

        @Override
        public Date parse(String string, Locale locale) throws ParseException {
            if (string == null || string.trim().isEmpty()) {
                return null;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.pattern, locale);
            simpleDateFormat.setLenient(false);
            return simpleDateFormat.parse(string);
        }

        @Override
        public String print(Date date, Locale locale) {
            if (date == null) {
                return "";
            }
            return new SimpleDateFormat(this.pattern, locale).format(date);
        }
    }
}

