/*
 * Decompiled with CFR 0.152.
 */
package scalax.io.support;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.StringAdd$;
import scalax.io.DefaultResourceContext$;
import scalax.io.OpenOption;
import scalax.io.Resource$;
import scalax.io.StandardOpenOption$;
import scalax.io.extractor.FileChannelExtractor$;
import scalax.io.extractor.ReadableByteChannelExtractor$;
import scalax.io.extractor.WritableByteChannelExtractor$;
import scalax.io.managed.OutputStreamResource;
import scalax.io.nio.SeekableFileChannel;
import scalax.io.support.DeletingFileOutputStream;
import scalax.io.support.FileUtils$$anonfun$scalax$io$support$FileUtils$;

public final class FileUtils$ {
    public static final FileUtils$ MODULE$;

    static {
        new FileUtils$();
    }

    public OutputStreamResource<FileOutputStream> openOutputStream(File jfile, Seq<OpenOption> openOptions) {
        return Resource$.MODULE$.fromOutputStream(new Serializable(jfile, openOptions){
            public static final long serialVersionUID = 0L;
            private final File jfile$1;
            private final Seq openOptions$1;

            public final FileOutputStream apply() {
                Tuple2<Object, Seq<OpenOption>> tuple2 = FileUtils$.MODULE$.scalax$io$support$FileUtils$$preOpen(this.jfile$1, (Seq<OpenOption>)this.openOptions$1, true);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    boolean append2 = tuple2._1$mcZ$sp();
                    Seq options = (Seq)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)append2), (Object)options);
                    boolean append3 = tuple23._1$mcZ$sp();
                    Seq options2 = (Seq)tuple23._2();
                    return options2.contains((Object)StandardOpenOption$.MODULE$.DeleteOnClose()) ? new DeletingFileOutputStream(this.jfile$1, append3) : new FileOutputStream(this.jfile$1, append3);
                }
                throw new MatchError(tuple2);
            }
            {
                this.jfile$1 = jfile$1;
                this.openOptions$1 = openOptions$1;
            }
        });
    }

    public SeekableFileChannel openChannel(RandomAccessFile raf, Seq<OpenOption> openOptions) {
        if (openOptions.contains((Object)StandardOpenOption$.MODULE$.DeleteOnClose())) {
            throw new UnsupportedOperationException("DeleteOnClose is not supported on FileChannels pre Java 7 implementations.");
        }
        if (openOptions.contains((Object)StandardOpenOption$.MODULE$.Truncate()) && openOptions.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(OpenOption opt) {
                OpenOption openOption = opt;
                Enumeration.Val val = StandardOpenOption$.MODULE$.Write();
                if (openOption == null) {
                    if (val == null) return true;
                } else if (openOption.equals(val)) return true;
                OpenOption openOption2 = opt;
                Enumeration.Val val2 = StandardOpenOption$.MODULE$.Append();
                if (openOption2 != null) {
                    if (!openOption2.equals(val2)) return false;
                    return true;
                }
                if (val2 == null) return true;
                return false;
            }
        })) {
            raf.setLength(0L);
        }
        if (openOptions.contains((Object)StandardOpenOption$.MODULE$.Append())) {
            raf.seek(raf.length());
        }
        return new SeekableFileChannel(raf.getChannel());
    }

    public SeekableFileChannel openChannel(File jfile, Seq<OpenOption> openOptions) {
        Tuple2<Object, Seq<OpenOption>> tuple2 = this.scalax$io$support$FileUtils$$preOpen(jfile, openOptions, false);
        if (tuple2 != null) {
            boolean p2 = tuple2._1$mcZ$sp();
            Seq options = (Seq)tuple2._2();
            Seq seq = options;
            Seq options2 = seq;
            if (options2.contains((Object)StandardOpenOption$.MODULE$.DeleteOnClose())) {
                throw new UnsupportedOperationException("DeleteOnClose is not supported on FileChannels pre Java 7 implementations.");
            }
            return this.openChannel(this.randomAccessFile(jfile, (Seq<OpenOption>)options2), (Seq<OpenOption>)options2);
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<Object, Seq<OpenOption>> scalax$io$support$FileUtils$$preOpen(File jfile, Seq<OpenOption> openOptions, boolean processTruncate) {
        Seq<OpenOption> options = openOptions.isEmpty() ? StandardOpenOption$.MODULE$.WriteTruncate() : openOptions;
        BooleanRef append2 = new BooleanRef(false);
        options.foreach((Function1)new Serializable(jfile, processTruncate, options, append2){
            public static final long serialVersionUID = 0L;
            public final File jfile$2;
            private final boolean processTruncate$1;
            private final Seq options$1;
            private final BooleanRef append$1;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Object apply(OpenOption x0$1) {
                void var5_11;
                OpenOption openOption = x0$1;
                Enumeration.Val val = StandardOpenOption$.MODULE$.Append();
                OpenOption openOption2 = openOption;
                if (!(val != null ? !val.equals(openOption2) : openOption2 != null)) {
                    OpenOption x2 = openOption;
                    this.append$1.elem = true;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return var5_11;
                }
                Enumeration.Val val2 = StandardOpenOption$.MODULE$.Create();
                OpenOption openOption3 = openOption;
                if (!(val2 != null ? !val2.equals(openOption3) : openOption3 != null)) {
                    OpenOption x3 = openOption;
                    if (!this.jfile$2.exists()) {
                        Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.jfile$2.createNewFile());
                        return var5_11;
                    }
                }
                Enumeration.Val val3 = StandardOpenOption$.MODULE$.CreateFull();
                OpenOption openOption4 = openOption;
                if (!(val3 != null ? !val3.equals(openOption4) : openOption4 != null)) {
                    OpenOption x4 = openOption;
                    if (!this.jfile$2.exists()) {
                        Option parent = Option$.MODULE$.apply((Object)this.jfile$2.getParentFile()).orElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$scalax$io$support$FileUtils$$preOpen$1 $outer;

                            public final Option<File> apply() {
                                return Option$.MODULE$.apply((Object)this.$outer.jfile$2.getAbsoluteFile().getParentFile());
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        ((File)parent.getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$scalax$io$support$FileUtils$$preOpen$1 $outer;

                            public final Nothing$ apply() {
                                throw new IOException(new StringBuilder().append((Object)"unable to get parent file of").append((Object)this.$outer.jfile$2).toString());
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        })).mkdirs();
                        Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.jfile$2.createNewFile());
                        return var5_11;
                    }
                }
                Enumeration.Val val4 = StandardOpenOption$.MODULE$.CreateNew();
                OpenOption openOption5 = openOption;
                if (!(val4 != null ? !val4.equals(openOption5) : openOption5 != null)) {
                    OpenOption x5 = openOption;
                    if (this.jfile$2.exists()) {
                        throw new IOException(new StringBuilder().append((Object)StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.jfile$2), " already exists, openOption '")).append((Object)StandardOpenOption$.MODULE$.CreateNew()).append((Object)"' cannot be used with an existing file").toString());
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return var5_11;
                }
                Enumeration.Val val5 = StandardOpenOption$.MODULE$.Truncate();
                OpenOption openOption6 = openOption;
                if (!(val5 != null ? !val5.equals(openOption6) : openOption6 != null)) {
                    OpenOption x6 = openOption;
                    if (this.processTruncate$1 && this.options$1.exists((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean apply(OpenOption opt) {
                            OpenOption openOption = opt;
                            Enumeration.Val val = StandardOpenOption$.MODULE$.Write();
                            if (openOption == null) {
                                if (val == null) return true;
                            } else if (openOption.equals(val)) return true;
                            OpenOption openOption2 = opt;
                            Enumeration.Val val2 = StandardOpenOption$.MODULE$.Append();
                            if (openOption2 != null) {
                                if (!openOption2.equals(val2)) return false;
                                return true;
                            }
                            if (val2 == null) return true;
                            return false;
                        }
                    }) && this.jfile$2.length() > 0L) {
                        new FileOutputStream(this.jfile$2).close();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return var5_11;
                    }
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return var5_11;
            }
            {
                this.jfile$2 = jfile$2;
                this.processTruncate$1 = processTruncate$1;
                this.options$1 = options$1;
                this.append$1 = append$1;
            }
        });
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)append2.elem), options);
    }

    private RandomAccessFile randomAccessFile(File jfile, Seq<OpenOption> openOptions) {
        Seq unsortedChars = (Seq)openOptions.collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends OpenOption, B1> B1 applyOrElse(A1 x$1, Function1<A1, B1> function1) {
                Object object;
                boolean bl;
                A1 A1 = x$1;
                Enumeration.Val val = StandardOpenOption$.MODULE$.Write();
                A1 A12 = A1;
                if (!(val != null ? !val.equals(A12) : A12 != null)) {
                    A1 x2 = A1;
                    bl = true;
                } else {
                    Enumeration.Val val2 = StandardOpenOption$.MODULE$.Append();
                    A1 A13 = A1;
                    if (!(val2 != null ? !val2.equals(A13) : A13 != null)) {
                        A1 x3 = A1;
                        bl = true;
                    } else {
                        bl = false;
                    }
                }
                if (bl) {
                    object = BoxesRunTime.boxToCharacter((char)'w');
                } else {
                    Enumeration.Val val3 = StandardOpenOption$.MODULE$.Read();
                    A1 A14 = A1;
                    if (!(val3 != null ? !val3.equals(A14) : A14 != null)) {
                        A1 x4 = A1;
                        object = BoxesRunTime.boxToCharacter((char)'r');
                    } else {
                        Enumeration.Val val4 = StandardOpenOption$.MODULE$.Sync();
                        A1 A15 = A1;
                        if (!(val4 != null ? !val4.equals(A15) : A15 != null)) {
                            A1 x5 = A1;
                            object = BoxesRunTime.boxToCharacter((char)'s');
                        } else {
                            Enumeration.Val val5 = StandardOpenOption$.MODULE$.DSync();
                            A1 A16 = A1;
                            if (!(val5 != null ? !val5.equals(A16) : A16 != null)) {
                                A1 x6 = A1;
                                object = BoxesRunTime.boxToCharacter((char)'d');
                            } else {
                                object = function1.apply(x$1);
                            }
                        }
                    }
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(OpenOption x$1) {
                boolean bl;
                boolean bl2;
                OpenOption openOption = x$1;
                Enumeration.Val val = StandardOpenOption$.MODULE$.Write();
                OpenOption openOption2 = openOption;
                if (!(val != null ? !val.equals(openOption2) : openOption2 != null)) {
                    OpenOption x2 = openOption;
                    bl2 = true;
                } else {
                    Enumeration.Val val2 = StandardOpenOption$.MODULE$.Append();
                    OpenOption openOption3 = openOption;
                    if (!(val2 != null ? !val2.equals(openOption3) : openOption3 != null)) {
                        OpenOption x3 = openOption;
                        bl2 = true;
                    } else {
                        bl2 = false;
                    }
                }
                if (bl2) {
                    bl = true;
                } else {
                    Enumeration.Val val3 = StandardOpenOption$.MODULE$.Read();
                    OpenOption openOption4 = openOption;
                    if (!(val3 != null ? !val3.equals(openOption4) : openOption4 != null)) {
                        OpenOption x4 = openOption;
                        bl = true;
                    } else {
                        Enumeration.Val val4 = StandardOpenOption$.MODULE$.Sync();
                        OpenOption openOption5 = openOption;
                        if (!(val4 != null ? !val4.equals(openOption5) : openOption5 != null)) {
                            OpenOption x5 = openOption;
                            bl = true;
                        } else {
                            Enumeration.Val val5 = StandardOpenOption$.MODULE$.DSync();
                            OpenOption openOption6 = openOption;
                            if (!(val5 != null ? !val5.equals(openOption6) : openOption6 != null)) {
                                OpenOption x6 = openOption;
                                bl = true;
                            } else {
                                bl = false;
                            }
                        }
                    }
                }
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq sortedChars = (Seq)((SeqLike)unsortedChars.distinct()).sortWith((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x, char y) {
                return this.value$1(x) < this.value$1(y);
            }

            private final int value$1(char x) {
                int n;
                char c = x;
                switch (c) {
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToCharacter((char)c));
                    }
                    case 'd': {
                        n = 3;
                        break;
                    }
                    case 's': {
                        n = 2;
                        break;
                    }
                    case 'w': {
                        n = 1;
                        break;
                    }
                    case 'r': {
                        n = 0;
                    }
                }
                return n;
            }
        });
        Seq chars2 = sortedChars.mkString().endsWith("sd") ? (Seq)sortedChars.takeWhile((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$2) {
                return x$2 != 's';
            }
        }) : sortedChars;
        return chars2.contains((Object)BoxesRunTime.boxToCharacter((char)'r')) ? new RandomAccessFile(jfile, chars2.mkString()) : new RandomAccessFile(jfile, new StringBuilder().append('r').append((Object)chars2.mkString()).toString());
    }

    public void copy(InputStream in, OutputStream out) {
        byte[] buf = new byte[4096];
        int read2 = in.read(buf);
        while (read2 > -1) {
            if (read2 == 0) {
                Thread.sleep(100L);
            } else {
                out.write(buf, 0, read2);
            }
            read2 = in.read(buf);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Object copy(ReadableByteChannel in, WritableByteChannel out) {
        void var7_10;
        Tuple2 tuple2 = new Tuple2((Object)in, (Object)out);
        if (tuple2 != null) {
            ReadableByteChannel fc = (ReadableByteChannel)tuple2._1();
            WritableByteChannel oc = (WritableByteChannel)tuple2._2();
            if (fc instanceof FileChannel) {
                FileChannel x2 = (FileChannel)fc;
                Long l = BoxesRunTime.boxToLong((long)x2.transferTo(0L, Long.MAX_VALUE, oc));
                return var7_10;
            }
        }
        if (tuple2 != null) {
            ReadableByteChannel ic = (ReadableByteChannel)tuple2._1();
            WritableByteChannel fc = (WritableByteChannel)tuple2._2();
            if (fc instanceof FileChannel) {
                FileChannel x3 = (FileChannel)fc;
                Long l = BoxesRunTime.boxToLong((long)x3.transferFrom(ic, 0L, Long.MAX_VALUE));
                return var7_10;
            }
        }
        ByteBuffer buf = DefaultResourceContext$.MODULE$.createNioBuffer((Option<Object>)None$.MODULE$, (Option<Channel>)new Some((Object)in), true);
        int read2 = in.read(buf);
        while (true) {
            Object object;
            if (read2 <= -1) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return var7_10;
            }
            if (read2 == 0) {
                Thread.sleep(100L);
                object = BoxedUnit.UNIT;
            } else {
                ((Buffer)buf).flip();
                object = BoxesRunTime.boxToInteger((int)out.write(buf));
            }
            ((Buffer)buf).clear();
            read2 = in.read(buf);
        }
    }

    public Object tryCopy(Function0<BoxedUnit> failureCase, Object in, Object out) {
        Object object;
        Option<FileChannel> inFileChan = FileChannelExtractor$.MODULE$.unapply(in);
        Option<FileChannel> outFileChan = FileChannelExtractor$.MODULE$.unapply(out);
        Option<ReadableByteChannel> readableByteChan = ReadableByteChannelExtractor$.MODULE$.unapply(in);
        Option<WritableByteChannel> writableByteChan = WritableByteChannelExtractor$.MODULE$.unapply(out);
        if (inFileChan.nonEmpty() && outFileChan.nonEmpty()) {
            object = BoxesRunTime.boxToLong((long)((FileChannel)outFileChan.get()).transferFrom((ReadableByteChannel)inFileChan.get(), 0L, Long.MAX_VALUE));
        } else if (in instanceof InputStream && out instanceof OutputStream) {
            this.copy((InputStream)in, (OutputStream)out);
            object = BoxedUnit.UNIT;
        } else if (readableByteChan.nonEmpty() && outFileChan.nonEmpty()) {
            object = BoxesRunTime.boxToLong((long)((FileChannel)outFileChan.get()).transferFrom((ReadableByteChannel)readableByteChan.get(), 0L, Long.MAX_VALUE));
        } else if (inFileChan.nonEmpty() && writableByteChan.nonEmpty()) {
            object = BoxesRunTime.boxToLong((long)((FileChannel)inFileChan.get()).transferTo(0L, Long.MAX_VALUE, (WritableByteChannel)writableByteChan.get()));
        } else if (out instanceof WritableByteChannel && readableByteChan.nonEmpty()) {
            object = this.copy((ReadableByteChannel)readableByteChan.get(), (WritableByteChannel)out);
        } else {
            failureCase.apply$mcV$sp();
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    private FileUtils$() {
        MODULE$ = this;
    }
}

