package controllers.services
import models._
import beans._
import play.api.i18n._
import scala.collection.mutable.ArrayBuffer

case class ReplyRecursion(){

  def down(reply: Reply, i: Int): ArrayBuffer[NotifyBean]  ={
    val notifyBuffer = ArrayBuffer[NotifyBean]()
    var level = i+1
    notifyBuffer += NotifyBean(level, reply.message, reply.user.assign(reply.user.head).name, reply.id, Messages("notify.state9"), reply.atachs)
    for( childReply <- reply.childReplies) {
      for(returnNotifyBuffer <- ReplyRecursion().down(childReply, level)) {
        notifyBuffer += returnNotifyBuffer 
      }
    }
    return notifyBuffer
  }

  def up(reply: Reply):Reply = {
    if(reply.parentReply.size == 0) {
      return reply
    } else {
      ReplyRecursion().up(reply.parentReply.head)
    }

  }
}