package controllers

import play.api._
import play.api.mvc._
import org.squeryl._
import org.squeryl.PrimitiveTypeMode._
import models.services._

object AtachController extends Controller{

  val Home = Redirect(routes.PartsMasterController.list(0,""))

  def showAtach(id:Long) = Action {
	  inTransaction {
		  Ok(AtachManager().showAtach(id)).as(AtachManager().getById(id).contentType)
	  }
  }
  
  def dropAtach(id:Long) = Action {
	  inTransaction {
	    AtachManager().delete(id)
    	Home.flashing("success" -> "Part %s has been created".format(id))	    
	  }
  }

}