package controllers.services
import scala.collection.mutable.ArrayBuffer
import beans._
import models._
import forms._
import org.squeryl._
import org.squeryl.PrimitiveTypeMode._

case class Check() {
  // BOM作成用部品表ループチェック
  def loopCheck(data: PartsListBean):String = {
    return loopCheckBody(data.parent, data.child)
  }

  // 設計変更用部品表ループチェック
  def loopCheckDc(data: DesignChangeRelationForm):String = {
    return loopCheckBody(data.partsListBeanAfter.parent, data.partsListBeanAfter.child)
  }
  
  def loopCheckBody(parent: String, child: String):String = {
     //子品番の正展開配列
    var message:String = null
    var partBuffer = ArrayBuffer[PartsListBean]()
    for (parentPart <- PartsListDb.parts.where(p => p.name === child )) {
//      PartRecursion().down(parentPart, partBuffer, 1)
      for(returnPartBuffer <- PartRecursion().down(parentPart, 1)) {
        partBuffer += returnPartBuffer
      }
     }
     // 親品番逆展開配列
    var upPartBuffer = ArrayBuffer[PartsListBean]()
    for (childPart <- PartsListDb.parts.where(p => p.name === parent)) {
      PartRecursion().up(childPart, upPartBuffer, 0)
    }
  	// 部品表ループチェック
	// 親品番＝子品番 の場合エラー
	if(child.equals(parent)) {
	  message = "form.error1"
	} else {
	  // 子品番=親品番の逆展開 の場合エラー
	  for(upPart <- upPartBuffer ) {
	    if(upPart.child.equals(child)) {
	      message = "form.error1"
	     }
	   }
	   // 親品番＝子品番の正展開　の場合エラー
	  for(chPart <- partBuffer) {
	    if(chPart.child.equals(parent)) {
	      message = "form.error1"
	    }
	  }
	   // 子品番の正展開=親品番の逆展開 の場合エラー
	  for(chPart <- partBuffer) {
	    for(upPart <- upPartBuffer) {
	      if(upPart.child.equals(chPart.child)) {
	        message = "form.error1"
	       }
	     }
	   }
	}
  return message
  }

}