/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import com.ning.http.client.HttpResponseBodyPart;
import java.io.IOException;
import java.io.InputStream;

public class HttpResponseBodyPartsInputStream
extends InputStream {
    private final HttpResponseBodyPart[] parts;
    private int currentPos = 0;
    private int bytePos = -1;
    private byte[] active;
    private int available = 0;

    public HttpResponseBodyPartsInputStream(HttpResponseBodyPart[] parts) {
        this.parts = parts;
        this.active = parts[0].getBodyPartBytes();
        this.computeLength(parts);
    }

    private void computeLength(HttpResponseBodyPart[] parts) {
        if (this.available == 0) {
            for (HttpResponseBodyPart p : parts) {
                this.available += p.getBodyPartBytes().length;
            }
        }
    }

    public int available() throws IOException {
        return this.available;
    }

    public int read() throws IOException {
        if (++this.bytePos >= this.active.length) {
            if (++this.currentPos >= this.parts.length) {
                return -1;
            }
            this.bytePos = 0;
            this.active = this.parts[this.currentPos].getBodyPartBytes();
        }
        return this.active[this.bytePos] & 0xFF;
    }
}

