/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators;

import java.math.BigDecimal;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.DecimalMax;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class DecimalMaxValidatorForCharSequence
implements ConstraintValidator<DecimalMax, CharSequence> {
    private static final Log log = LoggerFactory.make();
    private BigDecimal maxValue;

    public void initialize(DecimalMax maxValue) {
        try {
            this.maxValue = new BigDecimal(maxValue.value());
        }
        catch (NumberFormatException nfe) {
            throw log.getInvalidBigDecimalFormatException(maxValue.value(), nfe);
        }
    }

    public boolean isValid(CharSequence value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        try {
            return new BigDecimal(((Object)value).toString()).compareTo(this.maxValue) != 1;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

