/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.constraints.CompositionType;
import org.hibernate.validator.internal.engine.ConstraintValidatorContextImpl;
import org.hibernate.validator.internal.engine.MessageAndPath;
import org.hibernate.validator.internal.engine.ValidationContext;
import org.hibernate.validator.internal.engine.ValueContext;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ConcurrentReferenceHashMap;
import org.hibernate.validator.internal.util.TypeHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ConstraintTree<A extends Annotation> {
    private static final Log log = LoggerFactory.make();
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final ConstraintTree<?> parent;
    private final List<ConstraintTree<?>> children;
    private final ConstraintDescriptorImpl<A> descriptor;
    private final ConcurrentReferenceHashMap<ConstraintValidatorCacheKey, ConstraintValidator<A, ?>> constraintValidatorCache;

    public ConstraintTree(ConstraintDescriptorImpl<A> descriptor) {
        this(descriptor, null);
    }

    private ConstraintTree(ConstraintDescriptorImpl<A> descriptor, ConstraintTree<?> parent) {
        this.parent = parent;
        this.descriptor = descriptor;
        this.constraintValidatorCache = new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.SOFT, ConcurrentReferenceHashMap.ReferenceType.SOFT);
        HashSet<ConstraintDescriptorImpl> composingConstraints = CollectionHelper.newHashSet();
        for (ConstraintDescriptor<?> composingConstraint : descriptor.getComposingConstraints()) {
            composingConstraints.add((ConstraintDescriptorImpl)composingConstraint);
        }
        this.children = new ArrayList(composingConstraints.size());
        for (ConstraintDescriptorImpl composingDescriptor : composingConstraints) {
            ConstraintTree treeNode = this.createConstraintTree(composingDescriptor);
            this.children.add(treeNode);
        }
    }

    private <U extends Annotation> ConstraintTree<U> createConstraintTree(ConstraintDescriptorImpl<U> composingDescriptor) {
        return new ConstraintTree<U>(composingDescriptor, this);
    }

    public final List<ConstraintTree<?>> getChildren() {
        return this.children;
    }

    public final ConstraintDescriptorImpl<A> getDescriptor() {
        return this.descriptor;
    }

    public final <T, U, V, E extends ConstraintViolation<T>> boolean validateConstraints(ValidationContext<T, E> executionContext, ValueContext<U, V> valueContext) {
        HashSet constraintViolations = CollectionHelper.newHashSet();
        this.validateConstraints(executionContext, valueContext, constraintViolations);
        if (!constraintViolations.isEmpty()) {
            executionContext.addConstraintFailures(constraintViolations);
            return false;
        }
        return true;
    }

    private <T, U, V, E extends ConstraintViolation<T>> void validateConstraints(ValidationContext<T, E> executionContext, ValueContext<U, V> valueContext, Set<E> constraintViolations) {
        CompositionResult compositionResult = this.validateComposingConstraints(executionContext, valueContext, constraintViolations);
        HashSet localViolationList = CollectionHelper.newHashSet();
        if (!(this.descriptor.getConstraintValidatorClasses().isEmpty() || executionContext.isFailFastModeEnabled() && !constraintViolations.isEmpty())) {
            if (log.isTraceEnabled()) {
                log.tracef("Validating value %s against constraint defined by %s.", valueContext.getCurrentValidatedValue(), this.descriptor);
            }
            ConstraintValidator<A, V> validator = this.getInitializedValidator(valueContext.getTypeOfAnnotatedElement(), executionContext.getConstraintValidatorFactory());
            ConstraintValidatorContextImpl constraintValidatorContext = new ConstraintValidatorContextImpl(valueContext.getPropertyPath(), this.descriptor);
            this.validateSingleConstraint(executionContext, valueContext, constraintValidatorContext, validator, localViolationList);
            if (localViolationList.isEmpty()) {
                compositionResult.setAtLeastOneTrue(true);
            } else {
                compositionResult.setAllTrue(false);
            }
        }
        if (!this.passesCompositionTypeRequirement(constraintViolations, compositionResult)) {
            this.prepareFinalConstraintViolations(executionContext, valueContext, constraintViolations, localViolationList);
        }
    }

    private <T, U, V, E extends ConstraintViolation<T>> void prepareFinalConstraintViolations(ValidationContext<T, E> executionContext, ValueContext<U, V> valueContext, Set<E> constraintViolations, Set<E> localViolationList) {
        if (this.reportAsSingleViolation()) {
            constraintViolations.clear();
            if (localViolationList.isEmpty()) {
                String message = (String)this.getDescriptor().getAttributes().get("message");
                MessageAndPath messageAndPath = new MessageAndPath(message, valueContext.getPropertyPath());
                E violation = executionContext.createConstraintViolation(valueContext, messageAndPath, this.descriptor);
                constraintViolations.add(violation);
            }
        }
        constraintViolations.addAll(localViolationList);
    }

    private <T, U, V, E extends ConstraintViolation<T>> CompositionResult validateComposingConstraints(ValidationContext<T, E> executionContext, ValueContext<U, V> valueContext, Set<E> constraintViolations) {
        CompositionResult compositionResult = new CompositionResult(true, false);
        for (ConstraintTree<?> tree : this.getChildren()) {
            HashSet tmpViolationList = CollectionHelper.newHashSet();
            super.validateConstraints(executionContext, valueContext, tmpViolationList);
            constraintViolations.addAll(tmpViolationList);
            if (tmpViolationList.isEmpty()) {
                compositionResult.setAtLeastOneTrue(true);
                if (this.descriptor.getCompositionType() != CompositionType.OR) continue;
                break;
            }
            compositionResult.setAllTrue(false);
            if (!executionContext.isFailFastModeEnabled() || this.descriptor.getCompositionType() != CompositionType.AND) continue;
            break;
        }
        return compositionResult;
    }

    private boolean passesCompositionTypeRequirement(Set<?> constraintViolations, CompositionResult compositionResult) {
        CompositionType compositionType = this.getDescriptor().getCompositionType();
        boolean passedValidation = false;
        switch (compositionType) {
            case OR: {
                passedValidation = compositionResult.isAtLeastOneTrue();
                break;
            }
            case AND: {
                passedValidation = compositionResult.isAllTrue();
                break;
            }
            case ALL_FALSE: {
                boolean bl = passedValidation = !compositionResult.isAtLeastOneTrue();
            }
        }
        assert (!passedValidation || compositionType != CompositionType.AND || constraintViolations.isEmpty());
        if (passedValidation) {
            constraintViolations.clear();
        }
        return passedValidation;
    }

    private <T, U, V, E extends ConstraintViolation<T>> Set<E> validateSingleConstraint(ValidationContext<T, E> executionContext, ValueContext<U, V> valueContext, ConstraintValidatorContextImpl constraintValidatorContext, ConstraintValidator<A, V> validator, Set<E> constraintViolations) {
        boolean isValid;
        try {
            isValid = validator.isValid(valueContext.getCurrentValidatedValue(), (ConstraintValidatorContext)constraintValidatorContext);
        }
        catch (RuntimeException e) {
            throw log.getExceptionDuringIsValidCall(e);
        }
        if (!isValid) {
            constraintViolations.addAll(executionContext.createConstraintViolations(valueContext, constraintValidatorContext));
        }
        return constraintViolations;
    }

    private boolean reportAsSingleViolation() {
        return this.getDescriptor().isReportAsSingleViolation() || this.getDescriptor().getCompositionType() == CompositionType.ALL_FALSE;
    }

    private <V> ConstraintValidator<A, V> getInitializedValidator(Type validatedValueType, ConstraintValidatorFactory constraintFactory) {
        ConstraintValidatorCacheKey key = new ConstraintValidatorCacheKey(constraintFactory, validatedValueType);
        Object constraintValidator = this.constraintValidatorCache.get(key);
        if (constraintValidator == null) {
            Class<ConstraintValidator<?, ?>> validatorClass = this.findMatchingValidatorClass(validatedValueType);
            constraintValidator = this.createAndInitializeValidator(constraintFactory, validatorClass);
            this.constraintValidatorCache.put(key, (ConstraintValidator<A, ?>)constraintValidator);
        } else {
            log.tracef("Constraint validator %s found in cache.", constraintValidator);
        }
        return constraintValidator;
    }

    private <V> ConstraintValidator<A, V> createAndInitializeValidator(ConstraintValidatorFactory constraintFactory, Class<? extends ConstraintValidator<?, ?>> validatorClass) {
        ConstraintValidator constraintValidator = constraintFactory.getInstance(validatorClass);
        if (constraintValidator == null) {
            throw log.getConstraintFactoryMustNotReturnNullException(validatorClass.getName());
        }
        this.initializeConstraint(this.descriptor, constraintValidator);
        return constraintValidator;
    }

    private Class<? extends ConstraintValidator<?, ?>> findMatchingValidatorClass(Type validatedValueType) {
        Map<Type, Class<ConstraintValidator<?, ?>>> availableValidatorTypes = TypeHelper.getValidatorsTypes(this.descriptor.getConstraintValidatorClasses());
        HashMap<Type, Type> suitableTypeMap = CollectionHelper.newHashMap();
        if (suitableTypeMap.containsKey(validatedValueType)) {
            return availableValidatorTypes.get(suitableTypeMap.get(validatedValueType));
        }
        List<Type> discoveredSuitableTypes = this.findSuitableValidatorTypes(validatedValueType, availableValidatorTypes);
        this.resolveAssignableTypes(discoveredSuitableTypes);
        this.verifyResolveWasUnique(validatedValueType, discoveredSuitableTypes);
        Type suitableType = discoveredSuitableTypes.get(0);
        suitableTypeMap.put(validatedValueType, suitableType);
        return availableValidatorTypes.get(suitableType);
    }

    private void verifyResolveWasUnique(Type valueClass, List<Type> assignableClasses) {
        if (assignableClasses.size() == 0) {
            String className = valueClass.toString();
            if (valueClass instanceof Class) {
                Class clazz = (Class)valueClass;
                className = clazz.isArray() ? clazz.getComponentType().toString() + "[]" : clazz.getName();
            }
            throw log.getNoValidatorFoundForTypeException(className);
        }
        if (assignableClasses.size() > 1) {
            StringBuilder builder = new StringBuilder();
            for (Type clazz : assignableClasses) {
                builder.append(clazz);
                builder.append(", ");
            }
            builder.delete(builder.length() - 2, builder.length());
            throw log.getMoreThanOneValidatorFoundForTypeException(valueClass, builder.toString());
        }
    }

    private List<Type> findSuitableValidatorTypes(Type type, Map<Type, Class<? extends ConstraintValidator<?, ?>>> availableValidatorTypes) {
        ArrayList<Type> determinedSuitableTypes = new ArrayList<Type>();
        for (Type validatorType : availableValidatorTypes.keySet()) {
            if (!TypeHelper.isAssignable(validatorType, type) || determinedSuitableTypes.contains(validatorType)) continue;
            determinedSuitableTypes.add(validatorType);
        }
        return determinedSuitableTypes;
    }

    private void resolveAssignableTypes(List<Type> assignableTypes) {
        if (assignableTypes.size() == 0 || assignableTypes.size() == 1) {
            return;
        }
        ArrayList<Type> typesToRemove = new ArrayList<Type>();
        do {
            typesToRemove.clear();
            Type type = assignableTypes.get(0);
            for (int i = 1; i < assignableTypes.size(); ++i) {
                if (TypeHelper.isAssignable(type, assignableTypes.get(i))) {
                    typesToRemove.add(type);
                    continue;
                }
                if (!TypeHelper.isAssignable(assignableTypes.get(i), type)) continue;
                typesToRemove.add(assignableTypes.get(i));
            }
            assignableTypes.removeAll(typesToRemove);
        } while (typesToRemove.size() > 0);
    }

    private <V> void initializeConstraint(ConstraintDescriptor<A> descriptor, ConstraintValidator<A, V> constraintValidator) {
        try {
            constraintValidator.initialize(descriptor.getAnnotation());
        }
        catch (RuntimeException e) {
            throw log.getUnableToInitializeConstraintValidatorException(constraintValidator.getClass().getName(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConstraintTree");
        sb.append("{ descriptor=").append(this.descriptor);
        sb.append(", isRoot=").append(this.parent == null);
        sb.append('}');
        return sb.toString();
    }

    private static final class CompositionResult {
        private boolean allTrue;
        private boolean atLeastOneTrue;

        CompositionResult(boolean allTrue, boolean atLeastOneTrue) {
            this.allTrue = allTrue;
            this.atLeastOneTrue = atLeastOneTrue;
        }

        public boolean isAllTrue() {
            return this.allTrue;
        }

        public boolean isAtLeastOneTrue() {
            return this.atLeastOneTrue;
        }

        public void setAllTrue(boolean allTrue) {
            this.allTrue = allTrue;
        }

        public void setAtLeastOneTrue(boolean atLeastOneTrue) {
            this.atLeastOneTrue = atLeastOneTrue;
        }
    }

    private static final class ConstraintValidatorCacheKey {
        private ConstraintValidatorFactory constraintValidatorFactory;
        private Type validatedType;

        private ConstraintValidatorCacheKey(ConstraintValidatorFactory constraintValidatorFactory, Type validatorType) {
            this.constraintValidatorFactory = constraintValidatorFactory;
            this.validatedType = validatorType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConstraintValidatorCacheKey that = (ConstraintValidatorCacheKey)o;
            if (this.constraintValidatorFactory != null ? !this.constraintValidatorFactory.equals(that.constraintValidatorFactory) : that.constraintValidatorFactory != null) {
                return false;
            }
            return !(this.validatedType != null ? !this.validatedType.equals(that.validatedType) : that.validatedType != null);
        }

        public int hashCode() {
            int result = this.constraintValidatorFactory != null ? this.constraintValidatorFactory.hashCode() : 0;
            result = 31 * result + (this.validatedType != null ? this.validatedType.hashCode() : 0);
            return result;
        }
    }
}

