package models.services
import forms._
import models._
import org.squeryl._
import org.squeryl.PrimitiveTypeMode._

case class DesignChangeManager() {
  def designChange(data: DesignChangeRelationForm) = {
    val dc = PartsListDb.designChanges.where(dc => dc.dcNo === data.dcno).head
    val parent = PartManager().getByName(data.partsListBeanBefore.parent)
    if(!data.partsListBeanBefore.child.isEmpty()) {
      val delRelation = parent.parts.assign(PartManager().getByName(data.partsListBeanBefore.child))
      dc.delPartRelation.assign(delRelation)
      delRelation.dcSeq = dc.dcSeq
      PartsListDb.partRelations.update(delRelation)
    }
    if(!data.partsListBeanAfter.child.isEmpty()) {
      val addRelation = parent.parts.associate(PartManager().getByName(data.partsListBeanAfter.child))
      dc.addPartRelation.associate(addRelation)
      addRelation.quantity = data.partsListBeanAfter.quantity
      addRelation.dcSeq = dc.dcSeq
      PartsListDb.partRelations.update(addRelation)
    }
    dc.dcSeq += 1
    PartsListDb.designChanges.update(dc)
  }

}