package controllers

import play.api._
import play.api.i18n._
import play.api.mvc._
import play.api.mvc.MultipartFormData.FilePart
import play.api.data._
import play.api.data.Forms._
import play.api.libs.Files.TemporaryFile
import forms._
import models._
import beans._
import org.squeryl._
import org.squeryl.PrimitiveTypeMode._
import scala.collection.mutable.ArrayBuffer
import java.io.File
import java.io.FileInputStream

object PartsMasterController extends Controller{
   
   val Home = Redirect(routes.PartsMasterController.list(0,""))

   val partRegistForm = Form(
       mapping(
           "name" -> nonEmptyText,
           "atach" -> mapping(
               "grpName" -> text
             )(AtachForm.apply)(AtachForm.unapply),
           "projectName" -> nonEmptyText
        )(PartForm.apply)(PartForm.unapply)
    )

	def create = Action { implicit request =>
	  Ok(views.html.createPartForm(partRegistForm))
	}

	def partRegistration() = Action(parse.multipartFormData) { implicit request =>
	  partRegistForm.bindFromRequest.fold(
	      formWithErrors => BadRequest(views.html.createPartForm(formWithErrors)),
//	      formWithErrors => BadRequest(views.html.error(formWithErrors)),
	      part => {
	        inTransaction {
	          val project = getProject(part.projectName)	          
	    	   val newPart = PartsListDb.parts.insert(Part(part.name, part.atach, project.id))
              request.body.file("atach").map { atach =>
              	insertAtach(atach, newPart.atach.grpName, newPart.id)
	    	    }
	    	  Home.flashing("success" -> "Part %s has been created".format(part.name))
	        }  
	      }
	  )
	}

	def update(id:Long) = Action { implicit request =>
	  inTransaction {
	    val part = getPart(id)
	    val partForm = PartForm(part.name, null, part.project.assign(part.project.head).name)
		Ok(views.html.updatePartForm(partRegistForm.fill(partForm), id, part))
	  }
	}

	def partModification(id:Long) = Action(parse.multipartFormData) { implicit request =>
	  partRegistForm.bindFromRequest.fold(
	      formWithErrors => BadRequest(views.html.updatePartForm(formWithErrors, id , null)),
	      part => {
	        inTransaction {
	          val project = getProject(part.projectName)
	          val updPart = getPart(id)
	          updPart.name = part.name
	          updPart.projectId = project.id
	          PartsListDb.parts.update(updPart)
	    	   request.body.file("atach").map { atach =>
	    	     insertAtach(atach, part.atach.grpName, updPart.id)
	    	    }
	    	  Home.flashing("success" -> "Part %s has been created".format(part.name))
	        }  
	      }
	  )
	}

	def insertAtach(atach:FilePart[TemporaryFile], grpName:String, id:Long) = {
      val filename = atach.filename
      val contentType = atach.contentType
      var folder = Messages("atach.folder")
      if(!folder.endsWith("/")) {folder = folder.concat("/")}
      val url = folder + filename
      atach.ref.moveTo(new File(url), true)
      PartsListDb.atachs.insert(Atach(contentType.get, filename, grpName, id))
	}

	def partDelete(id:Long) = Action {
	  inTransaction {
	    PartsListDb.parts.deleteWhere(p => p.id === id)
    	Home.flashing("success" -> "Part %s has been created".format(id))
	  }
	}
	
	def list(page:Int, key:String) = Action { implicit request =>
	  inTransaction {
		  val row = Integer.decode(Messages("list.row"))
		  val buff = PartsListDb.parts.where(p => p.name like key + "%")
		  Ok(views.html.partsmastershow(buff.page(page*row, row), buff.size, key, page))
	  }
	}
	
	def getPart(id:Long):Part =  {
	  PartsListDb.parts.where(p => p.id === id).head
	}

	def getProject(name:String):Project = {
	  PartsListDb.projects.where(p => p.name === name).head
	 }
	

}