package controllers.services
import java.io.FileInputStream
import scala.io.Source
import play.api.mvc.MultipartFormData.FilePart
import play.api.libs.Files.TemporaryFile
import models.services._
import beans._
import org.squeryl.PrimitiveTypeMode._
import scala.reflect.runtime.{universe => ru}

case class CsvInput() {
  def getTypeTag[T: ru.TypeTag](obj: T) = ru.typeTag[T]
  
  def importCsvFile(atach:FilePart[TemporaryFile], clsName: String) = {
      val file = atach.ref.file
      val fis = new FileInputStream(file)
      val src = Source.fromInputStream(fis)
      val itr = src.getLines
      inTransaction {
        val runtimeMirror =ru.runtimeMirror(Thread.currentThread.getContextClassLoader)
        val classSymbol = runtimeMirror.staticClass(clsName).toType
        val cm = Class.forName(clsName).newInstance()
        val im = runtimeMirror.reflect(cm)
        for(it <- itr) {
          var i:Int=0
          if(it!="") {
            for(f<-Class.forName(clsName).getDeclaredFields()){
            	classSymbol.declarations
              val fieldSymbol = classSymbol.declaration(ru.newTermName(f.getName())).asTerm
              val fm =im.reflectField(fieldSymbol)
              fm.set(
            		 f.getType().getName() match {
            		 	case "long" =>
            		 		it.split(",").apply(i) match{
            		 			case "" => 0
            		 			case _ => it.split(",").apply(i).toInt
            		 		}
            		 	case _ =>
            		 		it.split(",").apply(i) match{
            		 			case "" => " "
            		 			case _ => it.split(",").apply(i)
            		 		}
                     }
                )
              i += 1
              }
            PartRelationManager().insert(cm, null, 0)
            }
          }
       }
  }

}