package models.services
import beans._
import models._
import controllers.services._
import org.squeryl._
import org.squeryl.PrimitiveTypeMode._
import scala.collection.mutable.HashMap
case class PartRelationManager() {
  def insert(data:PartsListBean, dc:DesignChange, dcSeq: Long):String = {
    if(Specification().loopSpec(data)) {
      val pr = PartManager().getByName(data.parent).head.parts.associate(PartManager().getByName(data.child).head)
      // insertの後、attributeの更新
      updatePr(pr, data.quantity, data.relationKey, dcSeq, null, dc)
      return null
    } else {
      return "form.error1"
    }
  }
  
  def insert(dataAny:Any, dc:DesignChange, dcSeq: Long):Unit = {
    val data = dataAny.asInstanceOf[PartsListBean]
    insert(data, dc, dcSeq)
  }
  def update(data:PartsListBean, childName:String):String = {
    if(data.child == childName) {
      if(Specification().loopSpec(data)) {
        //PartRelation データ更新処理
        val pr = PartManager().getByName(data.parent).head.parts.assign(PartManager().getByName(data.child).head)
        updatePr(pr, data.quantity, data.relationKey, 0, null, null)
        return null
      } else {
       return "form.error1"
       }
    } else {
      //PartRelation キー情報（ChildId）の更新なので削除／登録処理
      delete(data, childName)
      insert(data, null, 0)
     }
  }
  
  def updatePr(pr: PartRelation, quantity: Long, relationKey: String, dcSeq: Long, delDc: DesignChange, addDc: DesignChange) = {
    if(delDc != null) {
      delDc.delPartRelation.assign(pr)
    }
    if(addDc != null) {
      addDc.addPartRelation.associate(pr)
    }
    pr.quantity = quantity
    pr.relationKey = relationKey
    pr.dcSeq = dcSeq
    PartsListDb.partRelations.update(pr)
    if(delDc != null) {
      delDc.delPartRelation.assign(pr)
    }
    if(addDc != null) {
      addDc.addPartRelation.associate(pr)
    }
  }
  
  def delete(data: PartsListBean, childName: String) = {
       PartManager().getByName(data.parent).head.parts.dissociate(PartManager().getByName(childName).head)
  }
  
}