/*
 * Decompiled with CFR 0.152.
 */
package tyrex.services;

import tyrex.util.Configuration;
import tyrex.util.Logger;
import tyrex.util.Messages;

public final class Clock
extends Thread {
    public static final int UNSYNCH_TICKS = 100;
    public static final int SYNCH_EVERY = 10;
    private static long _clock;
    private static int _unsynchTicks;
    private static int _synchEvery;
    private static long _advance;
    private static int _adjust;
    static /* synthetic */ Class class$tyrex$services$Clock;

    public static synchronized long clock() {
        return _clock;
    }

    public static void setUnsynchTicks(int n) {
        if (n <= 0) {
            n = 100;
        } else if (n < 100) {
            n = 100;
        }
        _unsynchTicks = n;
    }

    public static int getUnsynchTicks() {
        return _unsynchTicks;
    }

    public static void setSynchEvery(int n) {
        if (n <= 0) {
            n = 10;
        }
        _synchEvery = n;
    }

    public static synchronized void advance(long l) {
        _advance += l;
        _clock += l;
    }

    public static long getAdvance() {
        return _advance;
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    int n = 0;
                    while (n < _synchEvery) {
                        Thread.sleep(_unsynchTicks);
                        Class clazz = class$tyrex$services$Clock == null ? Clock.class$("tyrex.services.Clock") : class$tyrex$services$Clock;
                        synchronized (clazz) {
                            _clock += (long)(_unsynchTicks + _adjust);
                        }
                        ++n;
                    }
                    Clock.synchronize();
                }
            }
            catch (Throwable throwable) {
                Logger.tyrex.error((Object)"Internal error in clock daemon", throwable);
                continue;
            }
            break;
        }
    }

    public static synchronized long synchronize() {
        int n;
        long l;
        long l2;
        long l3 = System.currentTimeMillis();
        if (l3 != (l2 = (l = _clock) - _advance) && (n = (int)(l3 - l2) / _synchEvery) != 0) {
            _adjust += n;
        }
        if (l3 > l2) {
            _clock = l = l3 + _advance;
        }
        return l;
    }

    private Clock() {
        super(Messages.message("tyrex.util.clockDaemon"));
        _clock = System.currentTimeMillis();
        this.setPriority(10);
        this.setDaemon(true);
        this.start();
    }

    public static void main(String[] stringArray) {
        try {
            int n = 1000000;
            System.out.println("Using Clock.clock()");
            long l = System.currentTimeMillis();
            int n2 = 0;
            while (n2 < n) {
                if (n2 % 100 == 0) {
                    Clock.synchronize();
                } else {
                    Clock.clock();
                }
                ++n2;
            }
            l = System.currentTimeMillis() - l;
            System.out.println("Performed " + n + " in " + l + "ms");
            System.out.println("Using System.currentTimeMillis()");
            l = System.currentTimeMillis();
            int n3 = 0;
            while (n3 < n) {
                System.currentTimeMillis();
                ++n3;
            }
            l = System.currentTimeMillis() - l;
            System.out.println("Performed " + n + " in " + l + "ms");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        int n = Configuration.getInteger("tyrex.clock.unsynchTicks");
        _unsynchTicks = n > 0 ? n : 100;
        n = Configuration.getInteger("tyrex.clock.synchEvery");
        int n2 = _synchEvery = n > 0 ? n : 10;
        if (Configuration.verbose) {
            Logger.tyrex.info((Object)Messages.format("tyrex.util.clockDaemonStart", new Long(_unsynchTicks), new Long(_unsynchTicks * _synchEvery)));
        }
        new Clock();
    }
}

