/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.serializers;

import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.scanners.TypeElementsScanner;
import org.reflections.scanners.TypesScanner;
import org.reflections.serializers.Serializer;
import org.reflections.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCodeSerializer
implements Serializer {
    private static final char pathSeparator = '$';
    private static final String arrayDescriptor = "$$";
    private static final String tokenSeparator = "_";

    @Override
    public Reflections read(InputStream inputStream) {
        throw new UnsupportedOperationException("read is not implemented on JavaCodeSerializer");
    }

    @Override
    public File save(Reflections reflections, String name) {
        String className;
        String packageName;
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        String filename = name.replace('.', '/').concat(".java");
        File file = Utils.prepareFile(filename);
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            packageName = "";
            className = name.substring(name.lastIndexOf(47) + 1);
        } else {
            packageName = name.substring(name.lastIndexOf(47) + 1, lastDot);
            className = name.substring(lastDot + 1);
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("//generated using Reflections JavaCodeSerializer").append(" [").append(new Date()).append("]").append("\n");
            if (packageName.length() != 0) {
                sb.append("package ").append(packageName).append(";\n");
                sb.append("\n");
            }
            sb.append("import static org.reflections.serializers.JavaCodeSerializer.*;\n");
            sb.append("\n");
            sb.append("public interface ").append(className).append(" extends IElement").append(" {\n\n");
            sb.append(this.toString(reflections));
            sb.append("}\n");
            Files.write((CharSequence)sb.toString(), (File)new File(filename), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        return file;
    }

    @Override
    public String toString(Reflections reflections) {
        if ((reflections.getStore().get(TypesScanner.class).isEmpty() || reflections.getStore().get(TypeElementsScanner.class).isEmpty()) && Reflections.log != null) {
            Reflections.log.warn("JavaCodeSerializer needs TypeScanner and TypeElemenetsScanner configured");
        }
        StringBuilder sb = new StringBuilder();
        ArrayList prevPaths = Lists.newArrayList();
        int indent = 1;
        ArrayList keys = Lists.newArrayList((Iterable)reflections.getStore().get(TypesScanner.class).keySet());
        Collections.sort(keys);
        for (String fqn : keys) {
            int j;
            int i;
            ArrayList typePaths = Lists.newArrayList((Object[])fqn.split("\\."));
            for (i = 0; i < Math.min(typePaths.size(), prevPaths.size()) && ((String)typePaths.get(i)).equals(prevPaths.get(i)); ++i) {
            }
            for (j = prevPaths.size(); j > i; --j) {
                sb.append(Utils.repeat("\t", --indent)).append("}\n");
            }
            for (j = i; j < typePaths.size() - 1; ++j) {
                sb.append(Utils.repeat("\t", indent++)).append("public interface ").append(this.getNonDuplicateName((String)typePaths.get(j), typePaths, j)).append(" extends IPackage").append(" {\n");
            }
            String className = (String)typePaths.get(typePaths.size() - 1);
            ArrayList fields = Lists.newArrayList();
            SetMultimap methods = Multimaps.newSetMultimap(new HashMap(), (Supplier)new Supplier<Set<String>>(){

                public Set<String> get() {
                    return Sets.newHashSet();
                }
            });
            for (String element : reflections.getStore().get(TypeElementsScanner.class, fqn)) {
                if (element.contains("(")) {
                    if (element.startsWith("<")) continue;
                    int i1 = element.indexOf(40);
                    String name = element.substring(0, i1);
                    String params = element.substring(i1 + 1, element.indexOf(")"));
                    String paramsDescriptor = "";
                    if (params.length() != 0) {
                        paramsDescriptor = tokenSeparator + params.replace('.', '$').replace(", ", tokenSeparator).replace("[]", arrayDescriptor);
                    }
                    String normalized = name + paramsDescriptor;
                    methods.put((Object)name, (Object)normalized);
                    continue;
                }
                fields.add(element);
            }
            sb.append(Utils.repeat("\t", indent++)).append("public interface ").append(this.getNonDuplicateName(className, typePaths, typePaths.size() - 1)).append(" extends IClass").append(" {\n");
            if (!fields.isEmpty()) {
                for (String field : fields) {
                    sb.append(Utils.repeat("\t", indent)).append("public interface ").append(this.getNonDuplicateName(field, typePaths)).append(" extends IField").append(" {}\n");
                }
            }
            if (!methods.isEmpty()) {
                for (Map.Entry entry : methods.entries()) {
                    String simpleName = (String)entry.getKey();
                    String normalized = (String)entry.getValue();
                    String methodName = methods.get((Object)simpleName).size() == 1 ? simpleName : normalized;
                    methodName = this.getNonDuplicateName(methodName, fields);
                    sb.append(Utils.repeat("\t", indent)).append("public interface ").append(this.getNonDuplicateName(methodName, typePaths)).append(" extends IMethod").append(" {}\n");
                }
            }
            prevPaths = typePaths;
        }
        for (int j = prevPaths.size(); j >= 1; --j) {
            sb.append(Utils.repeat("\t", j)).append("}\n");
        }
        return sb.toString();
    }

    private String getNonDuplicateName(String candidate, List<String> prev, int offset) {
        for (int i = 0; i < offset; ++i) {
            if (!candidate.equals(prev.get(i))) continue;
            return this.getNonDuplicateName(candidate + tokenSeparator, prev, offset);
        }
        return candidate;
    }

    private String getNonDuplicateName(String candidate, List<String> prev) {
        return this.getNonDuplicateName(candidate, prev, prev.size());
    }

    public static Class<?> resolveClassOf(Class<? extends IElement> element) throws ClassNotFoundException {
        ArrayList path = Lists.newArrayList();
        for (Class<IElement> cursor = element; cursor != null && IElement.class.isAssignableFrom(cursor); cursor = cursor.getDeclaringClass()) {
            path.add(cursor);
        }
        Collections.reverse(path);
        ArrayList ognl = Lists.newArrayList();
        for (int i = 1; i < path.size() && (IPackage.class.isAssignableFrom((Class)path.get(i)) || IClass.class.isAssignableFrom((Class)path.get(i))); ++i) {
            ognl.add(((Class)path.get(i)).getSimpleName());
        }
        String classOgnl = Joiner.on((String)".").join((Iterable)ognl).replace(".$", "$");
        return Class.forName(classOgnl);
    }

    public static Class<?> resolveClass(Class<? extends IClass> aClass) {
        try {
            return JavaCodeSerializer.resolveClassOf(aClass);
        }
        catch (Exception e) {
            throw new ReflectionsException("could not resolve to class " + aClass.getName(), e);
        }
    }

    public static Field resolveField(Class<? extends IField> aField) {
        try {
            String name = aField.getSimpleName();
            return JavaCodeSerializer.resolveClassOf(aField).getDeclaredField(name);
        }
        catch (Exception e) {
            throw new ReflectionsException("could not resolve to field " + aField.getName(), e);
        }
    }

    public static Method resolveMethod(Class<? extends IMethod> aMethod) {
        String methodOgnl = aMethod.getSimpleName();
        try {
            Class[] paramTypes;
            String methodName;
            if (methodOgnl.contains(tokenSeparator)) {
                methodName = methodOgnl.substring(0, methodOgnl.indexOf(tokenSeparator));
                String[] params = methodOgnl.substring(methodOgnl.indexOf(tokenSeparator) + 1).split(tokenSeparator);
                paramTypes = new Class[params.length];
                for (int i = 0; i < params.length; ++i) {
                    String typeName = params[i].replace(arrayDescriptor, "[]").replace('$', '.');
                    paramTypes[i] = ReflectionUtils.forName(typeName, new ClassLoader[0]);
                }
            } else {
                methodName = methodOgnl;
                paramTypes = null;
            }
            return JavaCodeSerializer.resolveClassOf(aMethod).getDeclaredMethod(methodName, paramTypes);
        }
        catch (Exception e) {
            throw new ReflectionsException("could not resolve to method " + aMethod.getName(), e);
        }
    }

    public static interface IMethod
    extends IElement {
    }

    public static interface IField
    extends IElement {
    }

    public static interface IClass
    extends IElement {
    }

    public static interface IPackage
    extends IElement {
    }

    public static interface IElement {
    }
}

