/*
 * Decompiled with CFR 0.152.
 */
package tyrex.resource.jdbc.xa;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import tyrex.resource.jdbc.xa.TyrexConnection;
import tyrex.resource.jdbc.xa.TyrexResultSetImpl;

final class TyrexDatabaseMetaDataImpl
implements DatabaseMetaData {
    private DatabaseMetaData _databaseMetaData;
    private TyrexConnection _connection;
    private final int _driverMajorVersion;
    private final int _driverMinorVersion;

    TyrexDatabaseMetaDataImpl(DatabaseMetaData databaseMetaData, TyrexConnection tyrexConnection) throws SQLException {
        if (null == databaseMetaData) {
            throw new IllegalArgumentException("The argument 'databaseMetaData' is null.");
        }
        if (null == tyrexConnection) {
            throw new IllegalArgumentException("The argument 'connection' is null.");
        }
        this._databaseMetaData = databaseMetaData;
        this._connection = tyrexConnection;
        this._driverMajorVersion = databaseMetaData.getDriverMajorVersion();
        this._driverMinorVersion = databaseMetaData.getDriverMinorVersion();
    }

    public synchronized boolean allProceduresAreCallable() throws SQLException {
        this.validate();
        return this._databaseMetaData.allProceduresAreCallable();
    }

    public synchronized boolean allTablesAreSelectable() throws SQLException {
        this.validate();
        return this._databaseMetaData.allTablesAreSelectable();
    }

    public synchronized String getURL() throws SQLException {
        this.validate();
        return this._databaseMetaData.getURL();
    }

    public synchronized String getUserName() throws SQLException {
        this.validate();
        return this._databaseMetaData.getUserName();
    }

    public synchronized boolean isReadOnly() throws SQLException {
        this.validate();
        return this._databaseMetaData.isReadOnly();
    }

    public synchronized boolean nullsAreSortedHigh() throws SQLException {
        this.validate();
        return this._databaseMetaData.nullsAreSortedHigh();
    }

    public synchronized boolean nullsAreSortedLow() throws SQLException {
        this.validate();
        return this._databaseMetaData.nullsAreSortedLow();
    }

    public synchronized boolean nullsAreSortedAtStart() throws SQLException {
        this.validate();
        return this._databaseMetaData.nullsAreSortedAtStart();
    }

    public synchronized boolean nullsAreSortedAtEnd() throws SQLException {
        this.validate();
        return this._databaseMetaData.nullsAreSortedAtEnd();
    }

    public synchronized String getDatabaseProductName() throws SQLException {
        this.validate();
        return this._databaseMetaData.getDatabaseProductName();
    }

    public synchronized String getDatabaseProductVersion() throws SQLException {
        this.validate();
        return this._databaseMetaData.getDatabaseProductVersion();
    }

    public synchronized String getDriverName() throws SQLException {
        this.validate();
        return this._databaseMetaData.getDriverName();
    }

    public synchronized String getDriverVersion() throws SQLException {
        this.validate();
        return this._databaseMetaData.getDriverVersion();
    }

    public int getDriverMajorVersion() {
        return this._driverMajorVersion;
    }

    public int getDriverMinorVersion() {
        return this._driverMinorVersion;
    }

    public synchronized boolean usesLocalFiles() throws SQLException {
        this.validate();
        return this._databaseMetaData.usesLocalFiles();
    }

    public synchronized boolean usesLocalFilePerTable() throws SQLException {
        this.validate();
        return this._databaseMetaData.usesLocalFilePerTable();
    }

    public synchronized boolean supportsMixedCaseIdentifiers() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsMixedCaseIdentifiers();
    }

    public synchronized boolean storesUpperCaseIdentifiers() throws SQLException {
        this.validate();
        return this._databaseMetaData.storesUpperCaseIdentifiers();
    }

    public synchronized boolean storesLowerCaseIdentifiers() throws SQLException {
        this.validate();
        return this._databaseMetaData.storesLowerCaseIdentifiers();
    }

    public synchronized boolean storesMixedCaseIdentifiers() throws SQLException {
        this.validate();
        return this._databaseMetaData.storesMixedCaseIdentifiers();
    }

    public synchronized boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsMixedCaseQuotedIdentifiers();
    }

    public synchronized boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        this.validate();
        return this._databaseMetaData.storesUpperCaseQuotedIdentifiers();
    }

    public synchronized boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        this.validate();
        return this._databaseMetaData.storesLowerCaseQuotedIdentifiers();
    }

    public synchronized boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        this.validate();
        return this._databaseMetaData.storesMixedCaseQuotedIdentifiers();
    }

    public synchronized String getIdentifierQuoteString() throws SQLException {
        this.validate();
        return this._databaseMetaData.getIdentifierQuoteString();
    }

    public synchronized String getSQLKeywords() throws SQLException {
        this.validate();
        return this._databaseMetaData.getSQLKeywords();
    }

    public synchronized String getNumericFunctions() throws SQLException {
        this.validate();
        return this._databaseMetaData.getNumericFunctions();
    }

    public synchronized String getStringFunctions() throws SQLException {
        this.validate();
        return this._databaseMetaData.getStringFunctions();
    }

    public synchronized String getSystemFunctions() throws SQLException {
        this.validate();
        return this._databaseMetaData.getSystemFunctions();
    }

    public synchronized String getTimeDateFunctions() throws SQLException {
        this.validate();
        return this._databaseMetaData.getTimeDateFunctions();
    }

    public synchronized String getSearchStringEscape() throws SQLException {
        this.validate();
        return this._databaseMetaData.getSearchStringEscape();
    }

    public synchronized String getExtraNameCharacters() throws SQLException {
        this.validate();
        return this._databaseMetaData.getExtraNameCharacters();
    }

    public synchronized boolean supportsAlterTableWithAddColumn() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsAlterTableWithAddColumn();
    }

    public synchronized boolean supportsAlterTableWithDropColumn() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsAlterTableWithDropColumn();
    }

    public synchronized boolean supportsColumnAliasing() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsColumnAliasing();
    }

    public synchronized boolean nullPlusNonNullIsNull() throws SQLException {
        this.validate();
        return this._databaseMetaData.nullPlusNonNullIsNull();
    }

    public synchronized boolean supportsConvert() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsConvert();
    }

    public synchronized boolean supportsConvert(int n, int n2) throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsConvert(n, n2);
    }

    public synchronized boolean supportsTableCorrelationNames() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsTableCorrelationNames();
    }

    public synchronized boolean supportsDifferentTableCorrelationNames() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsDifferentTableCorrelationNames();
    }

    public synchronized boolean supportsExpressionsInOrderBy() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsExpressionsInOrderBy();
    }

    public synchronized boolean supportsOrderByUnrelated() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsOrderByUnrelated();
    }

    public synchronized boolean supportsGroupBy() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsGroupBy();
    }

    public synchronized boolean supportsGroupByUnrelated() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsGroupByUnrelated();
    }

    public synchronized boolean supportsGroupByBeyondSelect() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsGroupByBeyondSelect();
    }

    public synchronized boolean supportsLikeEscapeClause() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsLikeEscapeClause();
    }

    public synchronized boolean supportsMultipleResultSets() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsMultipleResultSets();
    }

    public synchronized boolean supportsMultipleTransactions() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsMultipleTransactions();
    }

    public synchronized boolean supportsNonNullableColumns() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsNonNullableColumns();
    }

    public synchronized boolean supportsMinimumSQLGrammar() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsMinimumSQLGrammar();
    }

    public synchronized boolean supportsCoreSQLGrammar() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsCoreSQLGrammar();
    }

    public synchronized boolean supportsExtendedSQLGrammar() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsExtendedSQLGrammar();
    }

    public synchronized boolean supportsANSI92EntryLevelSQL() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsANSI92EntryLevelSQL();
    }

    public synchronized boolean supportsANSI92IntermediateSQL() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsANSI92IntermediateSQL();
    }

    public synchronized boolean supportsANSI92FullSQL() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsANSI92FullSQL();
    }

    public synchronized boolean supportsIntegrityEnhancementFacility() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsIntegrityEnhancementFacility();
    }

    public synchronized boolean supportsOuterJoins() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsOuterJoins();
    }

    public synchronized boolean supportsFullOuterJoins() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsFullOuterJoins();
    }

    public synchronized boolean supportsLimitedOuterJoins() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsLimitedOuterJoins();
    }

    public synchronized String getSchemaTerm() throws SQLException {
        this.validate();
        return this._databaseMetaData.getSchemaTerm();
    }

    public synchronized String getProcedureTerm() throws SQLException {
        this.validate();
        return this._databaseMetaData.getProcedureTerm();
    }

    public synchronized String getCatalogTerm() throws SQLException {
        this.validate();
        return this._databaseMetaData.getCatalogTerm();
    }

    public synchronized boolean isCatalogAtStart() throws SQLException {
        this.validate();
        return this._databaseMetaData.isCatalogAtStart();
    }

    public synchronized String getCatalogSeparator() throws SQLException {
        this.validate();
        return this._databaseMetaData.getCatalogSeparator();
    }

    public synchronized boolean supportsSchemasInDataManipulation() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsSchemasInDataManipulation();
    }

    public synchronized boolean supportsSchemasInProcedureCalls() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsSchemasInProcedureCalls();
    }

    public synchronized boolean supportsSchemasInTableDefinitions() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsSchemasInTableDefinitions();
    }

    public synchronized boolean supportsSchemasInIndexDefinitions() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsSchemasInIndexDefinitions();
    }

    public synchronized boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsSchemasInPrivilegeDefinitions();
    }

    public synchronized boolean supportsCatalogsInDataManipulation() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsCatalogsInDataManipulation();
    }

    public synchronized boolean supportsCatalogsInProcedureCalls() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsCatalogsInProcedureCalls();
    }

    public synchronized boolean supportsCatalogsInTableDefinitions() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsCatalogsInTableDefinitions();
    }

    public synchronized boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsCatalogsInIndexDefinitions();
    }

    public synchronized boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsCatalogsInPrivilegeDefinitions();
    }

    public synchronized boolean supportsPositionedDelete() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsPositionedDelete();
    }

    public synchronized boolean supportsPositionedUpdate() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsPositionedUpdate();
    }

    public synchronized boolean supportsSelectForUpdate() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsSelectForUpdate();
    }

    public synchronized boolean supportsStoredProcedures() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsStoredProcedures();
    }

    public synchronized boolean supportsSubqueriesInComparisons() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsSubqueriesInComparisons();
    }

    public synchronized boolean supportsSubqueriesInExists() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsSubqueriesInExists();
    }

    public synchronized boolean supportsSubqueriesInIns() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsSubqueriesInIns();
    }

    public synchronized boolean supportsSubqueriesInQuantifieds() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsSubqueriesInQuantifieds();
    }

    public synchronized boolean supportsCorrelatedSubqueries() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsCorrelatedSubqueries();
    }

    public synchronized boolean supportsUnion() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsUnion();
    }

    public synchronized boolean supportsUnionAll() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsUnionAll();
    }

    public synchronized boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsOpenCursorsAcrossCommit();
    }

    public synchronized boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsOpenCursorsAcrossRollback();
    }

    public synchronized boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsOpenStatementsAcrossCommit();
    }

    public synchronized boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsOpenStatementsAcrossRollback();
    }

    public synchronized int getMaxBinaryLiteralLength() throws SQLException {
        this.validate();
        return this._databaseMetaData.getMaxBinaryLiteralLength();
    }

    public synchronized int getMaxCharLiteralLength() throws SQLException {
        this.validate();
        return this._databaseMetaData.getMaxCharLiteralLength();
    }

    public synchronized int getMaxColumnNameLength() throws SQLException {
        this.validate();
        return this._databaseMetaData.getMaxColumnNameLength();
    }

    public synchronized int getMaxColumnsInGroupBy() throws SQLException {
        this.validate();
        return this._databaseMetaData.getMaxColumnsInGroupBy();
    }

    public synchronized int getMaxColumnsInIndex() throws SQLException {
        this.validate();
        return this._databaseMetaData.getMaxColumnsInIndex();
    }

    public synchronized int getMaxColumnsInOrderBy() throws SQLException {
        this.validate();
        return this._databaseMetaData.getMaxColumnsInOrderBy();
    }

    public synchronized int getMaxColumnsInSelect() throws SQLException {
        this.validate();
        return this._databaseMetaData.getMaxColumnsInSelect();
    }

    public synchronized int getMaxColumnsInTable() throws SQLException {
        this.validate();
        return this._databaseMetaData.getMaxColumnsInTable();
    }

    public synchronized int getMaxConnections() throws SQLException {
        this.validate();
        return this._databaseMetaData.getMaxConnections();
    }

    public synchronized int getMaxCursorNameLength() throws SQLException {
        this.validate();
        return this._databaseMetaData.getMaxCursorNameLength();
    }

    public synchronized int getMaxIndexLength() throws SQLException {
        this.validate();
        return this._databaseMetaData.getMaxIndexLength();
    }

    public synchronized int getMaxSchemaNameLength() throws SQLException {
        this.validate();
        return this._databaseMetaData.getMaxSchemaNameLength();
    }

    public synchronized int getMaxProcedureNameLength() throws SQLException {
        this.validate();
        return this._databaseMetaData.getMaxProcedureNameLength();
    }

    public synchronized int getMaxCatalogNameLength() throws SQLException {
        this.validate();
        return this._databaseMetaData.getMaxCatalogNameLength();
    }

    public synchronized int getMaxRowSize() throws SQLException {
        this.validate();
        return this._databaseMetaData.getMaxRowSize();
    }

    public synchronized boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        this.validate();
        return this._databaseMetaData.doesMaxRowSizeIncludeBlobs();
    }

    public synchronized int getMaxStatementLength() throws SQLException {
        this.validate();
        return this._databaseMetaData.getMaxStatementLength();
    }

    public synchronized int getMaxStatements() throws SQLException {
        this.validate();
        return this._databaseMetaData.getMaxStatements();
    }

    public synchronized int getMaxTableNameLength() throws SQLException {
        this.validate();
        return this._databaseMetaData.getMaxTableNameLength();
    }

    public synchronized int getMaxTablesInSelect() throws SQLException {
        this.validate();
        return this._databaseMetaData.getMaxTablesInSelect();
    }

    public synchronized int getMaxUserNameLength() throws SQLException {
        this.validate();
        return this._databaseMetaData.getMaxUserNameLength();
    }

    public synchronized int getDefaultTransactionIsolation() throws SQLException {
        this.validate();
        return this._databaseMetaData.getDefaultTransactionIsolation();
    }

    public synchronized boolean supportsTransactions() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsTransactions();
    }

    public synchronized boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsTransactionIsolationLevel(n);
    }

    public synchronized boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsDataDefinitionAndDataManipulationTransactions();
    }

    public synchronized boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsDataManipulationTransactionsOnly();
    }

    public synchronized boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        this.validate();
        return this._databaseMetaData.dataDefinitionCausesTransactionCommit();
    }

    public synchronized boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        this.validate();
        return this._databaseMetaData.dataDefinitionIgnoredInTransactions();
    }

    public synchronized ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        this.validate();
        return new TyrexResultSetImpl(this._databaseMetaData.getProcedures(string, string2, string3), this._connection);
    }

    public synchronized ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        this.validate();
        return new TyrexResultSetImpl(this._databaseMetaData.getProcedureColumns(string, string2, string3, string4), this._connection);
    }

    public synchronized ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        this.validate();
        return new TyrexResultSetImpl(this._databaseMetaData.getTables(string, string2, string3, stringArray), this._connection);
    }

    public synchronized ResultSet getSchemas() throws SQLException {
        this.validate();
        return new TyrexResultSetImpl(this._databaseMetaData.getSchemas(), this._connection);
    }

    public synchronized ResultSet getCatalogs() throws SQLException {
        this.validate();
        return new TyrexResultSetImpl(this._databaseMetaData.getCatalogs(), this._connection);
    }

    public synchronized ResultSet getTableTypes() throws SQLException {
        this.validate();
        return new TyrexResultSetImpl(this._databaseMetaData.getTableTypes(), this._connection);
    }

    public synchronized ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        this.validate();
        return new TyrexResultSetImpl(this._databaseMetaData.getColumns(string, string2, string3, string4), this._connection);
    }

    public synchronized ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        this.validate();
        return new TyrexResultSetImpl(this._databaseMetaData.getColumnPrivileges(string, string2, string3, string4), this._connection);
    }

    public synchronized ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        this.validate();
        return new TyrexResultSetImpl(this._databaseMetaData.getTablePrivileges(string, string2, string3), this._connection);
    }

    public synchronized ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        this.validate();
        return new TyrexResultSetImpl(this._databaseMetaData.getBestRowIdentifier(string, string2, string3, n, bl), this._connection);
    }

    public synchronized ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        this.validate();
        return new TyrexResultSetImpl(this._databaseMetaData.getVersionColumns(string, string2, string3), this._connection);
    }

    public synchronized ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        this.validate();
        return new TyrexResultSetImpl(this._databaseMetaData.getPrimaryKeys(string, string2, string3), this._connection);
    }

    public synchronized ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        this.validate();
        return new TyrexResultSetImpl(this._databaseMetaData.getImportedKeys(string, string2, string3), this._connection);
    }

    public synchronized ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        this.validate();
        return new TyrexResultSetImpl(this._databaseMetaData.getExportedKeys(string, string2, string3), this._connection);
    }

    public synchronized ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        this.validate();
        return new TyrexResultSetImpl(this._databaseMetaData.getCrossReference(string, string2, string3, string4, string5, string6), this._connection);
    }

    public synchronized ResultSet getTypeInfo() throws SQLException {
        this.validate();
        return new TyrexResultSetImpl(this._databaseMetaData.getTypeInfo(), this._connection);
    }

    public synchronized ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        this.validate();
        return new TyrexResultSetImpl(this._databaseMetaData.getIndexInfo(string, string2, string3, bl, bl2), this._connection);
    }

    public synchronized boolean supportsResultSetType(int n) throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsResultSetType(n);
    }

    public synchronized boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsResultSetConcurrency(n, n2);
    }

    public synchronized boolean ownUpdatesAreVisible(int n) throws SQLException {
        this.validate();
        return this._databaseMetaData.ownUpdatesAreVisible(n);
    }

    public synchronized boolean ownDeletesAreVisible(int n) throws SQLException {
        this.validate();
        return this._databaseMetaData.ownDeletesAreVisible(n);
    }

    public synchronized boolean ownInsertsAreVisible(int n) throws SQLException {
        this.validate();
        return this._databaseMetaData.ownInsertsAreVisible(n);
    }

    public synchronized boolean othersUpdatesAreVisible(int n) throws SQLException {
        this.validate();
        return this._databaseMetaData.othersUpdatesAreVisible(n);
    }

    public synchronized boolean othersDeletesAreVisible(int n) throws SQLException {
        this.validate();
        return this._databaseMetaData.othersDeletesAreVisible(n);
    }

    public synchronized boolean othersInsertsAreVisible(int n) throws SQLException {
        this.validate();
        return this._databaseMetaData.othersInsertsAreVisible(n);
    }

    public synchronized boolean updatesAreDetected(int n) throws SQLException {
        this.validate();
        return this._databaseMetaData.updatesAreDetected(n);
    }

    public synchronized boolean deletesAreDetected(int n) throws SQLException {
        this.validate();
        return this._databaseMetaData.deletesAreDetected(n);
    }

    public synchronized boolean insertsAreDetected(int n) throws SQLException {
        this.validate();
        return this._databaseMetaData.insertsAreDetected(n);
    }

    public synchronized boolean supportsBatchUpdates() throws SQLException {
        this.validate();
        return this._databaseMetaData.supportsBatchUpdates();
    }

    public synchronized ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        this.validate();
        return new TyrexResultSetImpl(this._databaseMetaData.getUDTs(string, string2, string3, nArray), this._connection);
    }

    public synchronized Connection getConnection() throws SQLException {
        return this._connection;
    }

    private void validate() throws SQLException {
        if (this._connection.isClosed()) {
            throw new SQLException("The connection has been closed.");
        }
    }
}

