/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.client;

import java.nio.ByteBuffer;

final class LutBuffer {
    public static final int TYPE_BYTE = 0;
    public static final int TYPE_WORD = 1;
    private final ByteBuffer buff;
    private final int dataType;
    private final int lutSize;
    private final int firstValueMapped;
    private final int depth;

    public LutBuffer(ByteBuffer backend, int[] descriptor, int vr) {
        if (descriptor[2] <= 8) {
            this.dataType = 0;
        } else if (descriptor[2] <= 16) {
            this.dataType = 1;
        } else {
            throw new IllegalArgumentException("The LUT's depth must be within 8 and 16, inclusive");
        }
        int n = this.lutSize = descriptor[0] == 0 ? 65536 : descriptor[0] & 0xFFFF;
        if (vr == 21843) {
            this.firstValueMapped = descriptor[1] & 0xFFFF;
        } else if (vr == 21331) {
            this.firstValueMapped = descriptor[1] << 16 >> 16;
        } else {
            throw new IllegalArgumentException("VR may only be US or SS");
        }
        this.depth = descriptor[2] & 0xFFFF;
        this.buff = backend;
    }

    public LutBuffer(ByteBuffer backend, int lutSize, int firstValueMapped, int depthInBits) {
        if (depthInBits <= 8) {
            this.dataType = 0;
        } else if (depthInBits <= 16) {
            this.dataType = 1;
        } else {
            throw new IllegalArgumentException("The LUT's depth must be within 8 and 16, inclusive");
        }
        this.lutSize = lutSize;
        this.firstValueMapped = firstValueMapped;
        this.depth = depthInBits;
        this.buff = backend;
    }

    public LutBuffer(ByteBuffer backend, int lutSize, int firstValueMapped, int depthInBits, int dataType) {
        if (dataType != 0 && dataType != 1) {
            throw new IllegalArgumentException("Bad dataType");
        }
        this.dataType = dataType;
        this.lutSize = lutSize;
        this.firstValueMapped = firstValueMapped;
        this.depth = depthInBits;
        this.buff = backend;
    }

    public int[] getDescriptor() {
        return new int[]{this.lutSize, this.firstValueMapped, this.depth};
    }

    public int getEntry(int index) {
        return this.dataType == 0 ? this.buff.get(index) & 0xFF : this.buff.getShort(index * 2) & 0xFFFF;
    }

    public int getEntryFromInput(int value) {
        if (value <= this.firstValueMapped) {
            return this.getEntry(0);
        }
        if (value - this.firstValueMapped >= this.lutSize) {
            return this.getEntry(this.lutSize - 1);
        }
        return this.getEntry(value - this.firstValueMapped);
    }

    public int getDepth() {
        return this.depth;
    }

    public int getFirstValueMapped() {
        return this.firstValueMapped;
    }

    public int getLutSize() {
        return this.lutSize;
    }
}

