/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.imageio.stream.ImageOutputStream;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmEncodeParam;
import org.dcm4che.data.DcmHandler;
import org.dcm4che.data.DcmObject;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.data.PersonName;
import org.dcm4che.data.SpecificCharacterSet;
import org.dcm4che.dict.DictionaryFactory;
import org.dcm4che.dict.Tags;
import org.dcm4che.dict.UIDDictionary;
import org.dcm4che.dict.VRMap;
import org.dcm4che.dict.VRs;
import org.dcm4che.util.DTFormat;
import org.dcm4cheri.data.DcmElementImpl;
import org.dcm4cheri.data.DcmObjectHandlerImpl;
import org.dcm4cheri.data.FragmentElement;
import org.dcm4cheri.data.PersonNameImpl;
import org.dcm4cheri.data.SAXHandlerAdapter;
import org.dcm4cheri.data.SAXHandlerAdapter2;
import org.dcm4cheri.data.StringElement;
import org.dcm4cheri.data.ValueElement;
import org.dcm4cheri.util.StringUtils;
import org.xml.sax.helpers.DefaultHandler;

abstract class DcmObjectImpl
implements DcmObject {
    static UIDDictionary DICT = DictionaryFactory.getInstance().getDefaultUIDDictionary();
    protected static final Logger log = Logger.getLogger(DcmObjectImpl.class);
    protected ArrayList list = new ArrayList();

    DcmObjectImpl() {
    }

    public DcmHandler getDcmHandler() {
        return new DcmObjectHandlerImpl(this);
    }

    public DefaultHandler getSAXHandler() {
        return new SAXHandlerAdapter(this.getDcmHandler());
    }

    public DefaultHandler getSAXHandler2(File basedir) {
        return new SAXHandlerAdapter2(this.getDcmHandler(), basedir);
    }

    public String getPrivateCreatorID() {
        return null;
    }

    public void setPrivateCreatorID(String privateCreatorID) {
        throw new UnsupportedOperationException();
    }

    public SpecificCharacterSet getSpecificCharacterSet() {
        return null;
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void clear() {
        this.list.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shareElements() {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int size = this.list.size();
            for (int i = 0; i < size; ++i) {
                this.list.set(i, ((DcmElement)this.list.get(i)).share());
            }
        }
    }

    private int indexOf(int tag) {
        int low = 0;
        int high = this.list.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            DcmElementImpl midVal = (DcmElementImpl)this.list.get(mid);
            long cmp = ((long)midVal.tag & 0xFFFFFFFFL) - ((long)tag & 0xFFFFFFFFL);
            if (cmp < 0L) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0L) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public boolean contains(int tag) {
        if (Tags.isPrivate(tag)) {
            try {
                tag = this.adjustPrivateTag(tag, false);
            }
            catch (DcmValueException e) {
                log.warn("Could not access Creator ID", e);
                return false;
            }
            if (tag == 0) {
                return false;
            }
        }
        return this.indexOf(tag) >= 0;
    }

    public boolean containsValue(int tag) {
        DcmElement e = this.get(tag);
        return e != null && !e.isEmpty();
    }

    public int vm(int tag) {
        int index;
        if (Tags.isPrivate(tag)) {
            try {
                tag = this.adjustPrivateTag(tag, false);
            }
            catch (DcmValueException e) {
                log.warn("Could not access Creator ID", e);
                return -1;
            }
            if (tag == 0) {
                return -1;
            }
        }
        return (index = this.indexOf(tag)) >= 0 ? ((DcmElement)this.list.get(index)).vm(this.getSpecificCharacterSet()) : -1;
    }

    private int adjustPrivateTag(int tag, boolean create) throws DcmValueException {
        String creatorID = this.getPrivateCreatorID();
        if (creatorID == null) {
            return tag;
        }
        int gr = tag & 0xFFFF0000;
        int el = 16;
        int index = this.indexOf(gr | el);
        if (index >= 0) {
            DcmElement elm = (DcmElement)this.list.get(index);
            while (++index < this.list.size()) {
                if (creatorID.equals(elm.getString(this.getSpecificCharacterSet()))) {
                    return gr | el << 8 | tag & 0xFF;
                }
                elm = (DcmElement)this.list.get(index);
                if (elm.tag() == (gr | ++el)) continue;
            }
        }
        if (!create) {
            return 0;
        }
        this.doPut(StringElement.createLO(gr | el, creatorID, this.getSpecificCharacterSet()));
        return gr | el << 8 | tag & 0xFF;
    }

    public DcmElement get(int tag) {
        int index;
        if (Tags.isPrivate(tag)) {
            try {
                tag = this.adjustPrivateTag(tag, false);
            }
            catch (DcmValueException e) {
                log.warn("Could not access Creator ID", e);
                return null;
            }
            if (tag == 0) {
                return null;
            }
        }
        return (index = this.indexOf(tag)) >= 0 ? (DcmElement)this.list.get(index) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DcmElement remove(int tag) {
        if (Tags.isPrivate(tag)) {
            try {
                tag = this.adjustPrivateTag(tag, false);
            }
            catch (DcmValueException e) {
                log.warn("Could not access Creator ID", e);
                return null;
            }
            if (tag == 0) {
                return null;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int index = this.indexOf(tag);
            return index >= 0 ? (DcmElement)this.list.remove(index) : null;
        }
    }

    public ByteBuffer getByteBuffer(int tag) {
        DcmElement e = this.get(tag);
        return e != null ? e.getByteBuffer() : null;
    }

    public String getString(int tag, String defVal) {
        DcmElement el = this.get(tag);
        try {
            return el != null && !el.isEmpty() ? el.getString(this.getSpecificCharacterSet()) : defVal;
        }
        catch (DcmValueException e) {
            return defVal;
        }
    }

    public String getString(int tag) {
        return this.getString(tag, null);
    }

    public String getString(int tag, int index) {
        DcmElement el = this.get(tag);
        try {
            return el != null ? el.getString(index, this.getSpecificCharacterSet()) : null;
        }
        catch (DcmValueException e) {
            return null;
        }
    }

    public String getString(int tag, int index, String defVal) {
        String s = this.getString(tag, index);
        return s != null ? s : defVal;
    }

    public String[] getStrings(int tag) {
        DcmElement el = this.get(tag);
        try {
            return el != null ? el.getStrings(this.getSpecificCharacterSet()) : null;
        }
        catch (DcmValueException e) {
            return null;
        }
    }

    public String getBoundedString(int maxLen, int tag, String defVal) {
        DcmElement el = this.get(tag);
        try {
            return el != null && !el.isEmpty() ? el.getBoundedString(maxLen, this.getSpecificCharacterSet()) : defVal;
        }
        catch (DcmValueException e) {
            return defVal;
        }
    }

    public String getBoundedString(int maxLen, int tag) {
        return this.getBoundedString(maxLen, tag, null);
    }

    public String getBoundedString(int maxLen, int tag, int index) {
        DcmElement el = this.get(tag);
        try {
            return el != null ? el.getBoundedString(index, this.getSpecificCharacterSet()) : null;
        }
        catch (DcmValueException e) {
            return null;
        }
    }

    public String getBoundedString(int maxLen, int tag, int index, String defVal) {
        String s = this.getBoundedString(tag, index);
        return s != null ? s : defVal;
    }

    public String[] getBoundedStrings(int maxLen, int tag) {
        DcmElement el = this.get(tag);
        try {
            return el != null ? el.getBoundedStrings(maxLen, this.getSpecificCharacterSet()) : null;
        }
        catch (DcmValueException e) {
            return null;
        }
    }

    public Integer getInteger(int tag) {
        DcmElement el = this.get(tag);
        try {
            return el != null && !el.isEmpty() ? new Integer(el.getInt()) : null;
        }
        catch (DcmValueException e) {
            return null;
        }
    }

    public Integer getInteger(int tag, int index) {
        DcmElement el = this.get(tag);
        try {
            return el != null && index < el.vm(null) ? new Integer(el.getInt(index)) : null;
        }
        catch (DcmValueException e) {
            return null;
        }
    }

    public PersonName getPersonName(int tag) {
        DcmElement el = this.get(tag);
        try {
            return el != null && !el.isEmpty() ? el.getPersonName(this.getSpecificCharacterSet()) : null;
        }
        catch (DcmValueException e) {
            return null;
        }
    }

    public PersonName[] getPersonNames(int tag) {
        DcmElement el = this.get(tag);
        try {
            return el != null ? el.getPersonNames(this.getSpecificCharacterSet()) : null;
        }
        catch (DcmValueException e) {
            return null;
        }
    }

    public PersonName getPersonName(int tag, int index) {
        PersonName[] pns = this.getPersonNames(tag);
        return pns != null && index < pns.length ? pns[index] : null;
    }

    public int getInt(int tag, int defVal) {
        DcmElement el = this.get(tag);
        try {
            return el != null && !el.isEmpty() ? el.getInt() : defVal;
        }
        catch (DcmValueException e) {
            return defVal;
        }
    }

    public int getInt(int tag, int index, int defVal) {
        DcmElement el = this.get(tag);
        try {
            return el != null && index < el.vm(null) ? el.getInt(index) : defVal;
        }
        catch (DcmValueException e) {
            return defVal;
        }
    }

    public int[] getInts(int tag) {
        DcmElement el = this.get(tag);
        try {
            return el != null ? el.getInts() : null;
        }
        catch (DcmValueException e) {
            return null;
        }
    }

    public int getTag(int tag, int defVal) {
        DcmElement el = this.get(tag);
        try {
            return el != null && !el.isEmpty() ? el.getTag() : defVal;
        }
        catch (DcmValueException e) {
            return defVal;
        }
    }

    public int getTag(int tag, int index, int defVal) {
        DcmElement el = this.get(tag);
        try {
            return el != null && index < el.vm(null) ? el.getTag(index) : defVal;
        }
        catch (DcmValueException e) {
            return defVal;
        }
    }

    public int[] getTags(int tag) {
        DcmElement el = this.get(tag);
        try {
            return el != null ? el.getTags() : null;
        }
        catch (DcmValueException e) {
            return null;
        }
    }

    public Float getFloat(int tag) {
        DcmElement el = this.get(tag);
        try {
            return el != null && !el.isEmpty() ? new Float(el.getFloat()) : null;
        }
        catch (DcmValueException e) {
            return null;
        }
    }

    public Float getFloat(int tag, int index) {
        DcmElement el = this.get(tag);
        try {
            return el != null && index < el.vm(null) ? new Float(el.getFloat(index)) : null;
        }
        catch (DcmValueException e) {
            return null;
        }
    }

    public float getFloat(int tag, float defVal) {
        DcmElement el = this.get(tag);
        try {
            return el != null && !el.isEmpty() ? el.getFloat() : defVal;
        }
        catch (DcmValueException e) {
            return defVal;
        }
    }

    public float getFloat(int tag, int index, float defVal) {
        DcmElement el = this.get(tag);
        try {
            return el != null && index < el.vm(null) ? el.getFloat(index) : defVal;
        }
        catch (DcmValueException e) {
            return defVal;
        }
    }

    public float[] getFloats(int tag) {
        DcmElement el = this.get(tag);
        try {
            return el != null ? el.getFloats() : null;
        }
        catch (DcmValueException e) {
            return null;
        }
    }

    public Double getDouble(int tag) {
        DcmElement el = this.get(tag);
        try {
            return el != null && !el.isEmpty() ? new Double(el.getDouble()) : null;
        }
        catch (DcmValueException e) {
            return null;
        }
    }

    public Double getDouble(int tag, int index) {
        DcmElement el = this.get(tag);
        try {
            return el != null && index < el.vm(null) ? new Double(el.getDouble(index)) : null;
        }
        catch (DcmValueException e) {
            return null;
        }
    }

    public double getDouble(int tag, double defVal) {
        DcmElement el = this.get(tag);
        try {
            return el != null && !el.isEmpty() ? el.getDouble() : defVal;
        }
        catch (DcmValueException e) {
            return defVal;
        }
    }

    public double getDouble(int tag, int index, double defVal) {
        DcmElement el = this.get(tag);
        try {
            return el != null && index < el.vm(null) ? el.getDouble(index) : defVal;
        }
        catch (DcmValueException e) {
            return defVal;
        }
    }

    public double[] getDoubles(int tag) {
        DcmElement el = this.get(tag);
        try {
            return el != null ? el.getDoubles() : null;
        }
        catch (DcmValueException e) {
            return null;
        }
    }

    public Date getDate(int tag) {
        DcmElement el = this.get(tag);
        try {
            return el != null ? el.getDate() : null;
        }
        catch (DcmValueException e) {
            return null;
        }
    }

    public Date getDate(int tag, int index) {
        DcmElement el = this.get(tag);
        try {
            return el != null ? el.getDate(index) : null;
        }
        catch (DcmValueException e) {
            return null;
        }
    }

    public Date[] getDateRange(int tag) {
        DcmElement el = this.get(tag);
        try {
            return el != null && !el.isEmpty() ? el.getDateRange() : null;
        }
        catch (DcmValueException e) {
            return null;
        }
    }

    public Date[] getDates(int tag) {
        DcmElement el = this.get(tag);
        try {
            return el != null ? el.getDates() : null;
        }
        catch (DcmValueException e) {
            return null;
        }
    }

    public Date getDateTime(int dateTag, int timeTag) {
        DcmElement date = this.get(dateTag);
        if (date == null || date.isEmpty()) {
            return null;
        }
        try {
            DcmElement time = this.get(timeTag);
            if (time == null || time.isEmpty()) {
                return date.getDate();
            }
            String dt = date.getString(null) + time.getString(null);
            return new DTFormat().parse(dt);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Date[] getDateTimeRange(int dateTag, int timeTag) {
        DcmElement time = this.get(timeTag);
        if (time == null || time.isEmpty()) {
            return this.getDateRange(dateTag);
        }
        DcmElement date = this.get(dateTag);
        if (date == null || date.isEmpty()) {
            return null;
        }
        try {
            String[] dateRange = DcmObjectImpl.splitRange(date.getString(null));
            String[] timeRange = DcmObjectImpl.splitRange(time.getString(null));
            Date[] result = new Date[2];
            DTFormat f = new DTFormat();
            if (dateRange[0] != null) {
                result[0] = f.parse(dateRange[0] + (timeRange[0] == null ? "" : timeRange[0]));
            }
            if (dateRange[1] != null) {
                result[1] = f.parse(dateRange[1] + (timeRange[1] == null ? "235959.999" : timeRange[1]));
            }
            return result;
        }
        catch (ParseException e) {
            return null;
        }
        catch (DcmValueException e) {
            return null;
        }
    }

    private static String[] splitRange(String range) {
        int hypen = range.indexOf(45);
        String[] result = new String[2];
        if (hypen != 0) {
            String string = result[0] = hypen == -1 ? range : range.substring(0, hypen);
        }
        if (hypen != range.length() - 1) {
            result[1] = hypen == -1 ? range : range.substring(hypen + 1);
        }
        return result;
    }

    public Dataset getItem(int tag) {
        return this.getItem(tag, 0);
    }

    public Dataset getItem(int tag, int index) {
        DcmElement e = this.get(tag);
        return e != null && index < e.countItems() ? e.getItem(index) : null;
    }

    protected DcmElement put(DcmElement newElem) {
        if (log.isDebugEnabled()) {
            log.debug("put " + newElem);
        }
        if ((newElem.tag() & 0xFFFF) == 0) {
            return newElem;
        }
        if (Tags.isPrivate(newElem.tag())) {
            try {
                ((DcmElementImpl)newElem).tag = this.adjustPrivateTag(newElem.tag(), true);
            }
            catch (DcmValueException e) {
                log.warn("Could not access creator ID - ignore " + newElem, e);
                return newElem;
            }
        }
        return this.doPut(newElem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DcmElement doPut(DcmElement newElem) {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int size = this.list.size();
            int newTag = newElem.tag();
            if (size == 0 || ((long)((DcmElementImpl)this.list.get((int)(size - 1))).tag & 0xFFFFFFFFL) < ((long)newTag & 0xFFFFFFFFL)) {
                this.list.add(newElem);
            } else {
                int index = this.indexOf(newTag);
                if (index >= 0) {
                    this.list.set(index, newElem);
                } else {
                    this.list.add(-(index + 1), newElem);
                }
            }
            return newElem;
        }
    }

    public DcmElement putAE(int tag) {
        return this.put(StringElement.createAE(tag));
    }

    public DcmElement putAE(int tag, String value) {
        return this.put(value != null ? StringElement.createAE(tag, value) : StringElement.createAE(tag));
    }

    public DcmElement putAE(int tag, String[] values) {
        return this.put(values != null ? StringElement.createAE(tag, values) : StringElement.createAE(tag));
    }

    public DcmElement putAS(int tag) {
        return this.put(StringElement.createAS(tag));
    }

    public DcmElement putAS(int tag, String value) {
        return this.put(value != null && value.length() != 0 ? StringElement.createAS(tag, value) : StringElement.createAS(tag));
    }

    public DcmElement putAS(int tag, String[] values) {
        return this.put(values != null ? StringElement.createAS(tag, values) : StringElement.createAS(tag));
    }

    public DcmElement putAT(int tag) {
        return this.put(ValueElement.createAT(tag));
    }

    public DcmElement putAT(int tag, int value) {
        return this.put(ValueElement.createAT(tag, value));
    }

    public DcmElement putAT(int tag, int[] values) {
        return this.put(values != null ? ValueElement.createAT(tag, values) : StringElement.createAT(tag));
    }

    public DcmElement putAT(int tag, String value) {
        return value != null && value.length() != 0 ? this.putAT(tag, Integer.parseInt(value, 16)) : this.putAT(tag);
    }

    public DcmElement putAT(int tag, String[] values) {
        if (values == null) {
            return this.putAT(tag);
        }
        int[] a = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            a[i] = Integer.parseInt(values[i], 16);
        }
        return this.putAT(tag, a);
    }

    public DcmElement putCS(int tag) {
        return this.put(StringElement.createCS(tag));
    }

    public DcmElement putCS(int tag, String value) {
        return this.put(value != null ? StringElement.createCS(tag, value) : StringElement.createCS(tag));
    }

    public DcmElement putCS(int tag, String[] values) {
        return this.put(values != null ? StringElement.createCS(tag, values) : StringElement.createCS(tag));
    }

    public DcmElement putDA(int tag) {
        return this.put(StringElement.createDA(tag));
    }

    public DcmElement putDA(int tag, Date value) {
        return this.put(value != null ? StringElement.createDA(tag, value) : StringElement.createDA(tag));
    }

    public DcmElement putDA(int tag, Date[] values) {
        return this.put(values != null ? StringElement.createDA(tag, values) : StringElement.createDA(tag));
    }

    public DcmElement putDA(int tag, Date from, Date to) {
        return this.put(from != null || to != null ? StringElement.createDA(tag, from, to) : StringElement.createDA(tag));
    }

    public DcmElement putDA(int tag, String value) {
        return this.put(value != null && value.length() != 0 ? StringElement.createDA(tag, value) : StringElement.createDA(tag));
    }

    public DcmElement putDA(int tag, String[] values) {
        return this.put(values != null ? StringElement.createDA(tag, values) : StringElement.createDA(tag));
    }

    public DcmElement putDS(int tag) {
        return this.put(StringElement.createDS(tag));
    }

    public DcmElement putDS(int tag, float value) {
        return this.put(StringElement.createDS(tag, value));
    }

    public DcmElement putDS(int tag, float[] values) {
        return this.put(values != null ? StringElement.createDS(tag, values) : StringElement.createDS(tag));
    }

    public DcmElement putDS(int tag, String value) {
        return this.put(value != null || value.length() != 0 ? StringElement.createDS(tag, value) : StringElement.createDS(tag));
    }

    public DcmElement putDS(int tag, String[] values) {
        return this.put(values != null ? StringElement.createDS(tag, values) : StringElement.createDS(tag));
    }

    public DcmElement putDT(int tag) {
        return this.put(StringElement.createDT(tag));
    }

    public DcmElement putDT(int tag, Date value) {
        return this.put(value != null ? StringElement.createDT(tag, value) : StringElement.createDT(tag));
    }

    public DcmElement putDT(int tag, Date[] values) {
        return this.put(values != null ? StringElement.createDT(tag, values) : StringElement.createDT(tag));
    }

    public DcmElement putDT(int tag, Date from, Date to) {
        return this.put(from != null || to != null ? StringElement.createDT(tag, from, to) : StringElement.createDT(tag));
    }

    public DcmElement putDT(int tag, String value) {
        return this.put(value != null && value.length() != 0 ? StringElement.createDT(tag, value) : StringElement.createDT(tag));
    }

    public DcmElement putDT(int tag, String[] values) {
        return this.put(values != null ? StringElement.createDT(tag, values) : StringElement.createDT(tag));
    }

    public DcmElement putFL(int tag) {
        return this.put(ValueElement.createFL(tag));
    }

    public DcmElement putFL(int tag, float value) {
        return this.put(ValueElement.createFL(tag, value));
    }

    public DcmElement putFL(int tag, float[] values) {
        return this.put(values != null ? ValueElement.createFL(tag, values) : ValueElement.createFL(tag));
    }

    public DcmElement putFL(int tag, String value) {
        return this.put(value != null && value.length() != 0 ? ValueElement.createFL(tag, Float.parseFloat(value)) : ValueElement.createFL(tag));
    }

    public DcmElement putFL(int tag, String[] values) {
        return this.put(values != null ? ValueElement.createFL(tag, StringUtils.parseFloats(values)) : ValueElement.createFL(tag));
    }

    public DcmElement putFD(int tag) {
        return this.put(ValueElement.createFD(tag));
    }

    public DcmElement putFD(int tag, double value) {
        return this.put(ValueElement.createFD(tag, value));
    }

    public DcmElement putFD(int tag, double[] values) {
        return this.put(values != null ? ValueElement.createFD(tag, values) : ValueElement.createFD(tag));
    }

    public DcmElement putFD(int tag, String value) {
        return this.put(value != null && value.length() != 0 ? ValueElement.createFD(tag, Double.parseDouble(value)) : ValueElement.createFD(tag));
    }

    public DcmElement putFD(int tag, String[] values) {
        return this.put(values != null ? ValueElement.createFD(tag, StringUtils.parseDoubles(values)) : ValueElement.createFD(tag));
    }

    public DcmElement putIS(int tag) {
        return this.put(StringElement.createIS(tag));
    }

    public DcmElement putIS(int tag, int value) {
        return this.put(StringElement.createIS(tag, value));
    }

    public DcmElement putIS(int tag, int[] values) {
        return this.put(values != null ? StringElement.createIS(tag, values) : StringElement.createIS(tag));
    }

    public DcmElement putIS(int tag, String value) {
        return this.put(value != null && value.length() != 0 ? StringElement.createIS(tag, value) : StringElement.createIS(tag));
    }

    public DcmElement putIS(int tag, String[] values) {
        return this.put(values != null ? StringElement.createIS(tag, values) : StringElement.createIS(tag));
    }

    public DcmElement putLO(int tag) {
        return this.put(StringElement.createLO(tag));
    }

    public DcmElement putLO(int tag, String value) {
        return this.put(value != null ? StringElement.createLO(tag, value, this.getSpecificCharacterSet()) : StringElement.createLO(tag));
    }

    public DcmElement putLO(int tag, String[] values) {
        return this.put(values != null ? StringElement.createLO(tag, values, this.getSpecificCharacterSet()) : StringElement.createLO(tag));
    }

    public DcmElement putLT(int tag) {
        return this.put(StringElement.createLT(tag));
    }

    public DcmElement putLT(int tag, String value) {
        return this.put(value != null ? StringElement.createLT(tag, value, this.getSpecificCharacterSet()) : StringElement.createLT(tag));
    }

    public DcmElement putLT(int tag, String[] values) {
        return this.put(values != null ? StringElement.createLT(tag, values, this.getSpecificCharacterSet()) : StringElement.createLT(tag));
    }

    public DcmElement putOB(int tag) {
        return this.put(ValueElement.createOB(tag));
    }

    public DcmElement putOB(int tag, byte[] value) {
        return this.put(value != null ? ValueElement.createOB(tag, value) : ValueElement.createOB(tag));
    }

    public DcmElement putOB(int tag, ByteBuffer value) {
        return this.put(value != null ? ValueElement.createOB(tag, value) : ValueElement.createOB(tag));
    }

    public DcmElement putOBsq(int tag) {
        return this.put(FragmentElement.createOB(tag));
    }

    public DcmElement putOF(int tag) {
        return this.put(ValueElement.createOF(tag));
    }

    public DcmElement putOF(int tag, float[] value) {
        return this.put(value != null ? ValueElement.createOF(tag, value) : ValueElement.createOF(tag));
    }

    public DcmElement putOF(int tag, ByteBuffer value) {
        return this.put(value != null ? ValueElement.createOF(tag, value) : ValueElement.createOF(tag));
    }

    public DcmElement putOFsq(int tag) {
        return this.put(FragmentElement.createOF(tag));
    }

    public DcmElement putOW(int tag) {
        return this.put(ValueElement.createOW(tag));
    }

    public DcmElement putOW(int tag, short[] value) {
        return this.put(value != null ? ValueElement.createOW(tag, value) : ValueElement.createOW(tag));
    }

    public DcmElement putOW(int tag, ByteBuffer value) {
        return this.put(value != null ? ValueElement.createOW(tag, value) : ValueElement.createOW(tag));
    }

    public DcmElement putOWsq(int tag) {
        return this.put(FragmentElement.createOW(tag));
    }

    public DcmElement putPN(int tag) {
        return this.put(StringElement.createPN(tag));
    }

    public DcmElement putPN(int tag, PersonName value) {
        return this.put(value != null ? StringElement.createPN(tag, value, this.getSpecificCharacterSet()) : StringElement.createPN(tag));
    }

    public DcmElement putPN(int tag, PersonName[] values) {
        return this.put(values != null ? StringElement.createPN(tag, values, this.getSpecificCharacterSet()) : StringElement.createPN(tag));
    }

    public DcmElement putPN(int tag, String value) {
        return this.put(value != null && value.length() != 0 ? StringElement.createPN(tag, new PersonNameImpl(value, false), this.getSpecificCharacterSet()) : StringElement.createPN(tag));
    }

    public DcmElement putPN(int tag, String[] values) {
        if (values == null) {
            return StringElement.createPN(tag);
        }
        PersonName[] a = new PersonName[values.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = new PersonNameImpl(values[i], false);
        }
        return this.put(StringElement.createPN(tag, a, this.getSpecificCharacterSet()));
    }

    public DcmElement putSH(int tag) {
        return this.put(StringElement.createSH(tag));
    }

    public DcmElement putSH(int tag, String value) {
        return this.put(value != null ? StringElement.createSH(tag, value, this.getSpecificCharacterSet()) : StringElement.createSH(tag));
    }

    public DcmElement putSH(int tag, String[] values) {
        return this.put(values != null ? StringElement.createSH(tag, values, this.getSpecificCharacterSet()) : StringElement.createSH(tag));
    }

    public DcmElement putSL(int tag) {
        return this.put(ValueElement.createSL(tag));
    }

    public DcmElement putSL(int tag, int value) {
        return this.put(ValueElement.createSL(tag, value));
    }

    public DcmElement putSL(int tag, int[] values) {
        return this.put(values != null ? ValueElement.createSL(tag, values) : ValueElement.createSL(tag));
    }

    public DcmElement putSL(int tag, String value) {
        return this.put(value != null && value.length() != 0 ? ValueElement.createSL(tag, StringUtils.parseInt(value, Integer.MIN_VALUE, Integer.MAX_VALUE)) : ValueElement.createSL(tag));
    }

    public DcmElement putSL(int tag, String[] values) {
        return this.put(ValueElement.createSL(tag, StringUtils.parseInts(values, Integer.MIN_VALUE, Integer.MAX_VALUE)));
    }

    public DcmElement putSQ(int tag) {
        throw new UnsupportedOperationException();
    }

    public DcmElement putSS(int tag) {
        return this.put(ValueElement.createSS(tag));
    }

    public DcmElement putSS(int tag, int value) {
        return this.put(ValueElement.createSS(tag, value));
    }

    public DcmElement putSS(int tag, int[] values) {
        return this.put(values != null ? ValueElement.createSS(tag, values) : ValueElement.createSS(tag));
    }

    public DcmElement putSS(int tag, String value) {
        return this.put(value != null && value.length() != 0 ? ValueElement.createSS(tag, StringUtils.parseInt(value, -32768L, 32767L)) : ValueElement.createSS(tag));
    }

    public DcmElement putSS(int tag, String[] values) {
        return this.put(values != null ? ValueElement.createSS(tag, StringUtils.parseInts(values, -32768L, 32767L)) : ValueElement.createSS(tag));
    }

    public DcmElement putST(int tag) {
        return this.put(StringElement.createST(tag));
    }

    public DcmElement putST(int tag, String value) {
        return this.put(value != null ? StringElement.createST(tag, value, this.getSpecificCharacterSet()) : StringElement.createST(tag));
    }

    public DcmElement putST(int tag, String[] values) {
        return this.put(values != null ? StringElement.createST(tag, values, this.getSpecificCharacterSet()) : StringElement.createST(tag));
    }

    public DcmElement putTM(int tag) {
        return this.put(StringElement.createTM(tag));
    }

    public DcmElement putTM(int tag, Date value) {
        return this.put(value != null ? StringElement.createTM(tag, value) : StringElement.createTM(tag));
    }

    public DcmElement putTM(int tag, Date[] values) {
        return this.put(values != null ? StringElement.createTM(tag, values) : StringElement.createTM(tag));
    }

    public DcmElement putTM(int tag, Date from, Date to) {
        return this.put(from != null || to != null ? StringElement.createTM(tag, from, to) : StringElement.createTM(tag));
    }

    public DcmElement putTM(int tag, String value) {
        return this.put(value != null && value.length() != 0 ? StringElement.createTM(tag, value) : StringElement.createTM(tag));
    }

    public DcmElement putTM(int tag, String[] values) {
        return this.put(values != null ? StringElement.createTM(tag, values) : StringElement.createTM(tag));
    }

    public DcmElement putUI(int tag) {
        return this.put(StringElement.createUI(tag));
    }

    public DcmElement putUI(int tag, String value) {
        return this.put(value != null ? StringElement.createUI(tag, value) : StringElement.createUI(tag));
    }

    public DcmElement putUI(int tag, String[] values) {
        return this.put(values != null ? StringElement.createUI(tag, values) : StringElement.createUI(tag));
    }

    public DcmElement putUL(int tag) {
        return this.put(ValueElement.createUL(tag));
    }

    public DcmElement putUL(int tag, int value) {
        return this.put(ValueElement.createUL(tag, value));
    }

    public DcmElement putUL(int tag, int[] values) {
        return this.put(values != null ? ValueElement.createUL(tag, values) : StringElement.createUI(tag));
    }

    public DcmElement putUL(int tag, String value) {
        return this.put(value != null && value.length() != 0 ? ValueElement.createUL(tag, StringUtils.parseInt(value, 0L, 0xFFFFFFFFL)) : ValueElement.createUL(tag));
    }

    public DcmElement putUL(int tag, String[] values) {
        return this.put(values != null ? ValueElement.createUL(tag, StringUtils.parseInts(values, 0L, 0xFFFFFFFFL)) : ValueElement.createUL(tag));
    }

    public DcmElement putUN(int tag) {
        return this.put(ValueElement.createUN(tag));
    }

    public DcmElement putUN(int tag, byte[] value) {
        return this.put(value != null ? ValueElement.createUN(tag, value) : ValueElement.createUN(tag));
    }

    public DcmElement putUN(int tag, ByteBuffer value) {
        return this.put(value != null ? ValueElement.createUN(tag, value) : ValueElement.createUN(tag));
    }

    public DcmElement putUNsq(int tag) {
        return this.put(FragmentElement.createUN(tag));
    }

    public DcmElement putUS(int tag) {
        return this.put(ValueElement.createUS(tag));
    }

    public DcmElement putUS(int tag, int value) {
        return this.put(ValueElement.createUS(tag, value));
    }

    public DcmElement putUS(int tag, int[] values) {
        return this.put(values != null ? ValueElement.createUS(tag, values) : ValueElement.createUS(tag));
    }

    public DcmElement putUS(int tag, String value) {
        return this.put(value != null && value.length() != 0 ? ValueElement.createUS(tag, StringUtils.parseInt(value, 0L, 65535L)) : ValueElement.createUS(tag));
    }

    public DcmElement putUS(int tag, String[] values) {
        return this.put(values != null ? ValueElement.createUS(tag, StringUtils.parseInts(values, 0L, 65535L)) : ValueElement.createUS(tag));
    }

    public DcmElement putUT(int tag) {
        return this.put(StringElement.createUT(tag));
    }

    public DcmElement putUT(int tag, String value) {
        return this.put(value != null ? StringElement.createUT(tag, value, this.getSpecificCharacterSet()) : StringElement.createUT(tag));
    }

    public DcmElement putUT(int tag, String[] values) {
        return this.put(values != null ? StringElement.createUT(tag, values, this.getSpecificCharacterSet()) : StringElement.createUT(tag));
    }

    public DcmElement putXX(int tag) {
        return this.putXX(tag, VRMap.DEFAULT.lookup(tag));
    }

    public DcmElement putXX(int tag, ByteBuffer bytes) {
        return this.putXX(tag, VRMap.DEFAULT.lookup(tag), bytes);
    }

    public DcmElement putXX(int tag, String value) {
        return this.putXX(tag, VRMap.DEFAULT.lookup(tag), value);
    }

    public DcmElement putXX(int tag, String[] values) {
        return this.putXX(tag, VRMap.DEFAULT.lookup(tag), values);
    }

    public DcmElement putXXsq(int tag) {
        return this.putXXsq(tag, VRMap.DEFAULT.lookup(tag));
    }

    public DcmElement putXXsq(int tag, int vr) {
        switch (vr) {
            case 20290: {
                return this.putOBsq(tag);
            }
            case 20294: {
                return this.putOFsq(tag);
            }
            case 20311: {
                return this.putOWsq(tag);
            }
            case 21838: {
                return this.putUNsq(tag);
            }
        }
        throw new IllegalArgumentException(Tags.toString(tag) + " " + VRs.toString(vr));
    }

    public DcmElement putXX(int tag, int vr) {
        switch (vr) {
            case 16709: {
                return this.putAE(tag);
            }
            case 16723: {
                return this.putAS(tag);
            }
            case 16724: {
                return this.putAT(tag);
            }
            case 17235: {
                return this.putCS(tag);
            }
            case 17473: {
                return this.putDA(tag);
            }
            case 17491: {
                return this.putDS(tag);
            }
            case 17492: {
                return this.putDT(tag);
            }
            case 17996: {
                return this.putFL(tag);
            }
            case 17988: {
                return this.putFD(tag);
            }
            case 18771: {
                return this.putIS(tag);
            }
            case 19535: {
                return this.putLO(tag);
            }
            case 19540: {
                return this.putLT(tag);
            }
            case 20290: {
                return this.putOB(tag);
            }
            case 20294: {
                return this.putOF(tag);
            }
            case 20311: {
                return this.putOW(tag);
            }
            case 20558: {
                return this.putPN(tag);
            }
            case 21320: {
                return this.putSH(tag);
            }
            case 21324: {
                return this.putSL(tag);
            }
            case 21329: {
                return ((Dataset)((Object)this)).putSQ(tag);
            }
            case 21331: {
                return this.putSS(tag);
            }
            case 21332: {
                return this.putST(tag);
            }
            case 21581: {
                return this.putTM(tag);
            }
            case 21833: {
                return this.putUI(tag);
            }
            case 21838: {
                return this.putUN(tag);
            }
            case 21836: {
                return this.putUL(tag);
            }
            case 21843: {
                return this.putUS(tag);
            }
            case 21844: {
                return this.putUT(tag);
            }
        }
        log.warn(Tags.toString(tag) + " with illegal VR Code: " + Integer.toHexString(vr) + "H");
        return this.putXX(tag, VRMap.DEFAULT.lookup(tag));
    }

    public DcmElement putXX(int tag, int vr, ByteBuffer value) {
        if (value == null) {
            return this.putXX(tag, vr);
        }
        switch (vr) {
            case 16709: {
                return this.put(StringElement.createAE(tag, value));
            }
            case 16723: {
                return this.put(StringElement.createAS(tag, value));
            }
            case 16724: {
                return this.put(ValueElement.createAT(tag, value));
            }
            case 17235: {
                return this.put(StringElement.createCS(tag, value));
            }
            case 17473: {
                return this.put(StringElement.createDA(tag, value));
            }
            case 17491: {
                return this.put(StringElement.createDS(tag, value));
            }
            case 17492: {
                return this.put(StringElement.createDT(tag, value));
            }
            case 17996: {
                return this.put(ValueElement.createFL(tag, value));
            }
            case 17988: {
                return this.put(ValueElement.createFD(tag, value));
            }
            case 18771: {
                return this.put(StringElement.createIS(tag, value));
            }
            case 19535: {
                return this.put(StringElement.createLO(tag, value));
            }
            case 19540: {
                return this.put(StringElement.createLT(tag, value));
            }
            case 20290: {
                return this.put(ValueElement.createOB(tag, value));
            }
            case 20294: {
                return this.put(ValueElement.createOF(tag, value));
            }
            case 20311: {
                return this.put(ValueElement.createOW(tag, value));
            }
            case 20558: {
                return this.put(StringElement.createPN(tag, value));
            }
            case 21320: {
                return this.put(StringElement.createSH(tag, value));
            }
            case 21324: {
                return this.put(ValueElement.createSL(tag, value));
            }
            case 21331: {
                return this.put(ValueElement.createSS(tag, value));
            }
            case 21332: {
                return this.put(StringElement.createST(tag, value));
            }
            case 21581: {
                return this.put(StringElement.createTM(tag, value));
            }
            case 21833: {
                return this.put(StringElement.createUI(tag, value));
            }
            case 21838: {
                return this.put(ValueElement.createUN(tag, value));
            }
            case 21836: {
                return this.put(ValueElement.createUL(tag, value));
            }
            case 21843: {
                return this.put(ValueElement.createUS(tag, value));
            }
            case 21844: {
                return this.put(StringElement.createUT(tag, value));
            }
        }
        log.warn(Tags.toString(tag) + " with illegal VR Code: " + Integer.toHexString(vr) + "H");
        return this.putXX(tag, VRMap.DEFAULT.lookup(tag), value);
    }

    public DcmElement putXX(int tag, int vr, String value) {
        if (value == null) {
            return this.putXX(tag, vr);
        }
        switch (vr) {
            case 16709: {
                return this.putAE(tag, value);
            }
            case 16723: {
                return this.putAS(tag, value);
            }
            case 16724: {
                return this.putAT(tag, value);
            }
            case 17235: {
                return this.putCS(tag, value);
            }
            case 17473: {
                return this.putDA(tag, value);
            }
            case 17491: {
                return this.putDS(tag, value);
            }
            case 17492: {
                return this.putDT(tag, value);
            }
            case 17996: {
                return this.putFL(tag, value);
            }
            case 17988: {
                return this.putFD(tag, value);
            }
            case 18771: {
                return this.putIS(tag, value);
            }
            case 19535: {
                return this.putLO(tag, value);
            }
            case 19540: {
                return this.putLT(tag, value);
            }
            case 20290: 
            case 20294: 
            case 20311: {
                throw new IllegalArgumentException(Tags.toString(tag) + " " + VRs.toString(vr));
            }
            case 20558: {
                return this.putPN(tag, value);
            }
            case 21320: {
                return this.putSH(tag, value);
            }
            case 21324: {
                return this.putSL(tag, value);
            }
            case 21331: {
                return this.putSS(tag, value);
            }
            case 21332: {
                return this.putST(tag, value);
            }
            case 21581: {
                return this.putTM(tag, value);
            }
            case 21833: {
                return this.putUI(tag, value);
            }
            case 21838: {
                throw new IllegalArgumentException(Tags.toString(tag) + " " + VRs.toString(vr));
            }
            case 21836: {
                return this.putUL(tag, value);
            }
            case 21843: {
                return this.putUS(tag, value);
            }
            case 21844: {
                return this.putUT(tag, value);
            }
        }
        log.warn(Tags.toString(tag) + " with illegal VR Code: " + Integer.toHexString(vr) + "H");
        return this.putXX(tag, VRMap.DEFAULT.lookup(tag), value);
    }

    public DcmElement putXX(int tag, int vr, String[] values) {
        if (values == null) {
            return this.putXX(tag, vr);
        }
        switch (vr) {
            case 16709: {
                return this.putAE(tag, values);
            }
            case 16723: {
                return this.putAS(tag, values);
            }
            case 16724: {
                return this.putAT(tag, values);
            }
            case 17235: {
                return this.putCS(tag, values);
            }
            case 17473: {
                return this.putDA(tag, values);
            }
            case 17491: {
                return this.putDS(tag, values);
            }
            case 17492: {
                return this.putDT(tag, values);
            }
            case 17996: {
                return this.putFL(tag, values);
            }
            case 17988: {
                return this.putFD(tag, values);
            }
            case 18771: {
                return this.putIS(tag, values);
            }
            case 19535: {
                return this.putLO(tag, values);
            }
            case 19540: {
                return this.putLT(tag, values);
            }
            case 20290: 
            case 20294: 
            case 20311: {
                throw new IllegalArgumentException(Tags.toString(tag) + " " + VRs.toString(vr));
            }
            case 20558: {
                return this.putPN(tag, values);
            }
            case 21320: {
                return this.putSH(tag, values);
            }
            case 21324: {
                return this.putSL(tag, values);
            }
            case 21331: {
                return this.putSS(tag, values);
            }
            case 21332: {
                return this.putST(tag, values);
            }
            case 21581: {
                return this.putTM(tag, values);
            }
            case 21833: {
                return this.putUI(tag, values);
            }
            case 21838: {
                throw new IllegalArgumentException(Tags.toString(tag) + " " + VRs.toString(vr));
            }
            case 21836: {
                return this.putUL(tag, values);
            }
            case 21843: {
                return this.putUS(tag, values);
            }
            case 21844: {
                return this.putUT(tag, values);
            }
        }
        log.warn(Tags.toString(tag) + " with illegal VR Code: " + Integer.toHexString(vr) + "H");
        return this.putXX(tag, VRMap.DEFAULT.lookup(tag), values);
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public int hashCode() {
        int h = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            h = 31 * h + iter.next().hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DcmObject)) {
            return false;
        }
        DcmObject dcmobj2 = (DcmObject)o;
        Iterator it1 = this.iterator();
        Iterator it2 = dcmobj2.iterator();
        while (it1.hasNext()) {
            if (it2.hasNext() && it1.next().equals(it2.next())) continue;
            return false;
        }
        return !it2.hasNext();
    }

    public void putAll(DcmObject dcmObj) {
        this.putAll(dcmObj, 0);
    }

    public void putAll(DcmObject dcmObj, int itemTreatment) {
        Iterator it = dcmObj.iterator();
        block4: while (it.hasNext()) {
            DcmElement el = (DcmElement)it.next();
            if (el.isEmpty()) {
                this.putXX(el.tag(), el.vr());
                continue;
            }
            switch (el.vr()) {
                case 21329: {
                    int i;
                    DcmElement sq;
                    DcmElement dcmElement = sq = itemTreatment != 0 ? this.get(el.tag()) : null;
                    if (sq == null || sq.vr() != 21329) {
                        sq = this.putSQ(el.tag());
                    }
                    int n = el.countItems();
                    for (i = 0; i < n; ++i) {
                        Dataset item;
                        Dataset dataset = item = itemTreatment == 2 ? sq.getItem(i) : null;
                        if (item == null) {
                            item = sq.addNewItem();
                        }
                        item.putAll(el.getItem(i), itemTreatment);
                    }
                    continue block4;
                }
                case 20290: 
                case 20294: 
                case 20311: 
                case 21838: {
                    int i;
                    int n;
                    DcmElement sq;
                    if (el.hasDataFragments()) {
                        sq = this.putXXsq(el.tag(), el.vr());
                        n = el.countItems();
                        for (i = 0; i < n; ++i) {
                            sq.addDataFragment(el.getDataFragment(i));
                        }
                        continue block4;
                    }
                }
                default: {
                    this.putXX(el.tag(), el.vr(), el.getByteBuffer());
                }
            }
        }
    }

    protected void write(int grTag, int grLen, DcmHandler handler) throws IOException {
        byte[] b4 = new byte[]{(byte)grLen, (byte)(grLen >>> 8), (byte)(grLen >>> 16), (byte)(grLen >>> 24)};
        long el1Pos = ((DcmElement)this.list.get(0)).getStreamPosition();
        handler.startElement(grTag, 21836, el1Pos == -1L ? -1L : el1Pos - 12L);
        handler.value(b4, 0, 4);
        handler.endElement();
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            DcmElement el = (DcmElement)this.list.get(i);
            int len = el.length();
            handler.startElement(el.tag(), el.vr(), el.getStreamPosition());
            ByteBuffer bb = el.getByteBuffer(ByteOrder.LITTLE_ENDIAN);
            handler.value(bb.array(), bb.arrayOffset(), bb.limit());
            handler.endElement();
        }
    }

    public void writeHeader(ImageOutputStream out, DcmEncodeParam encParam, int tag, int vr, int len) throws IOException {
        if (encParam.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            out.write(tag >> 16);
            out.write(tag >> 24);
            out.write(tag >> 0);
            out.write(tag >> 8);
        } else {
            out.write(tag >> 24);
            out.write(tag >> 16);
            out.write(tag >> 8);
            out.write(tag >> 0);
        }
        if (vr != 0 && encParam.explicitVR) {
            out.write(vr >> 8);
            out.write(vr >> 0);
            if (VRs.isLengthField16Bit(vr)) {
                if (encParam.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    out.write(len >> 0);
                    out.write(len >> 8);
                } else {
                    out.write(len >> 8);
                    out.write(len >> 0);
                }
                return;
            }
            out.write(0);
            out.write(0);
        }
        if (encParam.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            out.write(len >> 0);
            out.write(len >> 8);
            out.write(len >> 16);
            out.write(len >> 24);
        } else {
            out.write(len >> 24);
            out.write(len >> 16);
            out.write(len >> 8);
            out.write(len >> 0);
        }
    }

    public void writeHeader(OutputStream out, DcmEncodeParam encParam, int tag, int vr, int len) throws IOException {
        if (encParam.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            out.write(tag >> 16);
            out.write(tag >> 24);
            out.write(tag >> 0);
            out.write(tag >> 8);
        } else {
            out.write(tag >> 24);
            out.write(tag >> 16);
            out.write(tag >> 8);
            out.write(tag >> 0);
        }
        if (vr != 0 && encParam.explicitVR) {
            out.write(vr >> 8);
            out.write(vr >> 0);
            if (VRs.isLengthField16Bit(vr)) {
                if (encParam.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    out.write(len >> 0);
                    out.write(len >> 8);
                } else {
                    out.write(len >> 8);
                    out.write(len >> 0);
                }
                return;
            }
            out.write(0);
            out.write(0);
        }
        if (encParam.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            out.write(len >> 0);
            out.write(len >> 8);
            out.write(len >> 16);
            out.write(len >> 24);
        } else {
            out.write(len >> 24);
            out.write(len >> 16);
            out.write(len >> 8);
            out.write(len >> 0);
        }
    }
}

