/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.data.PersonName;
import org.dcm4che.data.SpecificCharacterSet;
import org.dcm4che.util.DAFormat;
import org.dcm4che.util.DTFormat;
import org.dcm4che.util.TMFormat;
import org.dcm4cheri.data.PersonNameImpl;
import org.dcm4cheri.data.ValueElement;
import org.dcm4cheri.util.StringUtils;

abstract class StringElement
extends ValueElement {
    private static final String[] STRING0 = new String[0];
    private static final long MS_PER_DAY = 86400000L;
    static Logger log = Logger.getLogger(StringElement.class);
    private static final Trim NO_TRIM = new Trim(){

        public String trim(String s) {
            return s;
        }
    };
    private static final Trim TRAIL_TRIM = new Trim(){

        public String trim(String s) {
            for (int r = s.length(); r > 0; --r) {
                char ch = s.charAt(r - 1);
                if (ch == '\u0000' || ch == ' ') continue;
                return s.substring(0, r);
            }
            return "";
        }
    };
    private static final Trim PN_TRIM = new Trim(){

        public String trim(String s) {
            for (int r = s.length(); r > 0; --r) {
                char ch = s.charAt(r - 1);
                if (ch == '^' || ch == ' ' || ch == '\u0000') continue;
                return s.substring(0, r);
            }
            return "";
        }
    };
    private static final Trim TOT_TRIM = new Trim(){

        public String trim(String s) {
            for (int r = s.length(); r > 0; --r) {
                char ch = s.charAt(r - 1);
                if (ch == ' ' || ch == '\u0000') continue;
                for (int l = 0; l < r; ++l) {
                    if (s.charAt(l) == ' ') continue;
                    return s.substring(l, r);
                }
            }
            return "";
        }
    };
    private static final Check NO_CHECK = new Check(){

        public String check(String s) {
            return s;
        }
    };
    protected final Trim trim;
    private static final Check LT_CHECK = new CheckImpl(10240, true);
    private static final Check ST_CHECK = new CheckImpl(1024, true);
    static final Check UT_CHECK = new CheckImpl(Integer.MAX_VALUE, true);
    private static final byte DELIM = 92;
    private static final Check LO_CHECK = new CheckImpl(64, false);
    private static final Check SH_CHECK = new CheckImpl(16, false);
    private static final Check AE_CHECK = new CheckImpl(16, false);
    private static final Check AS_CHECK = new Check(){

        public String check(String s) {
            if (s.length() == 4 && Character.isDigit(s.charAt(0)) && Character.isDigit(s.charAt(1)) && Character.isDigit(s.charAt(2))) {
                switch (s.charAt(3)) {
                    case 'D': 
                    case 'M': 
                    case 'W': 
                    case 'Y': {
                        return s;
                    }
                }
            }
            log.warn("Illegal Age String: " + s);
            return s;
        }
    };
    static final Check CS_CHECK = new CheckImpl(16, false){

        protected boolean check(char c) {
            return c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == ' ' || c == '_';
        }
    };
    static final Check DS_CHECK = new Check(){

        public String check(String s) {
            try {
                Float.parseFloat(s);
                if (s.length() > 16) {
                    log.warn("DS Value: " + s + " exeeds DS length limit: 16");
                }
            }
            catch (NumberFormatException e) {
                log.warn("Illegal DS Value: " + s);
            }
            return s;
        }
    };
    static final Check IS_CHECK = new Check(){

        public String check(String s) {
            try {
                Integer.parseInt(s);
                if (s.length() > 12) {
                    log.warn("IS Value: " + s + " exeeds IS length limit: 12");
                }
            }
            catch (NumberFormatException e) {
                log.warn("Illegal IS Value: " + s);
            }
            return s;
        }
    };
    private static final int UID_DIGIT1 = 0;
    private static final int UID_DIGIT = 1;
    private static final int UID_DOT = 2;
    private static final int UID_ERROR = -1;
    private static final Check UI_CHECK = new CheckImpl(64, false){

        public String check(String s) {
            char[] a = s.toCharArray();
            if (a.length > this.maxLen) {
                log.warn("Value: " + s + " exeeds VR length limit: " + this.maxLen);
            }
            int state = 0;
            for (int i = 0; i < a.length; ++i) {
                if ((state = StringElement.nextState(state, a[i])) != -1) continue;
                log.warn("Illegal UID value: " + s);
                return s;
            }
            if (state == 0) {
                log.warn("Illegal UID value: " + s);
            }
            return s;
        }
    };
    private static final byte HYPHEN = 45;

    private static boolean isDICOMControl(char c) {
        switch (c) {
            case '\n': 
            case '\f': 
            case '\r': 
            case '\u001b': {
                return true;
            }
        }
        return false;
    }

    private static ByteBuffer toByteBuffer(String value, Trim trim, Check check, SpecificCharacterSet cs) {
        if (value == null || (value = trim.trim(value)).length() == 0) {
            return EMPTY_VALUE;
        }
        check.check(value);
        return ByteBuffer.wrap(cs == null ? value.getBytes() : cs.encode(value));
    }

    private static ByteBuffer toByteBuffer(String[] values, Trim trim, Check check, SpecificCharacterSet cs) {
        if (values.length == 0) {
            return EMPTY_VALUE;
        }
        if (values.length == 1) {
            return StringElement.toByteBuffer(values[0], trim, check, cs);
        }
        String[] ss = new String[values.length];
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = check.check(trim.trim(values[i]));
        }
        String s = StringUtils.toString(ss, '\\');
        return ByteBuffer.wrap(cs == null ? s.getBytes() : cs.encode(s));
    }

    StringElement(int tag, ByteBuffer data, Trim trim) {
        super(tag, data);
        this.trim = trim;
    }

    public String getString(int index, SpecificCharacterSet cs) throws DcmValueException {
        ByteBuffer bb = this.getByteBuffer();
        if (bb == null) {
            return null;
        }
        byte[] b = bb.array();
        return this.trim.trim(cs == null ? new String(b) : cs.decode(b));
    }

    public String[] getStrings(SpecificCharacterSet cs) throws DcmValueException {
        String[] stringArray;
        String s = this.getString(0, cs);
        if (s == null) {
            stringArray = STRING0;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = s;
        }
        return stringArray;
    }

    private static boolean isUniversalMatch(String p) {
        if (p == null) {
            return true;
        }
        int n = p.length();
        for (int i = 0; i < n; ++i) {
            if (p.charAt(i) == '*') continue;
            return false;
        }
        return true;
    }

    protected boolean matchValue(DcmElement key, boolean ignorePNCase, boolean ignoreEmpty, SpecificCharacterSet keyCS, SpecificCharacterSet dsCS) {
        String[] patterns;
        String[] values;
        if (this.isEmpty()) {
            return true;
        }
        try {
            values = this.getStrings(dsCS);
        }
        catch (DcmValueException e) {
            return true;
        }
        try {
            patterns = key.getStrings(keyCS);
        }
        catch (DcmValueException e) {
            throw new IllegalArgumentException("key: " + key);
        }
        for (int i = 0; i < patterns.length; ++i) {
            if (StringElement.isUniversalMatch(patterns[i])) {
                return true;
            }
            for (int j = 0; j < values.length; ++j) {
                if (!(ignorePNCase && this.vr() == 20558 ? StringElement.match(patterns[i].toUpperCase(), values[j].toUpperCase()) : StringElement.match(patterns[i], values[j]))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean match(String pattern, String input) {
        if (pattern.indexOf(42) == -1 && pattern.indexOf(63) == -1) {
            return pattern.equals(input);
        }
        return Pattern.matches(StringElement.toRegEx(pattern), input);
    }

    private static String toRegEx(String pattern) {
        char[] a = pattern.toCharArray();
        StringBuffer sb = new StringBuffer(a.length + 10);
        boolean inQuote = false;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == '*' || a[i] == '?') {
                if (inQuote) {
                    sb.append('\\').append('E');
                    inQuote = false;
                }
                sb.append('.');
                if (a[i] != '*') continue;
                sb.append('*');
                continue;
            }
            if (!inQuote) {
                sb.append('\\').append('Q');
                inQuote = true;
            }
            sb.append(a[i]);
        }
        if (inQuote) {
            sb.append('\\').append('E');
        }
        return sb.toString();
    }

    static DcmElement createLT(int tag, ByteBuffer data) {
        return new LT(tag, data);
    }

    static DcmElement createLT(int tag) {
        return new LT(tag, EMPTY_VALUE);
    }

    static DcmElement createLT(int tag, String value, SpecificCharacterSet cs) {
        return new LT(tag, StringElement.toByteBuffer(value, TRAIL_TRIM, LT_CHECK, cs));
    }

    static DcmElement createLT(int tag, String[] values, SpecificCharacterSet cs) {
        return new LT(tag, StringElement.toByteBuffer(values, TRAIL_TRIM, LT_CHECK, cs));
    }

    static DcmElement createST(int tag, ByteBuffer data) {
        return new ST(tag, data);
    }

    static DcmElement createST(int tag) {
        return new ST(tag, EMPTY_VALUE);
    }

    static DcmElement createST(int tag, String value, SpecificCharacterSet cs) {
        return new ST(tag, StringElement.toByteBuffer(value, TRAIL_TRIM, ST_CHECK, cs));
    }

    static DcmElement createST(int tag, String[] values, SpecificCharacterSet cs) {
        return new ST(tag, StringElement.toByteBuffer(values, TRAIL_TRIM, ST_CHECK, cs));
    }

    static DcmElement createUT(int tag, ByteBuffer data) {
        return new UT(tag, data);
    }

    static DcmElement createUT(int tag) {
        return new UT(tag, EMPTY_VALUE);
    }

    static DcmElement createUT(int tag, String value, SpecificCharacterSet cs) {
        return new UT(tag, StringElement.toByteBuffer(value, TRAIL_TRIM, UT_CHECK, cs));
    }

    static DcmElement createUT(int tag, String[] values, SpecificCharacterSet cs) {
        return new UT(tag, StringElement.toByteBuffer(values, TRAIL_TRIM, UT_CHECK, cs));
    }

    static DcmElement createLO(int tag, ByteBuffer data) {
        return new LO(tag, data);
    }

    static DcmElement createLO(int tag) {
        return new LO(tag, EMPTY_VALUE);
    }

    static DcmElement createLO(int tag, String value, SpecificCharacterSet cs) {
        return new LO(tag, StringElement.toByteBuffer(value, TOT_TRIM, LO_CHECK, cs));
    }

    static DcmElement createLO(int tag, String[] values, SpecificCharacterSet cs) {
        return new LO(tag, StringElement.toByteBuffer(values, TOT_TRIM, LO_CHECK, cs));
    }

    static DcmElement createPN(int tag, ByteBuffer data) {
        return new PN(tag, data);
    }

    static DcmElement createPN(int tag) {
        return new PN(tag, EMPTY_VALUE);
    }

    static DcmElement createPN(int tag, PersonName value, SpecificCharacterSet cs) {
        return new PN(tag, StringElement.toByteBuffer(((Object)value).toString(), NO_TRIM, NO_CHECK, cs));
    }

    static DcmElement createPN(int tag, PersonName[] values, SpecificCharacterSet cs) {
        String[] tmp = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            tmp[i] = ((Object)values[i]).toString();
        }
        return new PN(tag, StringElement.toByteBuffer(tmp, NO_TRIM, NO_CHECK, cs));
    }

    static DcmElement createSH(int tag, ByteBuffer data) {
        return new SH(tag, data);
    }

    static DcmElement createSH(int tag) {
        return new SH(tag, EMPTY_VALUE);
    }

    static DcmElement createSH(int tag, String value, SpecificCharacterSet cs) {
        return new SH(tag, StringElement.toByteBuffer(value, TOT_TRIM, SH_CHECK, cs));
    }

    static DcmElement createSH(int tag, String[] values, SpecificCharacterSet cs) {
        return new SH(tag, StringElement.toByteBuffer(values, TOT_TRIM, SH_CHECK, cs));
    }

    static DcmElement createAE(int tag, ByteBuffer data) {
        return new AE(tag, data);
    }

    static DcmElement createAE(int tag) {
        return new AE(tag, EMPTY_VALUE);
    }

    static DcmElement createAE(int tag, String value) {
        return new AE(tag, StringElement.toByteBuffer(value, TOT_TRIM, AE_CHECK, null));
    }

    static DcmElement createAE(int tag, String[] values) {
        return new AE(tag, StringElement.toByteBuffer(values, TOT_TRIM, AE_CHECK, null));
    }

    static DcmElement createAS(int tag, ByteBuffer data) {
        return new AS(tag, data);
    }

    static DcmElement createAS(int tag) {
        return new AS(tag, EMPTY_VALUE);
    }

    static DcmElement createAS(int tag, String value) {
        return new AS(tag, StringElement.toByteBuffer(value, NO_TRIM, AS_CHECK, null));
    }

    static DcmElement createAS(int tag, String[] values) {
        return new AS(tag, StringElement.toByteBuffer(values, NO_TRIM, AS_CHECK, null));
    }

    static DcmElement createCS(int tag, ByteBuffer data) {
        return new CS(tag, data);
    }

    static DcmElement createCS(int tag) {
        return new CS(tag, EMPTY_VALUE);
    }

    static DcmElement createCS(int tag, String v) {
        return new CS(tag, StringElement.toByteBuffer(v, TOT_TRIM, CS_CHECK, null));
    }

    static DcmElement createCS(int tag, String[] a) {
        return new CS(tag, StringElement.toByteBuffer(a, TOT_TRIM, CS_CHECK, null));
    }

    static DcmElement createDS(int tag, ByteBuffer data) {
        return new DS(tag, data);
    }

    static DcmElement createDS(int tag) {
        return new DS(tag, EMPTY_VALUE);
    }

    static DcmElement createDS(int tag, float value) {
        return new DS(tag, StringElement.toByteBuffer(String.valueOf(value), NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createDS(int tag, float[] values) {
        String[] tmp = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            tmp[i] = String.valueOf(values[i]);
        }
        return new DS(tag, StringElement.toByteBuffer(tmp, NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createDS(int tag, String v) {
        return new DS(tag, StringElement.toByteBuffer(v, TOT_TRIM, DS_CHECK, null));
    }

    static DcmElement createDS(int tag, String[] a) {
        return new DS(tag, StringElement.toByteBuffer(a, TOT_TRIM, DS_CHECK, null));
    }

    static DcmElement createIS(int tag, ByteBuffer data) {
        return new IS(tag, data);
    }

    static DcmElement createIS(int tag) {
        return new IS(tag, EMPTY_VALUE);
    }

    static DcmElement createIS(int tag, int value) {
        return new IS(tag, StringElement.toByteBuffer(String.valueOf(value), NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createIS(int tag, int[] values) {
        String[] tmp = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            tmp[i] = String.valueOf(values[i]);
        }
        return new IS(tag, StringElement.toByteBuffer(tmp, NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createIS(int tag, String v) {
        return new IS(tag, StringElement.toByteBuffer(v, TOT_TRIM, IS_CHECK, null));
    }

    static DcmElement createIS(int tag, String[] a) {
        return new IS(tag, StringElement.toByteBuffer(a, TOT_TRIM, IS_CHECK, null));
    }

    private static int nextState(int state, char c) {
        switch (state) {
            case 0: {
                if (c > '0' && c <= '9') {
                    return 1;
                }
                if (c == '0') {
                    return 2;
                }
                return -1;
            }
            case 1: {
                if (c >= '0' && c <= '9') {
                    return 1;
                }
            }
            case 2: {
                if (c != '.') break;
                return 0;
            }
        }
        return -1;
    }

    static DcmElement createUI(int tag, ByteBuffer data) {
        return new UI(tag, data);
    }

    static DcmElement createUI(int tag) {
        return new UI(tag, EMPTY_VALUE);
    }

    static DcmElement createUI(int tag, String value) {
        return new UI(tag, StringElement.toByteBuffer(value, NO_TRIM, UI_CHECK, null));
    }

    static DcmElement createUI(int tag, String[] values) {
        return new UI(tag, StringElement.toByteBuffer(values, NO_TRIM, UI_CHECK, null));
    }

    private static Date toDate(DateFormat f, String s) {
        try {
            return s != null ? f.parse(s) : null;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(s);
        }
    }

    private static Date[] toDateRange(DateFormat f, String s, long resolution) {
        if (s == null) {
            return null;
        }
        Date[] range = new Date[2];
        int delim = s.indexOf(45);
        try {
            if (delim == -1) {
                range[0] = f.parse(s);
                range[1] = new Date(range[0].getTime() + resolution - 1L);
            } else {
                if (delim > 0) {
                    range[0] = f.parse(s.substring(0, delim));
                }
                if (delim + 1 < s.length()) {
                    range[1] = new Date(f.parse(s.substring(delim + 1)).getTime() + resolution - 1L);
                }
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(s);
        }
        return range;
    }

    static DcmElement createDA(int tag, ByteBuffer data) {
        return new DA(tag, data);
    }

    static DcmElement createDA(int tag) {
        return new DA(tag, EMPTY_VALUE);
    }

    private static String toString(DateFormat f, Date d) {
        return d == null ? null : f.format(d);
    }

    private static String toString(DateFormat f, Date from, Date to) {
        StringBuffer sb = new StringBuffer(64);
        if (from != null) {
            sb.append(f.format(from));
        }
        sb.append('-');
        if (to != null) {
            sb.append(f.format(to));
        }
        return sb.toString();
    }

    static DcmElement createDA(int tag, Date value) {
        return new DA(tag, StringElement.toByteBuffer(StringElement.toString(new DAFormat(), value), NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createDA(int tag, Date[] values) {
        DAFormat f = new DAFormat();
        String[] tmp = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            tmp[i] = StringElement.toString(f, values[i]);
        }
        return new DA(tag, StringElement.toByteBuffer(tmp, NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createDA(int tag, Date from, Date to) {
        return new DA(tag, StringElement.toByteBuffer(StringElement.toString(new DAFormat(), from, to), NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createDA(int tag, String value) {
        DAFormat f = new DAFormat();
        if (value.indexOf(45) != -1) {
            StringElement.toDateRange(f, value, 86400000L);
        } else {
            StringElement.toDate(f, value);
        }
        return new DA(tag, StringElement.toByteBuffer(value, NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createDA(int tag, String[] values) {
        DAFormat f = new DAFormat();
        for (int i = 0; i < values.length; ++i) {
            StringElement.toDate(f, values[i]);
        }
        return new DA(tag, StringElement.toByteBuffer(values, NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createDT(int tag, ByteBuffer data) {
        return new DT(tag, data);
    }

    static DcmElement createDT(int tag) {
        return new DT(tag, EMPTY_VALUE);
    }

    static DcmElement createDT(int tag, Date value) {
        return new DT(tag, StringElement.toByteBuffer(StringElement.toString(new DTFormat(), value), NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createDT(int tag, Date[] values) {
        DTFormat f = new DTFormat();
        String[] tmp = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            tmp[i] = StringElement.toString(f, values[i]);
        }
        return new DT(tag, StringElement.toByteBuffer(tmp, NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createDT(int tag, Date from, Date to) {
        return new DT(tag, StringElement.toByteBuffer(StringElement.toString(new DTFormat(), from, to), NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createDT(int tag, String value) {
        DTFormat f = new DTFormat();
        if (value.indexOf(45) != -1) {
            StringElement.toDateRange(f, value, 0L);
        } else {
            StringElement.toDate(f, value);
        }
        return new DT(tag, StringElement.toByteBuffer(value, NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createDT(int tag, String[] values) {
        DTFormat f = new DTFormat();
        for (int i = 0; i < values.length; ++i) {
            StringElement.toDate(f, values[i]);
        }
        return new DT(tag, StringElement.toByteBuffer(values, NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createTM(int tag, ByteBuffer data) {
        return new TM(tag, data);
    }

    static DcmElement createTM(int tag) {
        return new TM(tag, EMPTY_VALUE);
    }

    static DcmElement createTM(int tag, Date value) {
        return new TM(tag, StringElement.toByteBuffer(StringElement.toString(new TMFormat(), value), NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createTM(int tag, Date[] values) {
        TMFormat f = new TMFormat();
        String[] tmp = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            tmp[i] = StringElement.toString(f, values[i]);
        }
        return new TM(tag, StringElement.toByteBuffer(tmp, NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createTM(int tag, Date from, Date to) {
        return new TM(tag, StringElement.toByteBuffer(StringElement.toString(new TMFormat(), from, to), NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createTM(int tag, String value) {
        TMFormat f = new TMFormat();
        if (value.indexOf(45) != -1) {
            StringElement.toDateRange(f, value, 0L);
        } else {
            StringElement.toDate(f, value);
        }
        return new TM(tag, StringElement.toByteBuffer(value, NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createTM(int tag, String[] values) {
        TMFormat f = new TMFormat();
        for (int i = 0; i < values.length; ++i) {
            StringElement.toDate(f, values[i]);
        }
        return new TM(tag, StringElement.toByteBuffer(values, NO_TRIM, NO_CHECK, null));
    }

    private static final class TM
    extends DateString {
        TM(int tag, ByteBuffer data) {
            super(tag, data, TRAIL_TRIM);
        }

        public final int vr() {
            return 21581;
        }

        protected DateFormat getFormat() {
            return new TMFormat();
        }
    }

    private static final class DT
    extends DateString {
        DT(int tag, ByteBuffer data) {
            super(tag, data, TRAIL_TRIM);
        }

        public final int vr() {
            return 17492;
        }

        protected DateFormat getFormat() {
            return new DTFormat();
        }
    }

    private static final class DA
    extends DateString {
        DA(int tag, ByteBuffer data) {
            super(tag, data, TRAIL_TRIM);
        }

        public final int vr() {
            return 17473;
        }

        protected DateFormat getFormat() {
            return new DAFormat();
        }

        protected long getTimeResolution() {
            return 86400000L;
        }
    }

    private static abstract class DateString
    extends AsciiMultiStringElement {
        DateString(int tag, ByteBuffer data, Trim trim) {
            super(tag, data, trim);
        }

        public final boolean isDataRange() {
            int n = this.data.limit();
            for (int i = 0; i < n; ++i) {
                if (this.data.get(i) != 45) continue;
                return true;
            }
            return false;
        }

        public final Date getDate() throws DcmValueException {
            return StringElement.toDate(this.getFormat(), super.getString(null));
        }

        public final Date getDate(int index) throws DcmValueException {
            return StringElement.toDate(this.getFormat(), super.getString(index, null));
        }

        public final Date[] getDateRange() throws DcmValueException {
            return StringElement.toDateRange(this.getFormat(), super.getString(null), this.getTimeResolution());
        }

        public final Date[] getDates() throws DcmValueException {
            DateFormat f = this.getFormat();
            String[] ss = super.getStrings(null);
            Date[] a = new Date[ss.length];
            for (int i = 0; i < a.length; ++i) {
                a[i] = StringElement.toDate(f, ss[i]);
            }
            return a;
        }

        protected boolean matchValue(DcmElement key, boolean ignorePNCase, boolean ignoreEmpty, SpecificCharacterSet keyCS, SpecificCharacterSet dsCS) {
            String[] keys;
            try {
                keys = key.getStrings(null);
            }
            catch (DcmValueException e) {
                throw new IllegalArgumentException("key: " + key);
            }
            for (int i = 0; i < keys.length; ++i) {
                Date[] range = StringElement.toDateRange(this.getFormat(), keys[i], this.getTimeResolution());
                long from = range[0] != null ? range[0].getTime() : Long.MIN_VALUE;
                long to = range[1] != null ? range[1].getTime() : Long.MAX_VALUE;
                try {
                    Date[] values = this.getDates();
                    for (int j = 0; j < values.length; ++j) {
                        if (values[i] == null) {
                            return true;
                        }
                        long time = values[i].getTime();
                        if (time < from || time > to) continue;
                        return true;
                    }
                    continue;
                }
                catch (DcmValueException e) {
                    return true;
                }
            }
            return false;
        }

        protected abstract DateFormat getFormat();

        protected long getTimeResolution() {
            return 1L;
        }
    }

    private static final class UI
    extends AsciiMultiStringElement {
        UI(int tag, ByteBuffer data) {
            super(tag, data, TRAIL_TRIM);
        }

        public final int vr() {
            return 21833;
        }
    }

    private static final class IS
    extends AsciiMultiStringElement {
        IS(int tag, ByteBuffer data) {
            super(tag, data, TOT_TRIM);
        }

        public final int vr() {
            return 18771;
        }

        public final int getInt(int index) throws DcmValueException {
            String s = super.getString(index, null);
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException ex) {
                throw new DcmValueException(s, ex);
            }
        }

        public final int[] getInts() throws DcmValueException {
            String[] ss = super.getStrings(null);
            int[] retval = new int[ss.length];
            for (int i = 0; i < retval.length; ++i) {
                retval[i] = Integer.parseInt(ss[i]);
            }
            return retval;
        }
    }

    private static final class DS
    extends AsciiMultiStringElement {
        DS(int tag, ByteBuffer data) {
            super(tag, data, TOT_TRIM);
        }

        public final int vr() {
            return 17491;
        }

        public final float getFloat(int index) throws DcmValueException {
            return Float.parseFloat(super.getString(index, null));
        }

        public final float[] getFloats() throws DcmValueException {
            String[] ss = super.getStrings(null);
            float[] retval = new float[ss.length];
            for (int i = 0; i < retval.length; ++i) {
                retval[i] = Float.parseFloat(ss[i]);
            }
            return retval;
        }
    }

    private static final class CS
    extends AsciiMultiStringElement {
        CS(int tag, ByteBuffer data) {
            super(tag, data, TOT_TRIM);
        }

        public final int vr() {
            return 17235;
        }
    }

    private static final class AS
    extends AsciiMultiStringElement {
        AS(int tag, ByteBuffer data) {
            super(tag, data, NO_TRIM);
        }

        public final int vr() {
            return 16723;
        }
    }

    private static final class AE
    extends AsciiMultiStringElement {
        AE(int tag, ByteBuffer data) {
            super(tag, data, TOT_TRIM);
        }

        public final int vr() {
            return 16709;
        }
    }

    private static abstract class AsciiMultiStringElement
    extends MultiStringElement {
        AsciiMultiStringElement(int tag, ByteBuffer data, Trim trim) {
            super(tag, data, trim);
        }

        public final String getString(int index, SpecificCharacterSet cs) throws DcmValueException {
            return super.getString(index, null);
        }
    }

    private static final class SH
    extends MultiStringElement {
        SH(int tag, ByteBuffer data) {
            super(tag, data, TOT_TRIM);
        }

        public final int vr() {
            return 21320;
        }
    }

    private static final class PN
    extends MultiStringElement {
        PN(int tag, ByteBuffer data) {
            super(tag, data, PN_TRIM);
        }

        public final int vr() {
            return 20558;
        }

        public final PersonName getPersonName(SpecificCharacterSet cs) throws DcmValueException {
            return new PersonNameImpl(this.getString(cs), true);
        }

        public final PersonName getPersonName(int index, SpecificCharacterSet cs) throws DcmValueException {
            return new PersonNameImpl(this.getString(index, cs), true);
        }

        public final PersonName[] getPersonNames(SpecificCharacterSet cs) throws DcmValueException {
            String[] ss = this.getStrings(cs);
            PersonName[] pns = new PersonName[ss.length];
            for (int i = 0; i < ss.length; ++i) {
                pns[i] = new PersonNameImpl(ss[i], true);
            }
            return pns;
        }
    }

    private static final class LO
    extends MultiStringElement {
        LO(int tag, ByteBuffer data) {
            super(tag, data, TOT_TRIM);
        }

        public final int vr() {
            return 19535;
        }
    }

    private static abstract class MultiStringElement
    extends StringElement {
        MultiStringElement(int tag, ByteBuffer data, Trim trim) {
            super(tag, data, trim);
        }

        public final int vm(SpecificCharacterSet cs) {
            if (this.data.limit() == 0) {
                return 0;
            }
            if (cs == null) {
                int vm = 1;
                byte[] a = this.data.array();
                for (int i = 0; i < a.length; ++i) {
                    if (a[i] != 92) continue;
                    ++vm;
                }
                return vm;
            }
            return StringUtils.count(cs.decode(this.data.array()), '\\') + 1;
        }

        public String getString(SpecificCharacterSet cs) throws DcmValueException {
            if (this.isEmpty()) {
                return null;
            }
            byte[] b = this.data.array();
            String s = this.trim.trim(cs == null ? new String(b) : cs.decode(b));
            int end = s.indexOf(92);
            return end != -1 ? s.substring(0, end) : s;
        }

        public String getString(int index, SpecificCharacterSet cs) throws DcmValueException {
            if (index == 0) {
                return this.getString(cs);
            }
            String[] ss = this.getStrings(cs);
            return index < ss.length ? ss[index] : null;
        }

        public String[] getStrings(SpecificCharacterSet cs) throws DcmValueException {
            if (this.isEmpty()) {
                return STRING0;
            }
            byte[] b = this.data.array();
            String s = this.trim.trim(cs == null ? new String(b) : cs.decode(b));
            return StringUtils.split(s, '\\');
        }
    }

    private static final class UT
    extends StringElement {
        UT(int tag, ByteBuffer data) {
            super(tag, data, TRAIL_TRIM);
        }

        public final int vr() {
            return 21844;
        }
    }

    private static final class ST
    extends StringElement {
        ST(int tag, ByteBuffer data) {
            super(tag, data, TRAIL_TRIM);
        }

        public final int vr() {
            return 21332;
        }
    }

    private static final class LT
    extends StringElement {
        LT(int tag, ByteBuffer data) {
            super(tag, data, TRAIL_TRIM);
        }

        public final int vr() {
            return 19540;
        }
    }

    private static class CheckImpl
    implements Check {
        protected final int maxLen;
        protected final boolean text;

        CheckImpl(int maxLen, boolean text) {
            this.maxLen = maxLen;
            this.text = text;
        }

        public String check(String s) {
            char[] a = s.toCharArray();
            if (a.length > this.maxLen) {
                log.warn("Value: " + s + " exeeds VR length limit: " + this.maxLen);
            }
            for (int i = 0; i < a.length; ++i) {
                if (this.check(a[i])) continue;
                log.warn("Illegal character '" + a[i] + "' in value: " + s);
            }
            return s;
        }

        protected boolean check(char c) {
            return Character.isISOControl(c) ? this.text && StringElement.isDICOMControl(c) : this.text || c != '\\';
        }
    }

    private static interface Check {
        public String check(String var1);
    }

    private static interface Trim {
        public String trim(String var1);
    }
}

