/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.log4j.Logger;
import org.dcm4che.util.HandshakeFailedEvent;
import org.dcm4che.util.HandshakeFailedListener;
import org.dcm4che.util.SSLContextAdapter;

public class SSLContextAdapterImpl
extends SSLContextAdapter {
    static final Logger log = Logger.getLogger(SSLContextAdapterImpl.class);
    private String[] protocols = new String[]{"TLSv1", "SSLv3"};
    private final SSLContext ctx;
    private final KeyManagerFactory kmf;
    private final TrustManagerFactory tmf;
    private SecureRandom random = null;
    private KeyManager[] kms = null;
    private TrustManager[] tms = null;
    private boolean dirty = true;
    private boolean needClientAuth = true;
    private SSLServerSocket unboundSSLServerSocket = null;
    private List hcl = null;
    private List hfl = null;

    public static void main(String[] args) throws Exception {
        SSLContextAdapterImpl inst = new SSLContextAdapterImpl();
        System.out.println("SupportedCipherSuites" + Arrays.asList(((SSLContextAdapter)inst).getSupportedCipherSuites()));
        System.out.println("SupportedProtocols" + Arrays.asList(((SSLContextAdapter)inst).getSupportedProtocols()));
    }

    public SSLContextAdapterImpl() {
        try {
            this.ctx = SSLContext.getInstance("TLS");
            this.kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            this.tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        }
        catch (GeneralSecurityException e) {
            throw new ConfigurationError("could not instantiate SSLContext", e);
        }
    }

    public String toString() {
        return this.ctx.toString();
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
        this.hcl = SSLContextAdapterImpl.addToList(this.hcl, listener);
    }

    public void addHandshakeFailedListener(HandshakeFailedListener listener) {
        this.hfl = SSLContextAdapterImpl.addToList(this.hfl, listener);
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener listener) {
        this.hcl = SSLContextAdapterImpl.removeFromList(this.hcl, listener);
    }

    public void removeHandshakeFailedListener(HandshakeFailedListener listener) {
        this.hfl = SSLContextAdapterImpl.removeFromList(this.hfl, listener);
    }

    static List addToList(List l, Object elt) {
        if (l == null) {
            l = new ArrayList<Object>();
        }
        l.add(elt);
        return l;
    }

    static List removeFromList(List l, Object elt) {
        if (l == null) {
            return l;
        }
        l.remove(elt);
        if (l.size() == 0) {
            l = null;
        }
        return l;
    }

    public SSLContext getSSLContext() throws GeneralSecurityException {
        this.init();
        return this.ctx;
    }

    public void setKey(KeyStore key, char[] password) throws GeneralSecurityException {
        this.kmf.init(key, password);
        this.kms = this.kmf.getKeyManagers();
        this.dirty = true;
    }

    public void setTrust(KeyStore cacerts) throws GeneralSecurityException {
        this.tmf.init(cacerts);
        this.tms = this.tmf.getTrustManagers();
        this.dirty = true;
    }

    public KeyManager[] getKeyManagers() {
        return this.kms;
    }

    public TrustManager[] getTrustManagers() {
        return this.tms;
    }

    public void seedRandom(long seed) {
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
            this.random.setSeed(seed);
            this.dirty = true;
        }
        catch (GeneralSecurityException e) {
            throw new ConfigurationError("could not instantiate SecureRandom", e);
        }
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setEnabledProtocols(String[] protocols) {
        this.protocols = (String[])protocols.clone();
    }

    public String[] getEnabledProtocols() {
        return (String[])this.protocols.clone();
    }

    private SSLServerSocket getUnboundSSLServerSocket() {
        if (this.unboundSSLServerSocket != null) {
            return this.unboundSSLServerSocket;
        }
        try {
            SSLServerSocketFactory factory = this.ctx.getServerSocketFactory();
            this.unboundSSLServerSocket = (SSLServerSocket)factory.createServerSocket();
        }
        catch (IOException e) {
            throw new ConfigurationError("could not create unbounded ServerSocket", e);
        }
        return this.unboundSSLServerSocket;
    }

    public String[] getSupportedCipherSuites() {
        return this.getUnboundSSLServerSocket().getSupportedCipherSuites();
    }

    public String[] getSupportedProtocols() {
        return this.getUnboundSSLServerSocket().getSupportedProtocols();
    }

    public ServerSocketFactory getServerSocketFactory(String[] cipherSuites) throws GeneralSecurityException {
        return new SSLServerSocketFactoryAdapter(cipherSuites);
    }

    public SocketFactory getSocketFactory(String[] cipherSuites) throws GeneralSecurityException {
        return new SSLSocketFactoryAdapter(cipherSuites);
    }

    public void init() throws GeneralSecurityException {
        if (this.dirty) {
            this.ctx.init(this.kms, this.tms, this.random);
            this.dirty = false;
        }
    }

    private String toKeyStoreType(String fname) {
        return fname.endsWith(".p12") || fname.endsWith(".P12") ? "PKCS12" : "JKS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore loadKeyStore(URL url, char[] password) throws GeneralSecurityException, IOException {
        InputStream in = url.openStream();
        try {
            KeyStore keyStore = this.loadKeyStore(in, password, this.toKeyStoreType(url.getPath()));
            return keyStore;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ignore) {}
        }
    }

    public KeyStore loadKeyStore(String url, char[] password) throws GeneralSecurityException, IOException {
        try {
            return this.loadKeyStore(new URL(url), password);
        }
        catch (MalformedURLException e) {
            return this.loadKeyStore(new File(url), password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore loadKeyStore(File file, char[] password) throws GeneralSecurityException, IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            KeyStore keyStore = this.loadKeyStore(in, password, this.toKeyStoreType(file.getName()));
            return keyStore;
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (IOException ignore) {}
        }
    }

    public KeyStore loadKeyStore(InputStream in, char[] password, String type) throws GeneralSecurityException, IOException {
        KeyStore key = KeyStore.getInstance(type);
        key.load(in, password);
        return key;
    }

    static String[] supported(String[] cipherSuites, String[] supportedCipherSuites) {
        String[] supported = new String[cipherSuites.length];
        int count = 0;
        for (int i = 0; i < cipherSuites.length; ++i) {
            if (SSLContextAdapterImpl.contains(supportedCipherSuites, cipherSuites[i])) {
                supported[count++] = cipherSuites[i];
                continue;
            }
            log.warn("CipherSuite " + cipherSuites[i] + " not supported by JSSE provider.");
        }
        if (count < supported.length) {
            String[] tmp = new String[count];
            System.arraycopy(supported, 0, tmp, 0, count);
            supported = tmp;
        }
        return supported;
    }

    static boolean contains(String[] ss, String s) {
        for (int i = 0; i < ss.length; ++i) {
            if (!ss[i].equals(s)) continue;
            return true;
        }
        return false;
    }

    public void startHandshake(SSLSocket s) throws IOException {
        block7: {
            InetAddress remoteAddr = s.getInetAddress();
            try {
                s.startHandshake();
                if (!log.isInfoEnabled()) break block7;
                SSLSession se = s.getSession();
                try {
                    X509Certificate cert = (X509Certificate)se.getPeerCertificates()[0];
                    cert.checkValidity();
                    log.info(s.getInetAddress().toString() + ": accept " + se.getCipherSuite() + " with " + cert.getSubjectDN() + " valid from " + cert.getNotBefore() + " to " + cert.getNotAfter());
                }
                catch (SSLPeerUnverifiedException e) {
                    log.error("SSL peer not verified:", e);
                }
                catch (CertificateException ce) {
                    throw new IOException(ce.getMessage());
                }
            }
            catch (IOException e) {
                if (this.hfl != null) {
                    HandshakeFailedEvent event = new HandshakeFailedEvent(s, remoteAddr, e);
                    int n = this.hfl.size();
                    for (int i = 0; i < n; ++i) {
                        ((HandshakeFailedListener)this.hfl.get(i)).handshakeFailed(event);
                    }
                }
                throw e;
            }
        }
    }

    static class ConfigurationError
    extends Error {
        ConfigurationError(String msg, Exception x) {
            super(msg, x);
        }
    }

    private class SSLSocketFactoryAdapter
    extends SocketFactory {
        final SSLSocketFactory sf;
        final String[] cipherSuites;

        SSLSocketFactoryAdapter(String[] cipherSuites) throws GeneralSecurityException {
            this.sf = SSLContextAdapterImpl.this.getSSLContext().getSocketFactory();
            this.cipherSuites = cipherSuites != null ? SSLContextAdapterImpl.supported(cipherSuites, this.sf.getSupportedCipherSuites()) : null;
        }

        public Socket createSocket() throws IOException {
            SSLSocket s = (SSLSocket)this.sf.createSocket();
            if (this.cipherSuites != null) {
                s.setEnabledCipherSuites(this.cipherSuites);
            }
            s.setEnabledProtocols(SSLContextAdapterImpl.this.getEnabledProtocols());
            if (SSLContextAdapterImpl.this.hcl != null) {
                int n = SSLContextAdapterImpl.this.hcl.size();
                for (int i = 0; i < n; ++i) {
                    s.addHandshakeCompletedListener((HandshakeCompletedListener)SSLContextAdapterImpl.this.hcl.get(i));
                }
            }
            return s;
        }

        public Socket createSocket(InetAddress ia, int port) throws IOException {
            return this.init((SSLSocket)this.sf.createSocket(ia, port));
        }

        public Socket createSocket(InetAddress ia, int port, InetAddress clientIA, int clientPort) throws IOException {
            return this.init((SSLSocket)this.sf.createSocket(ia, port, clientIA, clientPort));
        }

        public Socket createSocket(String host, int port, InetAddress clientIA, int clientPort) throws IOException {
            return this.init((SSLSocket)this.sf.createSocket(host, port, clientIA, clientPort));
        }

        public Socket createSocket(String host, int port) throws IOException {
            return this.init((SSLSocket)this.sf.createSocket(host, port));
        }

        private Socket init(SSLSocket s) throws IOException {
            if (this.cipherSuites != null) {
                s.setEnabledCipherSuites(this.cipherSuites);
            }
            s.setEnabledProtocols(SSLContextAdapterImpl.this.getEnabledProtocols());
            if (SSLContextAdapterImpl.this.hcl != null) {
                int n = SSLContextAdapterImpl.this.hcl.size();
                for (int i = 0; i < n; ++i) {
                    s.addHandshakeCompletedListener((HandshakeCompletedListener)SSLContextAdapterImpl.this.hcl.get(i));
                }
            }
            SSLContextAdapterImpl.this.startHandshake(s);
            return s;
        }
    }

    private class SSLServerSocketFactoryAdapter
    extends ServerSocketFactory {
        final SSLServerSocketFactory ssf;
        final String[] cipherSuites;

        SSLServerSocketFactoryAdapter(String[] cipherSuites) throws GeneralSecurityException {
            this.ssf = SSLContextAdapterImpl.this.getSSLContext().getServerSocketFactory();
            this.cipherSuites = cipherSuites != null ? SSLContextAdapterImpl.supported(cipherSuites, this.ssf.getSupportedCipherSuites()) : null;
        }

        public ServerSocket createServerSocket(int port, int backlog) throws IOException {
            return this.init((SSLServerSocket)this.ssf.createServerSocket(port, backlog));
        }

        public ServerSocket createServerSocket(int port, int backlog, InetAddress ia) throws IOException {
            return this.init((SSLServerSocket)this.ssf.createServerSocket(port, backlog, ia));
        }

        public ServerSocket createServerSocket(int port) throws IOException {
            return this.init((SSLServerSocket)this.ssf.createServerSocket(port));
        }

        private ServerSocket init(SSLServerSocket ss) {
            ss.setNeedClientAuth(SSLContextAdapterImpl.this.isNeedClientAuth());
            ss.setEnabledProtocols(SSLContextAdapterImpl.this.getEnabledProtocols());
            if (this.cipherSuites != null) {
                ss.setEnabledCipherSuites(this.cipherSuites);
            }
            return ss;
        }
    }
}

