/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.AbstractSyntax;
import fr.apteryx.imageio.dicom.Association;
import fr.apteryx.imageio.dicom.DataSet;
import fr.apteryx.imageio.dicom.DicomException;
import fr.apteryx.imageio.dicom.DicomObject;
import fr.apteryx.imageio.dicom.DicomWarningListener;
import fr.apteryx.imageio.dicom.DicomWriter;
import fr.apteryx.imageio.dicom.PeerAE;
import fr.apteryx.imageio.dicom.ReceivedMessage;
import fr.apteryx.imageio.dicom.Tag;
import fr.apteryx.imageio.dicom.TransferSyntax;
import fr.apteryx.imageio.dicom.Util;
import java.io.IOException;
import java.util.ArrayList;

public class StorageSCU {
    private final PeerAE peer;

    public StorageSCU(PeerAE peerAE) {
        this.peer = peerAE;
    }

    void store(DicomObject dicomObject, DicomWriter dicomWriter, DicomWarningListener dicomWarningListener) throws DicomException, IOException {
        this.store(dicomObject, dicomWriter, dicomWarningListener, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store(DicomObject dicomObject, DicomWriter dicomWriter, DicomWarningListener dicomWarningListener, String string, int n) throws DicomException, IOException {
        int n2;
        Object object;
        ArrayList<String> arrayList;
        if (dicomObject.transferSyntax == null) {
            arrayList = new ArrayList<String>();
            object = dicomWriter.preferredTS;
            for (n2 = 0; n2 < ((TransferSyntax[])object).length; ++n2) {
                if (!dicomObject.suits(object[n2])) continue;
                arrayList.add(object[n2].uid);
            }
        } else {
            arrayList = new ArrayList(1);
            arrayList.add(dicomObject.transferSyntax.uid);
        }
        object = new Association(this.peer, new AbstractSyntax[]{new AbstractSyntax(1, dicomObject.sopClass, arrayList)});
        try {
            n2 = StorageSCU.sendRqInAssoc(dicomObject, dicomWriter, (Association)object, string, n);
            ReceivedMessage receivedMessage = ((Association)object).receiveMessage();
            if (receivedMessage == null) {
                throw new DicomException("ServiceError", "Association released by remote SCP");
            }
            StorageSCU.processRsp(receivedMessage, dicomWarningListener, n2);
        }
        finally {
            ((Association)object).release();
        }
    }

    static int sendRqInAssoc(DicomObject dicomObject, DicomWriter dicomWriter, Association association, String string, int n) throws IOException {
        DataSet dataSet = new DataSet();
        int n2 = association.newMessageID();
        dataSet.add(2, dicomObject.sopClass);
        dataSet.add(256, 1);
        dataSet.add(272, n2);
        dataSet.add(1792, 0);
        dataSet.add(2048, 0);
        dataSet.add(4096, dicomObject.sopInstance);
        if (string != null) {
            dataSet.add(4144, string);
            dataSet.add(4145, n);
        }
        dataSet.add(0, dataSet.getLength());
        association.sendMessage(dicomObject.sopClass, dataSet, dicomObject.ds, false, dicomWriter);
        return n2;
    }

    static void processRsp(ReceivedMessage receivedMessage, DicomWarningListener dicomWarningListener, int n) throws DicomException {
        DataSet dataSet = receivedMessage.command;
        if (dataSet.findInt(256) != 32769) {
            throw new DicomException("ProtocoleViolation", "Invalid response received (not a store response)");
        }
        if (dataSet.findInt(288) != n) {
            throw new DicomException("ProtocoleViolation", "Invalid store response received");
        }
        int n2 = dataSet.findInt(2304);
        if (n2 == 0) {
            return;
        }
        String string = dataSet.findString(2306);
        if (string == null) {
            string = "No additional comment";
        }
        String string2 = "Offending elements: " + Tag.tagListToString(dataSet.find(2305));
        if (n2 >> 8 == 167) {
            throw new DicomException("ServiceRefused", "Out of resources (" + string + ')');
        }
        if (n2 >> 12 == 12) {
            throw new DicomException("ServiceError", "Cannot understand (" + string + ", " + string2 + ')');
        }
        if (n2 >> 8 == 169) {
            throw new DicomException("ServiceError", "Data Set does not match SOP Class (" + string + ", " + string2 + ')');
        }
        if (n2 == 45056) {
            dicomWarningListener.warning("ServiceWarning", "Coercion of Data Elements (" + string + ", " + string2 + ')');
        } else if (n2 == 45063) {
            dicomWarningListener.warning("ServiceWarning", "Data Set does not match SOP Class (" + string + ", " + string2 + ')');
        } else if (n2 == 45062) {
            dicomWarningListener.warning("ServiceWarning", "Elements Discarded (" + string + ", " + string2 + ')');
        } else {
            Util.genericStatus(dataSet, dicomWarningListener);
        }
    }
}

