/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.delegater;

import java.awt.Dimension;
import java.awt.Image;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import javax.persistence.PersistenceException;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import open.dolphin.client.ImageEntry;
import open.dolphin.delegater.DelegaterErrorHandler;
import open.dolphin.dto.DiagnosisSearchSpec;
import open.dolphin.dto.DocumentSearchSpec;
import open.dolphin.dto.ImageSearchSpec;
import open.dolphin.dto.ModuleSearchSpec;
import open.dolphin.dto.ObservationSearchSpec;
import open.dolphin.infomodel.DocInfoModel;
import open.dolphin.infomodel.DocumentModel;
import open.dolphin.infomodel.KarteBean;
import open.dolphin.infomodel.LetterModel;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.infomodel.ObservationModel;
import open.dolphin.infomodel.PatientMemoModel;
import open.dolphin.infomodel.RegisteredDiagnosisModel;
import open.dolphin.infomodel.SchemaModel;
import open.dolphin.infomodel.TouTouLetter;
import open.dolphin.infomodel.TouTouReply;
import open.dolphin.project.GlobalSettings;
import open.dolphin.service.IKarteService;
import open.dolphin.utils.DebugDump;

public abstract class DocumentDelegater
extends DelegaterErrorHandler {
    protected abstract IKarteService getService() throws NamingException;

    public int deleteDocument(long pk) {
        try {
            return this.getService().deleteDocument(pk);
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
            return 0;
        }
    }

    public DocumentModel getDocument(final String templateName) {
        final List templateNames = this.getDocumentList(null);
        ArrayList<Long> ids = new ArrayList<Long>(){
            {
                super.add(new Long(templateNames.indexOf(templateName)));
            }
        };
        DocumentModel document = null;
        try {
            List<DocumentModel> documents = this.getDocuments((List<Long>)ids);
            if (!documents.isEmpty()) {
                document = documents.get(0);
            }
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
        }
        return document;
    }

    public List getDocumentList(DocumentSearchSpec spec) {
        try {
            return this.getService().getDocumentList(spec);
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
            return null;
        }
    }

    public List<DocumentModel> getDocuments(List<Long> ids) {
        try {
            List<DocumentModel> result = this.getService().getDocuments(ids);
            for (DocumentModel doc : result) {
                Set<ModuleModel> mc = doc.getModules();
                for (ModuleModel module : mc) {
                    module.setModel(module.toInfoModel());
                }
                Set<SchemaModel> sc = doc.getSchemas();
                if (sc == null) continue;
                for (SchemaModel schema : sc) {
                    ImageIcon icon = new ImageIcon(schema.getJpegBytes());
                    schema.setIcon(icon);
                }
            }
            return result;
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
            return null;
        }
    }

    public long putDocument(DocumentModel docModel) {
        try {
            docModel.toPersist();
            if (GlobalSettings.isKarteDataDump()) {
                this.debugDump(docModel);
            }
            try {
                return this.getService().putDocument(docModel);
            }
            catch (PersistenceException e) {
                this.showErrorMessage("\u4ed6\u306e\u30de\u30b7\u30f3\u3067\u540c\u3058\u30ab\u30eb\u30c6\u3092\u7de8\u96c6\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002" + System.getProperty("line.separator") + e.getMessage());
                this.dispatchError(this.getClass(), (Exception)((Object)e), "");
            }
        }
        catch (Exception e) {
            this.showErrorMessage("\u30b5\u30fc\u30d0\u4fdd\u5b58\u6642\u306e\u30a8\u30e9\u30fc\u3002" + System.getProperty("line.separator") + e.getMessage());
            this.dispatchError(this.getClass(), e, "");
        }
        return -1L;
    }

    public KarteBean getKarte(long patientPk, Date fromDate) {
        try {
            return this.getService().getKarte(patientPk, fromDate);
        }
        catch (Exception e) {
            this.showErrorMessage(e.toString());
            this.dispatchError(this.getClass(), e, "");
            return null;
        }
    }

    public List getDocumentHistory(DocumentSearchSpec spec) {
        if (spec.getDocType().equals("karte")) {
            return this.getDocumentList(spec);
        }
        if (spec.getDocType().equals("letter")) {
            return this.getLetterList(spec);
        }
        if (spec.getDocType().equals("letterReply")) {
            return this.getLetterReplyList(spec);
        }
        return null;
    }

    private List<LetterModel> getLetterModelsFromModels(List<LetterModel> models) throws SQLException {
        ArrayList<LetterModel> result = new ArrayList<LetterModel>();
        LetterModel temp = null;
        for (LetterModel model : models) {
            temp = model.toInfoModel();
            temp.setId(model.getId());
            temp.setBeanBytes(null);
            result.add(temp);
        }
        return result;
    }

    public List<LetterModel> getRecentLetterModels() {
        try {
            List<LetterModel> models = this.getService().getRecentLetterModels("TOUTOU");
            return this.getLetterModelsFromModels(models);
        }
        catch (Exception ex) {
            this.dispatchError(this.getClass(), ex, "");
            return null;
        }
    }

    public List<LetterModel> getRecentLetterModels(long letterPkL) {
        try {
            List<LetterModel> models = this.getService().getRecentLetterModels(letterPkL, "TOUTOU");
            return this.getLetterModelsFromModels(models);
        }
        catch (Exception ex) {
            this.dispatchError(this.getClass(), ex, "");
            return null;
        }
    }

    private List<DocInfoModel> getLetterList(DocumentSearchSpec spec) {
        ArrayList<DocInfoModel> result = new ArrayList<DocInfoModel>();
        try {
            List<LetterModel> models = this.getService().getLetterList(spec.getKarteId(), "TOUTOU");
            for (LetterModel model : models) {
                TouTouLetter letter = (TouTouLetter)model;
                DocInfoModel docInfo = new DocInfoModel();
                docInfo.setDocPk(letter.getId());
                docInfo.setDocType("letter");
                docInfo.setDocId(String.valueOf(letter.getId()));
                docInfo.setConfirmDate(letter.getConfirmed());
                docInfo.setFirstConfirmDate(letter.getConfirmed());
                docInfo.setTitle(letter.getConsultantHospital());
                result.add(docInfo);
            }
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
        }
        return result;
    }

    public List<LetterModel> getRecentLetterReplyModels() {
        try {
            List<LetterModel> models = this.getService().getRecentLetterModels("TOUTOU_REPLY");
            return this.getLetterModelsFromModels(models);
        }
        catch (Exception ex) {
            this.dispatchError(this.getClass(), ex, "");
            return null;
        }
    }

    public List<LetterModel> getRecentLetterReplyModels(long letterPkL) {
        try {
            List<LetterModel> models = this.getService().getRecentLetterModels(letterPkL, "TOUTOU_REPLY");
            return this.getLetterModelsFromModels(models);
        }
        catch (Exception ex) {
            this.dispatchError(this.getClass(), ex, "");
            return null;
        }
    }

    private List<DocInfoModel> getLetterReplyList(DocumentSearchSpec spec) {
        ArrayList<DocInfoModel> result = new ArrayList<DocInfoModel>();
        try {
            List<LetterModel> models = this.getService().getLetterList(spec.getKarteId(), "TOUTOU_REPLY");
            for (LetterModel model : models) {
                TouTouReply letter = (TouTouReply)model;
                DocInfoModel docInfo = new DocInfoModel();
                docInfo.setDocPk(letter.getId());
                docInfo.setDocType("letterReply");
                docInfo.setDocId(String.valueOf(letter.getId()));
                docInfo.setConfirmDate(letter.getConfirmed());
                docInfo.setFirstConfirmDate(letter.getConfirmed());
                docInfo.setTitle(letter.getClientHospital());
                result.add(docInfo);
            }
        }
        catch (Exception e) {
            this.showErrorMessage(e.toString());
            this.dispatchError(this.getClass(), e, "");
        }
        return result;
    }

    public LetterModel getLetter(long letterPk) {
        LetterModel result = null;
        try {
            LetterModel model = this.getService().getLetter(letterPk);
            result = model.toInfoModel();
            result.setId(model.getId());
            result.setBeanBytes(null);
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
        }
        return result;
    }

    public LetterModel getLetterReply(long letterPk) {
        LetterModel result = null;
        try {
            LetterModel model = this.getService().getLetterReply(letterPk);
            result = model.toInfoModel();
            result.setId(model.getId());
            result.setBeanBytes(null);
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
        }
        return result;
    }

    public int updateTitle(DocInfoModel docInfo) {
        try {
            return this.getService().updateTitle(docInfo.getDocPk(), docInfo.getTitle());
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
            return 0;
        }
    }

    public List getModuleList(ModuleSearchSpec spec) {
        List<List> result = null;
        try {
            result = this.getService().getModules(spec);
            for (List list : result) {
                for (ModuleModel module : list) {
                    module.setModel(module.toInfoModel());
                }
            }
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
        }
        return result;
    }

    public List getAllModuleList(ModuleSearchSpec spec) {
        List<ModuleModel> result = null;
        try {
            result = this.getService().getAllModule(spec);
            for (ModuleModel module : result) {
                module.setModel(module.toInfoModel());
            }
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
        }
        return result;
    }

    public SchemaModel getImage(long id) {
        SchemaModel result = null;
        try {
            byte[] bytes;
            ImageIcon icon;
            result = this.getService().getImage(id);
            if (result != null && (icon = new ImageIcon(bytes = result.getJpegBytes())) != null) {
                result.setIcon(icon);
            }
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
        }
        return result;
    }

    public List getImageList(ImageSearchSpec spec) {
        ArrayList result = new ArrayList(3);
        try {
            List<List> images = this.getService().getImages(spec);
            for (List periodList : images) {
                ArrayList<ImageEntry> el = new ArrayList<ImageEntry>();
                for (SchemaModel model : periodList) {
                    ImageEntry entry = this.getImageEntry(model, spec.getIconSize());
                    el.add(entry);
                }
                result.add(el);
            }
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
        }
        return result;
    }

    private ImageEntry getImageEntry(SchemaModel schema, Dimension iconSize) {
        ImageEntry result = new ImageEntry();
        result.setId(schema.getId());
        result.setConfirmDate(ModelUtils.getDateTimeAsString(schema.getConfirmed()));
        result.setContentType(schema.getExtRef().getContentType());
        result.setTitle(schema.getExtRef().getTitle());
        result.setMedicalRole(schema.getExtRef().getMedicalRole());
        byte[] bytes = schema.getJpegBytes();
        ImageIcon icon = new ImageIcon(bytes);
        if (icon != null) {
            result.setImageIcon(this.adjustImageSize(icon, iconSize));
        }
        return result;
    }

    public List<Long> putDiagnosis(List<RegisteredDiagnosisModel> beans) {
        try {
            return this.getService().addDiagnosis(beans);
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
            return null;
        }
    }

    public int updateDiagnosis(List<RegisteredDiagnosisModel> beans) {
        try {
            return this.getService().updateDiagnosis(beans);
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
            return 0;
        }
    }

    public int removeDiagnosis(List<Long> ids) {
        try {
            return this.getService().removeDiagnosis(ids);
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
            return 0;
        }
    }

    public List<RegisteredDiagnosisModel> getDiagnosisList(DiagnosisSearchSpec spec) {
        try {
            return this.getService().getDiagnosis(spec);
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
            return null;
        }
    }

    public List<Long> addObservations(List<ObservationModel> observations) {
        try {
            return this.getService().addObservations(observations);
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
            return null;
        }
    }

    public List<ObservationModel> getObservations(ObservationSearchSpec spec) {
        try {
            return this.getService().getObservations(spec);
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
            return null;
        }
    }

    public int updateObservations(List<ObservationModel> observations) {
        try {
            return this.getService().updateObservations(observations);
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
            return 0;
        }
    }

    public int removeObservations(List<Long> ids) {
        try {
            return this.getService().removeObservations(ids);
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
            return 0;
        }
    }

    public int updatePatientMemo(PatientMemoModel pm) {
        try {
            return this.getService().updatePatientMemo(pm);
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
            return 0;
        }
    }

    public List getAppoinmentList(ModuleSearchSpec spec) {
        try {
            return this.getService().getAppointmentList(spec);
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
            return null;
        }
    }

    private ImageIcon adjustImageSize(ImageIcon icon, Dimension dim) {
        if (icon.getIconHeight() > dim.height || icon.getIconWidth() > dim.width) {
            int w;
            int h;
            float wRatio;
            Image img = icon.getImage();
            float hRatio = (float)icon.getIconHeight() / (float)dim.height;
            if (hRatio > (wRatio = (float)icon.getIconWidth() / (float)dim.width)) {
                h = dim.height;
                w = (int)((float)icon.getIconWidth() / hRatio);
            } else {
                w = dim.width;
                h = (int)((float)icon.getIconHeight() / wRatio);
            }
            img = img.getScaledInstance(w, h, 4);
            return new ImageIcon(img);
        }
        return icon;
    }

    private void showErrorMessage(String message) {
        JOptionPane.showMessageDialog(null, message, "\u30a8\u30e9\u30fc", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debugDump(DocumentModel docModel) {
        StringWriter writer = new StringWriter();
        try {
            docModel.serialize(writer);
            DebugDump.dumpToFile("lastkarte.log", writer.toString());
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {
                this.dispatchError(this.getClass(), e, "");
            }
        }
    }
}

