/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.helper;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import open.dolphin.client.AutoKanjiListener;
import open.dolphin.client.AutoRomanListener;
import open.dolphin.helper.GridBagComponent;

public class GridBagBuilder {
    private static final int CMP_HGAP = 7;
    private static final int CMP_VGAP = 7;
    private static final int TITLE_SPACE_TOP = 0;
    private static final int TITLE_SPACE_LEFT = 0;
    private static final int TITLE_SPACE_BOTTOM = 10;
    private static final int TITLE_SPACE_RIGHT = 0;
    private JPanel container;
    private JPanel product;
    private int cmpSpaceH = 7;
    private int cmpSpaceV = 7;
    private int titleSpaceTop = 0;
    private int titleSpaceLeft = 0;
    private int titleSpaceBottom = 10;
    private int titleSpaceRight = 0;

    public GridBagBuilder(JPanel panel) {
        this.container = this.product = panel;
    }

    public GridBagBuilder(JPanel panel, String title) {
        this(panel);
        this.setTitle(new JPanel(new GridBagLayout()), title);
    }

    private void setTitle(JPanel panel, String title) {
        if (title != null) {
            this.product.setBorder(BorderFactory.createTitledBorder(title));
            this.container = panel;
            this.container.setBorder(BorderFactory.createEmptyBorder(this.getTitleSpaceTop(), this.getTitleSpaceLeft(), this.getTitleSpaceBottom(), this.getTitleSpaceRight()));
            this.product.add((Component)this.container, "Center");
        }
    }

    public void add(Component c, int x, int y, int anchor) {
        this.add(c, x, y, 1, 1, anchor);
    }

    public void add(Component cmp, int x, int y, int width, int height, int anchor) {
        int top = y == 0 ? 0 : this.getCmpSpaceV();
        int left = x == 0 ? 0 : this.getCmpSpaceH();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = x;
        c.gridy = y;
        c.gridwidth = width;
        c.gridheight = height;
        c.fill = 0;
        c.anchor = anchor;
        if (top != 0 || left != 0) {
            c.insets = new Insets(top, left, 0, 0);
        }
        ((GridBagLayout)this.container.getLayout()).setConstraints(cmp, c);
        this.container.add(cmp);
    }

    public void add(Component cmp, int x, int y, int fill, double wx, double wy) {
        this.add(cmp, x, y, 1, 1, fill, wx, wy);
    }

    public void add(Component cmp, int x, int y, int width, int height, int fill, double wx, double wy) {
        int top = y == 0 ? 0 : this.getCmpSpaceV();
        int left = x == 0 ? 0 : this.getCmpSpaceH();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = x;
        c.gridy = y;
        c.gridwidth = width;
        c.gridheight = height;
        c.fill = fill;
        c.weightx = wx;
        c.weighty = wy;
        if (top != 0 || left != 0) {
            c.insets = new Insets(top, left, 0, 0);
        }
        ((GridBagLayout)this.container.getLayout()).setConstraints(cmp, c);
        this.container.add(cmp);
    }

    public void addGlue(int x, int y, int fill) {
        this.add(new JLabel(""), x, y, 1, 1, fill, 1.0, 1.0);
    }

    public void addHGlue(int x, int y) {
        this.add(new JLabel(""), x, y, 1, 1, 2, 1.0, 1.0);
    }

    public void addVGlue(int x, int y) {
        this.add(new JLabel(""), x, y, 1, 1, 3, 1.0, 1.0);
    }

    public void setCmpSpaceH(int cmpSpaceH) {
        this.cmpSpaceH = cmpSpaceH;
    }

    public int getCmpSpaceH() {
        return this.cmpSpaceH;
    }

    public void setCmpSpaceV(int cmpSpaceV) {
        this.cmpSpaceV = cmpSpaceV;
    }

    public int getCmpSpaceV() {
        return this.cmpSpaceV;
    }

    public void setTitleSpaceTop(int titleSpaceTop) {
        this.titleSpaceTop = titleSpaceTop;
    }

    public int getTitleSpaceTop() {
        return this.titleSpaceTop;
    }

    public void setTitleSpaceLeft(int titleSpaceLeft) {
        this.titleSpaceLeft = titleSpaceLeft;
    }

    public int getTitleSpaceLeft() {
        return this.titleSpaceLeft;
    }

    public void setTitleSpaceBottom(int titleSpaceBottom) {
        this.titleSpaceBottom = titleSpaceBottom;
    }

    public int getTitleSpaceBottom() {
        return this.titleSpaceBottom;
    }

    public void setTitleSpaceRight(int titleSpaceRight) {
        this.titleSpaceRight = titleSpaceRight;
    }

    public int getTitleSpaceRight() {
        return this.titleSpaceRight;
    }

    public void addTextItem(int row, int col, String title, int length, boolean kanji) {
        JLabel l = new JLabel(title, 4);
        JTextField tf = new JTextField(length);
        tf.setMargin(new Insets(1, 2, 1, 2));
        if (kanji) {
            tf.addFocusListener(AutoKanjiListener.getInstance());
        } else {
            tf.addFocusListener(AutoRomanListener.getInstance());
        }
        this.add((Component)l, col, row, 1, 1, 3);
        this.add((Component)tf, col, row, 1, 1, 7);
    }

    public void layout(List<GridBagComponent> components) {
        for (GridBagComponent gbc : components) {
            int x = gbc.getCol();
            int y = gbc.getRow();
            int top = y == 0 ? 0 : this.getCmpSpaceV();
            int left = x == 0 ? 0 : this.getCmpSpaceH();
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = x;
            c.gridy = y;
            c.gridwidth = gbc.getColSpan();
            c.gridheight = gbc.getRowSpan();
            c.anchor = gbc.getAnchor();
            c.fill = gbc.getFill();
            c.weightx = gbc.getColWeight();
            c.weighty = gbc.getRowWeight();
            if (top != 0 || left != 0) {
                c.insets = new Insets(top, left, 0, 0);
            }
            ((GridBagLayout)this.container.getLayout()).setConstraints(gbc.getComponent(), c);
            this.container.add(gbc.getComponent());
        }
    }
}

