/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.message;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import open.dolphin.infomodel.AccessRightModel;
import open.dolphin.infomodel.BundleDolphin;
import open.dolphin.infomodel.BundleMed;
import open.dolphin.infomodel.ClaimItem;
import open.dolphin.infomodel.DocumentModel;
import open.dolphin.infomodel.IInfoModel;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.infomodel.ProgressCourse;
import open.dolphin.infomodel.SchemaModel;
import open.dolphin.infomodel.UserModel;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalVariables;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class MMLHelper {
    private DocumentModel document;
    private UserModel user;
    private String patientId;
    private StringBuilder freeExp;
    private StringBuilder paragraphBuilder;
    private String soaSpec;
    private String pSpec;
    private List<ModuleModel> pModules;
    private List<SchemaModel> schemas;
    private List<AccessRightModel> accessRights;
    private boolean DEBUG = false;

    public MMLHelper(DocumentModel sendModel, String patientId) {
        this.setDocument(sendModel);
        this.setUser(GlobalVariables.getUserModel());
        this.setPatientId(patientId);
        this.buildText();
    }

    public DocumentModel getDocument() {
        return this.document;
    }

    private void setDocument(DocumentModel document) {
        this.document = document;
    }

    private void buildText() {
        Collection<AccessRightModel> arc;
        Set<ModuleModel> moduleBeans = this.getDocument().getModules();
        this.pModules = new ArrayList<ModuleModel>();
        for (ModuleModel module : moduleBeans) {
            String role = module.getModuleInfo().getStampRole();
            if (role.equals("soaSpec")) {
                this.soaSpec = ((ProgressCourse)module.getModel()).getFreeText();
                continue;
            }
            if (role.equals("p")) {
                this.pModules.add(module);
                continue;
            }
            if (!role.equals("pSpec")) continue;
            this.pSpec = ((ProgressCourse)module.getModel()).getFreeText();
        }
        Set<SchemaModel> schemaC = this.getDocument().getSchemas();
        if (schemaC != null && schemaC.size() > 0) {
            this.schemas = new ArrayList<SchemaModel>(schemaC.size());
            this.schemas.addAll(schemaC);
        }
        if ((arc = this.getDocument().getDocInfo().getAccessRights()) != null && arc.size() > 0) {
            this.accessRights = new ArrayList<AccessRightModel>(arc.size());
            this.accessRights.addAll(arc);
        }
        this.freeExp = new StringBuilder();
        if (this.soaSpec != null) {
            this.parse(this.soaSpec);
        }
        if (this.pSpec != null) {
            this.parse(this.pSpec);
        }
    }

    public UserModel getUser() {
        return this.user;
    }

    private void setUser(UserModel user) {
        this.user = user;
    }

    public String getPatientId() {
        return this.patientId;
    }

    private void setPatientId(String patientId) {
        this.patientId = patientId;
    }

    public String getCNPatientId() {
        return this.patientId;
    }

    public String getCNPatientIdType() {
        return "facility";
    }

    public String getCNPatientIdTableId() {
        return this.getCNFacilityId();
    }

    public String getCNFacilityName() {
        return this.getUser().getFacility().getFacilityName();
    }

    public String getCNFacilityId() {
        if (GlobalVariables.getJoinAreaNetwork()) {
            return GlobalVariables.getAreaNetworkFacilityId();
        }
        return this.getUser().getFacility().getFacilityId();
    }

    public String getCNFacilityIdType() {
        return "JMARI";
    }

    public String getCNFacilityIdTableId() {
        return "MML0027";
    }

    public String getCNCreatorId() {
        if (GlobalVariables.getJoinAreaNetwork()) {
            return GlobalVariables.getAreaNetworkCreatorId();
        }
        return this.getUser().getUserId();
    }

    public String getCNCreatorIdType() {
        return "local";
    }

    public String getCNCreatorIdTableId() {
        return "MML0024";
    }

    public String getCreatorName() {
        return this.getUser().getCommonName();
    }

    public String getCreatorLicense() {
        return this.getUser().getLicenseModel().getLicense();
    }

    public String getPurpose() {
        return this.getDocument().getDocInfo().getPurpose();
    }

    public String getTitle() {
        return this.getDocument().getDocInfo().getTitle();
    }

    public String getDocId() {
        return this.getDocument().getDocInfo().getDocId();
    }

    public String getParentId() {
        return this.getDocument().getDocInfo().getParentId();
    }

    public String getParentIdRelation() {
        return this.getDocument().getDocInfo().getParentIdRelation();
    }

    public String getGroupId() {
        return this.getDocument().getDocInfo().getDocId();
    }

    public String getConfirmDate() {
        return ModelUtils.getDateTimeAsString(this.getDocument().getDocInfo().getConfirmDate());
    }

    public String getFirstConfirmDate() {
        return ModelUtils.getDateTimeAsString(this.getDocument().getDocInfo().getFirstConfirmDate());
    }

    public List<SchemaModel> getSchema() {
        return this.schemas;
    }

    public List<AccessRightModel> getAccessRights() {
        return this.accessRights;
    }

    public String getFreeExpression() {
        String ret = this.freeExp.toString();
        return ret;
    }

    private void parse(String spec) {
        try {
            BufferedReader reader = new BufferedReader(new StringReader(spec));
            SAXBuilder docBuilder = new SAXBuilder();
            Document doc = docBuilder.build((Reader)reader);
            Element root = doc.getRootElement();
            this.parseChildren(root);
            reader.close();
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
        }
    }

    private void parseChildren(Element current) {
        List children = current.getChildren();
        if (children == null || children.size() == 0) {
            return;
        }
        for (Element child : children) {
            String ename = child.getName();
            if (ename.equals("paragraph")) {
                if (this.paragraphBuilder != null) {
                    this.freeExp.append(this.paragraphBuilder.toString());
                    this.freeExp.append("<xhtml:br/>");
                    this.freeExp.append(System.getProperty("line.separator"));
                }
                this.paragraphBuilder = new StringBuilder();
            } else if (ename.equals("component")) {
                String name = child.getAttributeValue("name");
                int number = Integer.parseInt(child.getAttributeValue("component"));
                if (name.equals("schemaHolder")) {
                    this.paragraphBuilder.append(this.getSchemaInfo(this.schemas.get(number)));
                } else if (name.equals("stampHolder")) {
                    this.paragraphBuilder.append(this.getStampInfo(this.pModules.get(number)));
                }
            } else if (ename.equals("text")) {
                this.paragraphBuilder.append(child.getText());
            }
            this.parseChildren(child);
        }
    }

    private String getSchemaInfo(SchemaModel schema) {
        String contentType = schema.getExtRef().getContentType();
        String medicalRole = schema.getExtRef().getMedicalRole();
        String title = schema.getExtRef().getTitle();
        String href = schema.getExtRef().getHref();
        StringBuilder sb = new StringBuilder();
        sb.append("<mmlCm:extRef");
        sb.append(" mmlCm:contentType=");
        sb.append(this.addQuote(contentType));
        sb.append(" mmlCm:medicalRole=");
        sb.append(this.addQuote(medicalRole));
        sb.append(" mmlCm:title=");
        sb.append(this.addQuote(title));
        sb.append(" mmlCm:href=");
        sb.append(this.addQuote(href));
        sb.append(" />");
        return sb.toString();
    }

    private String getStampInfo(ModuleModel module) {
        IInfoModel obj = module.getModel();
        StringBuilder buf = new StringBuilder();
        if (obj instanceof BundleMed) {
            ClaimItem[] items;
            BundleMed med = (BundleMed)obj;
            buf.append("RP<xhtml:br/>");
            buf.append(System.getProperty("line.separator"));
            for (ClaimItem item : items = med.getClaimItem()) {
                buf.append("\u30fb");
                buf.append(item.getName());
                buf.append("\u3000");
                if (item.getNumber() != null) {
                    buf.append(item.getNumber());
                    if (item.getUnit() != null) {
                        buf.append(item.getUnit());
                    }
                }
                buf.append("<xhtml:br/>");
                buf.append(System.getProperty("line.separator"));
            }
            if (med.getAdmin().startsWith("\u5185\u670d")) {
                buf.append(med.getAdmin().substring(0, 2));
                buf.append(" ");
                buf.append(med.getAdmin().substring(4));
            } else {
                buf.append(med.getAdmin());
            }
            buf.append(" x ");
            buf.append(med.getBundleNumber());
            if (med.getAdmin().startsWith("\u5185\u670d") && med.getAdmin().charAt(3) == '\u56de') {
                buf.append(" \u65e5\u5206");
            }
            buf.append("<xhtml:br/>");
            buf.append(System.getProperty("line.separator"));
            if (med.getAdminMemo() != null) {
                buf.append(med.getAdminMemo());
                buf.append("<xhtml:br/>");
                buf.append(System.getProperty("line.separator"));
            }
            if (med.getMemo() != null) {
                buf.append(med.getMemo());
                buf.append("<xhtml:br/>");
                buf.append(System.getProperty("line.separator"));
            }
        } else if (obj instanceof BundleDolphin) {
            ClaimItem[] items;
            BundleDolphin bundle = (BundleDolphin)obj;
            buf.append(bundle.getOrderName());
            buf.append("<xhtml:br/>");
            buf.append(System.getProperty("line.separator"));
            for (ClaimItem item : items = bundle.getClaimItem()) {
                buf.append("\u30fb");
                buf.append(item.getName());
                String number = item.getNumber();
                if (number != null) {
                    buf.append("\u3000");
                    buf.append(number);
                    if (item.getUnit() != null) {
                        buf.append(item.getUnit());
                    }
                }
                buf.append("<xhtml:br/>");
                buf.append(System.getProperty("line.separator"));
            }
            if (!bundle.getBundleNumber().equals("1")) {
                buf.append("X\u3000");
                buf.append(bundle.getBundleNumber());
                buf.append("<xhtml:br/>");
                buf.append(System.getProperty("line.separator"));
            }
            if (bundle.getAdminMemo() != null) {
                buf.append(bundle.getAdminMemo());
                buf.append("<xhtml:br/>");
                buf.append(System.getProperty("line.separator"));
            }
            if (bundle.getMemo() != null) {
                buf.append(bundle.getMemo());
                buf.append("<xhtml:br/>");
                buf.append(System.getProperty("line.separator"));
            }
        }
        return buf.toString();
    }

    String addQuote(String str) {
        StringBuilder buf = new StringBuilder();
        buf.append("\"");
        buf.append(str);
        buf.append("\"");
        return buf.toString();
    }
}

