/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.plugin.physicalpanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import open.dolphin.client.IChart;
import open.dolphin.client.IChartDocument;
import open.dolphin.delegater.remote.RemoteDocumentDelegater;
import open.dolphin.helper.DBTask;
import open.dolphin.helper.IChartCommandAccepter;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.infomodel.ObservationModel;
import open.dolphin.infomodel.PhysicalModel;
import open.dolphin.plugin.physicalpanel.PhysicalEditorPanel;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;
import open.dolphin.table.ObjectReflectTableModel;
import open.dolphin.table.OddEvenRowRenderer;
import org.jdesktop.layout.GroupLayout;

public class PhysicalPanel
extends JPanel
implements IChartDocument {
    public static final String TITLE = "\u8eab\u9577\u4f53\u91cd";
    private ObjectReflectTableModel<PhysicalModel> tableModel;
    private IChart parent;
    private String title = "\u8eab\u9577\u4f53\u91cd";
    private JScrollPane scroller;
    private JTable table;

    private void initComponents() {
        this.scroller = new JScrollPane();
        this.table = new JTable();
        this.setName("Form");
        this.setPreferredSize(new Dimension(242, 86));
        this.scroller.setName("scroller");
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[]{"\u8eab\u9577", "\u4f53\u91cd", "BMI", "\u6e2c\u5b9a\u65e5"}));
        this.table.setName("table");
        this.scroller.setViewportView(this.table);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.scroller, -1, 242, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.scroller, -1, 86, Short.MAX_VALUE));
    }

    @Override
    public IChartDocument.TYPE getType() {
        return IChartDocument.TYPE.Plugin;
    }

    public JTable getTable() {
        return this.table;
    }

    public PhysicalPanel(IChart parent) {
        this.parent = parent;
        this.initComponents();
        this.initCustomComponents();
        this.update();
    }

    public void clear() {
        this.tableModel.clear();
    }

    private void initCustomComponents() {
        String[] columnNames = new String[]{"\u8eab\u9577", "\u4f53\u91cd", "BMI", "\u6e2c\u5b9a\u65e5"};
        int startNumRows = 1;
        String[] methodNames = new String[]{"getHeight", "getWeight", "getBmi", "getIdentifiedFormatDate"};
        this.tableModel = new ObjectReflectTableModel(columnNames, startNumRows, methodNames, null);
        this.table.setModel(this.tableModel);
        this.table.setDefaultRenderer(Object.class, new OddEvenRowRenderer());
        this.table.getColumnModel().getColumn(2).setCellRenderer(new BMIRenderer());
        this.table.getSelectionModel().setSelectionMode(0);
        this.scroller.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
        int[] cellWidth = new int[]{50, 50, 50, 110};
        for (int i = 0; i < cellWidth.length; ++i) {
            TableColumn column = this.table.getColumnModel().getColumn(i);
            column.setPreferredWidth(cellWidth[i]);
        }
        this.table.addMouseListener(new MouseAdapter(){

            private void mabeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JPopupMenu pop = new JPopupMenu();
                    JMenuItem item = new JMenuItem("\u8ffd\u52a0");
                    pop.add(item);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            new PhysicalEditorPanel(PhysicalPanel.this);
                        }
                    });
                    final int row = PhysicalPanel.this.table.rowAtPoint(e.getPoint());
                    if (PhysicalPanel.this.tableModel.getObject(row) != null) {
                        pop.add(new JSeparator());
                        JMenuItem item2 = new JMenuItem("\u524a\u9664");
                        pop.add(item2);
                        item2.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                PhysicalPanel.this.delete(row);
                            }
                        });
                    }
                    pop.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.mabeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.mabeShowPopup(e);
            }
        });
    }

    private void scroll(boolean ascending) {
        int cnt = this.tableModel.getObjectCount();
        if (cnt > 0) {
            int row = 0;
            if (ascending) {
                row = cnt - 1;
            }
            Rectangle r = this.table.getCellRect(row, row, true);
            this.table.scrollRectToVisible(r);
        }
    }

    public void update() {
        int i;
        List listH = this.getParentContext().getKarte().getEntryCollection("height");
        List listW = this.getParentContext().getKarte().getEntryCollection("weight");
        ArrayList<PhysicalModel> list = new ArrayList<PhysicalModel>();
        if (listH != null && listW != null) {
            for (i = 0; i < listH.size(); ++i) {
                PhysicalModel h = (PhysicalModel)listH.get(i);
                String memo = h.getMemo();
                if (memo == null) {
                    memo = h.getIdentifiedDate();
                }
                PhysicalModel found = null;
                for (int j = 0; j < listW.size(); ++j) {
                    PhysicalModel w = (PhysicalModel)listW.get(j);
                    String memo2 = w.getMemo();
                    if (memo2 == null) {
                        memo2 = w.getIdentifiedDate();
                    }
                    if (!memo2.equals(memo)) continue;
                    found = w;
                    PhysicalModel m = new PhysicalModel();
                    m.setHeightId(h.getHeightId());
                    m.setHeight(h.getHeight());
                    m.setWeightId(w.getWeightId());
                    m.setWeight(w.getWeight());
                    m.setIdentifiedDate(h.getIdentifiedDate());
                    m.setMemo(memo);
                    list.add(m);
                    break;
                }
                if (found != null) {
                    listW.remove(found);
                    continue;
                }
                list.add(h);
            }
            if (listW.size() > 0) {
                for (i = 0; i < listW.size(); ++i) {
                    list.add((PhysicalModel)listW.get(i));
                }
            }
        } else if (listH != null) {
            for (i = 0; i < listH.size(); ++i) {
                list.add((PhysicalModel)listH.get(i));
            }
        } else if (listW != null) {
            for (i = 0; i < listW.size(); ++i) {
                list.add((PhysicalModel)listW.get(i));
            }
        }
        if (list.isEmpty()) {
            return;
        }
        boolean asc = GlobalVariables.getPreferences().getBoolean("docHistory.ascending", false);
        if (asc) {
            Collections.sort(list);
        } else {
            Collections.sort(list, Collections.reverseOrder());
        }
        this.tableModel.setObjectList(list);
        this.scroll(asc);
    }

    public void add(final PhysicalModel model) {
        ObservationModel observation;
        String confirmedStr = model.getIdentifiedDate();
        Date confirmed = ModelUtils.getDateTimeAsObject(confirmedStr + "T00:00:00");
        Date recorded = new Date();
        final ArrayList<ObservationModel> addList = new ArrayList<ObservationModel>(2);
        if (model.getHeight() != null) {
            observation = new ObservationModel();
            observation.setKarte(this.getParentContext().getKarte());
            observation.setCreator(GlobalVariables.getUserModel());
            observation.setObservation("PhysicalExam");
            observation.setPhenomenon("bodyHeight");
            observation.setValue(model.getHeight());
            observation.setUnit("cm");
            observation.setConfirmed(confirmed);
            observation.setStarted(confirmed);
            observation.setRecorded(recorded);
            observation.setStatus("F");
            addList.add(observation);
        }
        if (model.getWeight() != null) {
            observation = new ObservationModel();
            observation.setKarte(this.getParentContext().getKarte());
            observation.setCreator(GlobalVariables.getUserModel());
            observation.setObservation("PhysicalExam");
            observation.setPhenomenon("bodyWeight");
            observation.setValue(model.getWeight());
            observation.setUnit("Kg");
            observation.setConfirmed(confirmed);
            observation.setStarted(confirmed);
            observation.setRecorded(recorded);
            observation.setStatus("F");
            addList.add(observation);
        }
        if (addList.isEmpty()) {
            return;
        }
        DBTask<List<Long>> task = new DBTask<List<Long>>(this.getParentContext()){

            @Override
            protected List<Long> doInBackground() throws Exception {
                RemoteDocumentDelegater pdl = new RemoteDocumentDelegater();
                List<Long> ids = pdl.addObservations(addList);
                return ids;
            }

            @Override
            protected void succeeded(List<Long> result) {
                if (model.getHeight() != null && model.getWeight() != null) {
                    model.setHeightId(result.get(0));
                    model.setWeightId(result.get(1));
                } else if (model.getHeight() != null) {
                    model.setHeightId(result.get(0));
                } else {
                    model.setWeightId(result.get(0));
                }
                boolean asc = GlobalVariables.getPreferences().getBoolean("docHistory.ascending", false);
                if (asc) {
                    PhysicalPanel.this.tableModel.addRow(model);
                } else {
                    PhysicalPanel.this.tableModel.addRow(0, model);
                }
                PhysicalPanel.this.scroll(asc);
            }
        };
        task.execute();
    }

    public void delete(int row) {
        PhysicalModel model = this.tableModel.getObject(row);
        if (model == null) {
            return;
        }
        ArrayList<Long> list = new ArrayList<Long>(2);
        if (model.getHeight() != null) {
            list.add(new Long(model.getHeightId()));
        }
        if (model.getWeight() != null) {
            list.add(new Long(model.getWeightId()));
        }
        RemoteDocumentDelegater ddl = new RemoteDocumentDelegater();
        ddl.removeObservations(list);
        this.tableModel.deleteRow(row);
    }

    @Override
    public boolean itLayoutSaved() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public IChart getParentContext() {
        return this.parent;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void enter() {
    }

    @Override
    public boolean prepare() {
        return true;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void setDirty(boolean dirty) {
    }

    @Override
    public boolean dispatchChartCommand(IChartCommandAccepter.ChartCommand command) {
        return false;
    }

    @Override
    public List<JTabbedPane> getTabbedPanels() {
        return null;
    }

    @Override
    public boolean update(Object o) {
        return true;
    }

    protected class BMIRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int col) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, col);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setForeground(table.getForeground());
                if (row % 2 == 0) {
                    this.setBackground(GlobalSettings.getColors(GlobalSettings.Parts.EVEN));
                } else {
                    this.setBackground(GlobalSettings.getColors(GlobalSettings.Parts.ODD));
                }
            }
            PhysicalModel h = (PhysicalModel)PhysicalPanel.this.tableModel.getObject(row);
            Color fore = h != null && h.calcBmi() != null && h.calcBmi().compareTo("25") > 0 ? Color.RED : Color.BLACK;
            this.setForeground(fore);
            ((JLabel)component).setText(value == null ? "" : (String)value);
            if (h != null && h.getStandardWeight() != null) {
                this.setToolTipText("\u6a19\u6e96\u4f53\u91cd = " + h.getStandardWeight());
            }
            return component;
        }
    }
}

