/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;
import org.dcm4che.Implementation;
import org.dcm4che.dict.DictionaryFactory;
import org.dcm4che.dict.UIDDictionary;
import org.dcm4che.net.AAssociateRQAC;
import org.dcm4che.net.AsyncOpsWindow;
import org.dcm4che.net.CommonExtNegotiation;
import org.dcm4che.net.ExtNegotiation;
import org.dcm4che.net.PDUException;
import org.dcm4che.net.PresContext;
import org.dcm4che.net.RoleSelection;
import org.dcm4che.net.UserIdentityAC;
import org.dcm4che.net.UserIdentityRQ;
import org.dcm4cheri.net.AAbortImpl;
import org.dcm4cheri.net.AsyncOpsWindowImpl;
import org.dcm4cheri.net.CommonExtNegotiationImpl;
import org.dcm4cheri.net.ExtNegotiationImpl;
import org.dcm4cheri.net.PresContextImpl;
import org.dcm4cheri.net.RoleSelectionImpl;
import org.dcm4cheri.net.UnparsedPDUImpl;
import org.dcm4cheri.net.UserIdentityACImpl;
import org.dcm4cheri.net.UserIdentityRQImpl;
import org.dcm4cheri.util.StringUtils;

abstract class AAssociateRQACImpl
implements AAssociateRQAC {
    static final Logger log = Logger.getLogger(AAssociateRQACImpl.class);
    static UIDDictionary DICT = DictionaryFactory.getInstance().getDefaultUIDDictionary();
    private String appCtxUID = "1.2.840.10008.3.1.1.1";
    private int version = 1;
    private int maxLength = 16352;
    private String callingAET = "ANONYMOUS";
    private String calledAET = "ANONYMOUS";
    private String implClassUID = Implementation.getClassUID();
    private String implVers = Implementation.getVersionName();
    private AsyncOpsWindow asyncOpsWindow = null;
    protected UserIdentityRQ userIdentityRQ = null;
    protected UserIdentityAC userIdentityAC = null;
    protected final LinkedHashMap presCtxs = new LinkedHashMap();
    protected final LinkedHashMap roleSels = new LinkedHashMap();
    protected final LinkedHashMap extNegs = new LinkedHashMap();
    protected final LinkedHashMap commonExtNegs = new LinkedHashMap();
    private static final byte[] ZERO32 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    AAssociateRQACImpl() {
    }

    protected AAssociateRQACImpl init(UnparsedPDUImpl raw) throws PDUException {
        if (raw.buffer() == null) {
            throw new PDUException("PDU length exceeds supported maximum " + raw, new AAbortImpl(2, 0));
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(raw.buffer(), 6, raw.length());
        DataInputStream din = new DataInputStream(bin);
        try {
            this.version = din.readShort();
            din.readUnsignedByte();
            din.readUnsignedByte();
            this.calledAET = AAssociateRQACImpl.readASCII(din, 16).trim();
            this.callingAET = AAssociateRQACImpl.readASCII(din, 16).trim();
            if (din.skip(32L) != 32L) {
                throw new EOFException();
            }
            block8: while (din.available() > 0) {
                int itemType = din.readUnsignedByte();
                din.readUnsignedByte();
                int itemLen = din.readUnsignedShort();
                switch (itemType) {
                    case 16: {
                        this.appCtxUID = AAssociateRQACImpl.readASCII(din, itemLen);
                        continue block8;
                    }
                    case 32: 
                    case 33: {
                        if (itemType != this.pctype()) {
                            log.warn("Treat unexpected item[type=" + Integer.toHexString(itemType) + "H, length=" + itemLen + "] in received " + this.typeAsString() + " as item[type=" + Integer.toHexString(this.pctype()) + "H]");
                        }
                        this.addPresContext(new PresContextImpl(this.pctype(), din, itemLen));
                        continue block8;
                    }
                    case 80: {
                        this.readUserInfo(din, itemLen);
                        continue block8;
                    }
                }
                log.warn("Skip unrecognized item[type=" + Integer.toHexString(itemType) + "H, length=" + itemLen + "] in received " + this.typeAsString());
                din.skipBytes(itemLen);
            }
        }
        catch (PDUException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PDUException("Failed to parse " + raw, e, new AAbortImpl(2, 0));
        }
        return this;
    }

    public final int getProtocolVersion() {
        return this.version;
    }

    public final void setProtocolVersion(int version) {
        this.version = version;
    }

    public String getCalledAET() {
        return this.calledAET;
    }

    public String getCallingAET() {
        return this.callingAET;
    }

    public void setCalledAET(String aet) {
        this.calledAET = StringUtils.checkAET(aet);
    }

    public void setCallingAET(String aet) {
        this.callingAET = StringUtils.checkAET(aet);
    }

    public final String getApplicationContext() {
        return this.appCtxUID;
    }

    public final void setApplicationContext(String appCtxUID) {
        appCtxUID = StringUtils.checkUID(appCtxUID);
    }

    public final int nextPCID() {
        int c = this.presCtxs.size();
        if (c == 128) {
            return -1;
        }
        int retval = c << 1 | 1;
        while (this.presCtxs.containsKey(new Integer(retval))) {
            retval = (retval + 2) % 256;
        }
        return retval;
    }

    public final PresContext addPresContext(PresContext presCtx) {
        if (((PresContextImpl)presCtx).type() != this.pctype()) {
            throw new IllegalArgumentException("wrong type of " + presCtx);
        }
        return this.presCtxs.put(new Integer(presCtx.pcid()), presCtx);
    }

    public final PresContext removePresContext(int pcid) {
        return (PresContext)this.presCtxs.remove(new Integer(pcid));
    }

    public final PresContext getPresContext(int pcid) {
        return (PresContext)this.presCtxs.get(new Integer(pcid));
    }

    public final Collection listPresContext() {
        return this.presCtxs.values();
    }

    public final void clearPresContext() {
        this.presCtxs.clear();
    }

    public final String getImplClassUID() {
        return this.implClassUID;
    }

    public final void setImplClassUID(String uid) {
        this.implClassUID = StringUtils.checkUID(uid);
    }

    public final String getImplVersionName() {
        return this.implVers;
    }

    public final void setImplVersionName(String name) {
        this.implVers = name != null ? StringUtils.checkAET(name) : null;
    }

    public final int getMaxPDULength() {
        return this.maxLength;
    }

    public final void setMaxPDULength(int maxLength) {
        if (maxLength < 0) {
            throw new IllegalArgumentException("maxLength:" + maxLength);
        }
        this.maxLength = maxLength;
    }

    public final AsyncOpsWindow getAsyncOpsWindow() {
        return this.asyncOpsWindow;
    }

    public final void setAsyncOpsWindow(AsyncOpsWindow aow) {
        this.asyncOpsWindow = aow;
    }

    public final RoleSelection removeRoleSelection(String uid) {
        return (RoleSelection)this.roleSels.remove(uid);
    }

    public final RoleSelection getRoleSelection(String uid) {
        return (RoleSelection)this.roleSels.get(uid);
    }

    public Collection listRoleSelections() {
        return this.roleSels.values();
    }

    public void clearRoleSelections() {
        this.roleSels.clear();
    }

    public final ExtNegotiation removeExtNegotiation(String uid) {
        return (ExtNegotiation)this.extNegs.remove(uid);
    }

    public final ExtNegotiation getExtNegotiation(String uid) {
        return (ExtNegotiation)this.extNegs.get(uid);
    }

    public Collection listExtNegotiations() {
        return this.extNegs.values();
    }

    public void clearExtNegotiations() {
        this.extNegs.clear();
    }

    static String readASCII(DataInputStream in, int len) throws IOException {
        byte[] b = new byte[len];
        in.readFully(b);
        while (len > 0 && b[len - 1] == 0) {
            --len;
        }
        return new String(b, 0, len, "US-ASCII");
    }

    public RoleSelection addRoleSelection(RoleSelection roleSel) {
        return this.roleSels.put(roleSel.getSOPClassUID(), roleSel);
    }

    public ExtNegotiation addExtNegotiation(ExtNegotiation extNeg) {
        return this.extNegs.put(extNeg.getSOPClassUID(), extNeg);
    }

    public CommonExtNegotiation addCommonExtNegotiation(CommonExtNegotiation extNeg) {
        return this.commonExtNegs.put(extNeg.getSOPClassUID(), extNeg);
    }

    private void readUserInfo(DataInputStream din, int len) throws IOException, PDUException {
        int diff = len - din.available();
        if (diff != 0) {
            throw new PDUException("User info item length=" + len + " mismatch PDU length (diff=" + diff + ")", new AAbortImpl(2, 6));
        }
        block11: while (din.available() > 0) {
            int subItemType = din.readUnsignedByte();
            din.readUnsignedByte();
            int itemLen = din.readUnsignedShort();
            switch (subItemType) {
                case 81: {
                    if (itemLen != 4) {
                        throw new PDUException("Illegal length of Maximum length sub-item: " + itemLen, new AAbortImpl(2, 6));
                    }
                    this.maxLength = din.readInt();
                    continue block11;
                }
                case 82: {
                    this.implClassUID = AAssociateRQACImpl.readASCII(din, itemLen);
                    continue block11;
                }
                case 83: {
                    this.asyncOpsWindow = new AsyncOpsWindowImpl(din, itemLen);
                    continue block11;
                }
                case 84: {
                    this.addRoleSelection(new RoleSelectionImpl(din, itemLen));
                    continue block11;
                }
                case 85: {
                    this.implVers = AAssociateRQACImpl.readASCII(din, itemLen);
                    continue block11;
                }
                case 86: {
                    this.addExtNegotiation(new ExtNegotiationImpl(din, itemLen));
                    continue block11;
                }
                case 87: {
                    this.addCommonExtNegotiation(new CommonExtNegotiationImpl(din, itemLen));
                    continue block11;
                }
                case 88: {
                    this.userIdentityRQ = new UserIdentityRQImpl(din, itemLen);
                    continue block11;
                }
                case 89: {
                    this.userIdentityAC = new UserIdentityACImpl(din, itemLen);
                    continue block11;
                }
            }
            log.warn("Skip unrecognized user sub-item [type=" + Integer.toHexString(subItemType) + "H, length=" + itemLen + "] in received " + this.typeAsString());
            din.skipBytes(itemLen);
        }
    }

    protected abstract int type();

    protected abstract int pctype();

    private void writeAE(DataOutputStream dout, String aet) throws IOException {
        dout.writeBytes(aet);
        for (int n = aet.length(); n < 16; ++n) {
            dout.write(32);
        }
    }

    public final void writeTo(OutputStream out) throws IOException {
        MyByteArrayOutputStream bout = new MyByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.writeShort(this.version);
        dout.write(0);
        dout.write(0);
        this.writeAE(dout, this.calledAET);
        this.writeAE(dout, this.callingAET);
        dout.write(ZERO32);
        dout.write(16);
        dout.write(0);
        dout.writeShort(this.appCtxUID.length());
        dout.writeBytes(this.appCtxUID);
        Iterator it = this.presCtxs.values().iterator();
        while (it.hasNext()) {
            ((PresContextImpl)it.next()).writeTo(dout);
        }
        this.writeUserInfo(dout);
        bout.writeTo(this.type(), out);
    }

    private void writeUserInfo(DataOutputStream dout) throws IOException {
        dout.write(80);
        dout.write(0);
        dout.writeShort(this.getUserInfoLength());
        dout.write(81);
        dout.write(0);
        dout.writeShort(4);
        dout.writeInt(this.maxLength);
        dout.write(82);
        dout.write(0);
        dout.writeShort(this.implClassUID.length());
        dout.writeBytes(this.implClassUID);
        if (this.asyncOpsWindow != null) {
            ((AsyncOpsWindowImpl)this.asyncOpsWindow).writeTo(dout);
        }
        Iterator it = this.roleSels.values().iterator();
        while (it.hasNext()) {
            ((RoleSelectionImpl)it.next()).writeTo(dout);
        }
        if (this.implVers != null) {
            dout.write(85);
            dout.write(0);
            dout.writeShort(this.implVers.length());
            dout.writeBytes(this.implVers);
        }
        it = this.extNegs.values().iterator();
        while (it.hasNext()) {
            ((ExtNegotiationImpl)it.next()).writeTo(dout);
        }
        it = this.commonExtNegs.values().iterator();
        while (it.hasNext()) {
            ((CommonExtNegotiationImpl)it.next()).writeTo(dout);
        }
        if (this.userIdentityRQ != null) {
            ((UserIdentityRQImpl)this.userIdentityRQ).writeTo(dout);
        }
        if (this.userIdentityAC != null) {
            ((UserIdentityACImpl)this.userIdentityAC).writeTo(dout);
        }
    }

    private int getUserInfoLength() {
        Object en;
        int retval = 12 + this.implClassUID.length();
        if (this.asyncOpsWindow != null) {
            retval += 8;
        }
        Iterator it = this.roleSels.values().iterator();
        while (it.hasNext()) {
            RoleSelectionImpl rs = (RoleSelectionImpl)it.next();
            retval += 4 + rs.length();
        }
        if (this.implVers != null) {
            retval += 4 + this.implVers.length();
        }
        it = this.extNegs.values().iterator();
        while (it.hasNext()) {
            en = (ExtNegotiationImpl)it.next();
            retval += 4 + ((ExtNegotiationImpl)en).length();
        }
        it = this.commonExtNegs.values().iterator();
        while (it.hasNext()) {
            en = (CommonExtNegotiationImpl)it.next();
            retval += 4 + ((CommonExtNegotiationImpl)en).length();
        }
        if (this.userIdentityRQ != null) {
            retval += 4 + ((UserIdentityRQImpl)this.userIdentityRQ).length();
        }
        if (this.userIdentityAC != null) {
            retval += 4 + ((UserIdentityACImpl)this.userIdentityAC).length();
        }
        return retval;
    }

    protected abstract String typeAsString();

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean verbose) {
        return this.toStringBuffer(new StringBuffer(), verbose).toString();
    }

    final StringBuffer toStringBuffer(StringBuffer sb, boolean verbose) {
        sb.append(this.typeAsString()).append("\n\tappCtxName:\t").append(DICT.lookup(this.appCtxUID)).append("\n\timplClass:\t").append(this.implClassUID).append("\n\timplVersion:\t").append(this.implVers).append("\n\tcalledAET:\t").append(this.calledAET).append("\n\tcallingAET:\t").append(this.callingAET).append("\n\tmaxPDULen:\t").append(this.maxLength).append("\n\tasyncOpsWindow:\t");
        if (this.asyncOpsWindow != null) {
            sb.append("maxOpsInvoked=").append(this.asyncOpsWindow.getMaxOpsInvoked()).append(", maxOpsPerformed=").append(this.asyncOpsWindow.getMaxOpsPerformed());
        }
        if (verbose) {
            Iterator it = this.presCtxs.values().iterator();
            while (it.hasNext()) {
                this.append((PresContext)it.next(), sb);
            }
            it = this.roleSels.values().iterator();
            while (it.hasNext()) {
                sb.append("\n\t").append(it.next());
            }
            it = this.extNegs.values().iterator();
            while (it.hasNext()) {
                sb.append("\n\t").append(it.next());
            }
            it = this.commonExtNegs.values().iterator();
            while (it.hasNext()) {
                sb.append("\n\t").append(it.next());
            }
        } else {
            this.appendPresCtxSummary(sb);
            sb.append("\n\troleSel:\t#").append(this.roleSels.size()).append("\n\textNego:\t#").append(this.extNegs.size()).append("\n\tcommonExtNego:\t#").append(this.commonExtNegs.size());
        }
        return sb;
    }

    protected abstract void append(PresContext var1, StringBuffer var2);

    protected abstract void appendPresCtxSummary(StringBuffer var1);

    private static final class MyByteArrayOutputStream
    extends ByteArrayOutputStream {
        MyByteArrayOutputStream() {
            super(4096);
            this.write(0);
            this.write(0);
            this.write(0);
            this.write(0);
            this.write(0);
            this.write(0);
        }

        void writeTo(int type, OutputStream out) throws IOException {
            int len = this.count - 6;
            this.buf[0] = (byte)type;
            this.buf[1] = 0;
            this.buf[2] = (byte)(len >> 24);
            this.buf[3] = (byte)(len >> 16);
            this.buf[4] = (byte)(len >> 8);
            this.buf[5] = (byte)(len >> 0);
            out.write(this.buf, 0, this.count);
        }
    }
}

