/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.srom.Patient;

final class PatientImpl
implements Patient {
    private final String patientID;
    private final String patientName;
    private final Patient.Sex patientSex;
    private final Long patientBirthDate;

    public PatientImpl(String patientID, String patientName, Patient.Sex patientSex, Date patientBirthDate) {
        this.patientID = patientID == null ? "" : patientID;
        this.patientName = patientName == null ? "" : patientName;
        this.patientSex = patientSex;
        this.patientBirthDate = patientBirthDate != null ? new Long(patientBirthDate.getTime()) : null;
    }

    public PatientImpl(Dataset ds) throws DcmValueException {
        this(ds.getString(0x100020), ds.getString(0x100010), Patient.Sex.valueOf(ds.getString(0x100040)), ds.getDate(0x100030));
    }

    public final String getPatientID() {
        return this.patientID;
    }

    public final String getPatientName() {
        return this.patientName;
    }

    public final Patient.Sex getPatientSex() {
        return this.patientSex;
    }

    public final Date getPatientBirthDate() {
        return this.patientBirthDate != null ? new Date(this.patientBirthDate) : null;
    }

    public int hashCode() {
        return this.patientID.hashCode() + this.patientName.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Patient)) {
            return false;
        }
        Patient p = (Patient)o;
        return this.patientID.equals(p.getPatientID()) && this.patientName.equals(p.getPatientName());
    }

    public String toString() {
        return "Patient[" + this.patientName + ",ID=" + this.patientID + "]";
    }

    public void toDataset(Dataset ds) {
        ds.putLO(0x100020, this.patientID);
        ds.putPN(0x100010, this.patientName);
        ds.putCS(0x100040, this.patientSex != null ? this.patientSex.toString() : null);
        ds.putDA(0x100030, this.getPatientBirthDate());
    }
}

