/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.editor.admin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import open.dolphin.client.AutoRomanListener;
import open.dolphin.client.MasterRenderer;
import open.dolphin.client.TaskTimerMonitor;
import open.dolphin.dao.SqlDaoFactory;
import open.dolphin.dao.SqlMasterDao;
import open.dolphin.infomodel.AdminEntry;
import open.dolphin.infomodel.MasterItem;
import open.dolphin.log.LogWriter;
import open.dolphin.order.AbstractMasterPanel;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalSettings;
import open.dolphin.table.ObjectTableModel;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskMonitor;

public class AdminMasterPanel
extends AbstractMasterPanel {
    public static final String ADMIN_PROP = "adminProp";
    private static final String[] COLUMN_NAMES = new String[]{"\u30b3\u30fc\u30c9", "\u540d \u79f0"};
    private static final String CUSTOM_CODE = "001";
    private static final String[] ADMIN_CATEGORY = new String[]{"\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044", "\u5185\u670d\uff11\u56de\u7b49(100)", "\u5185\u670d\uff12\u56de\u7b49(200)", "\u5185\u670d\uff13\u56de\u7b49(300)", "\u5185\u670d\uff14\u56de\u7b49(400)", "\u70b9\u773c\u7b49(500,700)", "\u5857\u5e03\u7b49(600)", "\u9813\u7528\u7b49(800)", "\u5438\u5165\u7b49(900)", "\u5168\u3066"};
    private static final String[] ADMIN_CODE_RANGE = new String[]{"", "0010001", "0010002", "0010003", "0010004", "0010005 0010007", "0010006", "0010008", "0010009", "001"};
    private JComboBox adminCombo;
    private JTextField customCode;
    private JScrollPane jScrollPane1;
    private JTable table;

    public AdminMasterPanel(String master) {
        super(master);
    }

    @Override
    protected void initialize() {
        this.initComponents();
        int index = 0;
        this.adminCombo = new JComboBox<String>(ADMIN_CATEGORY);
        this.adminCombo.setToolTipText("\u62ec\u5f27\u5185\u306f\u30b3\u30fc\u30c9\u306e\u756a\u53f7\u53f0\u3092\u8868\u3057\u307e\u3059\u3002");
        this.adminCombo.setSelectedIndex(index);
        this.adminCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    int index = AdminMasterPanel.this.adminCombo.getSelectedIndex();
                    String code = ADMIN_CODE_RANGE[index];
                    if (!code.equals("")) {
                        AdminMasterPanel.this.fetchAdministration(code);
                    }
                }
            }
        });
        this.tableModel = new ObjectTableModel(COLUMN_NAMES, 20){
            private static final long serialVersionUID = 8084360322119845887L;

            public Class getColumnClass(int col) {
                return AdminEntry.class;
            }
        };
        this.table.setModel(this.tableModel);
        this.table.setSelectionMode(0);
        this.table.setRowSelectionAllowed(true);
        TableColumn column = null;
        int[] width = new int[]{50, 250};
        int len = width.length;
        for (int i = 0; i < len; ++i) {
            column = this.table.getColumnModel().getColumn(i);
            column.setPreferredWidth(width[i]);
        }
        this.table.setDefaultRenderer(AdminEntry.class, new AdminMasterRenderer());
        JPanel key = new JPanel(new FlowLayout(0, 7, 5));
        key.add(this.findLabel);
        key.add(new JLabel("\u7528\u6cd5:"));
        key.add(this.keywordField);
        key.add(this.isForwordCheckBox);
        key.setBorder(BorderFactory.createTitledBorder("\u7528\u6cd5\u3067\u691c\u7d22"));
        JPanel ctp = new JPanel(new FlowLayout(0, 5, 5));
        ctp.add(new JLabel("\u30ab\u30c6\u30b4\u30ea:"));
        ctp.add(this.adminCombo);
        ctp.setBorder(BorderFactory.createTitledBorder("\u30ab\u30c6\u30b4\u30ea\u3067\u691c\u7d22"));
        this.customCode = new JTextField(7);
        this.customCode.setToolTipText("\u81ea\u9662\u30de\u30b9\u30bf\u306e\u30b3\u30fc\u30c9\uff08\u756a\u53f0\uff09\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        this.customCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String text = AdminMasterPanel.this.customCode.getText().trim();
                if (!text.equals("")) {
                    StringTokenizer st = new StringTokenizer(text, " ");
                    StringBuilder sb = new StringBuilder();
                    int cnt = 0;
                    while (st.hasMoreTokens()) {
                        if (cnt != 0) {
                            sb.append(" ");
                        }
                        sb.append(AdminMasterPanel.CUSTOM_CODE);
                        sb.append(st.nextToken());
                        ++cnt;
                    }
                    text = sb.toString();
                    AdminMasterPanel.this.fetchAdministration(text);
                }
            }
        });
        this.customCode.addFocusListener(AutoRomanListener.getInstance());
        JPanel customP = new JPanel(new FlowLayout(0, 5, 5));
        customP.add(new JLabel("\u81ea\u9662\u30b3\u30fc\u30c9: 001"));
        customP.add(this.customCode);
        customP.setBorder(BorderFactory.createTitledBorder("\u30b3\u30fc\u30c9\u3067\u691c\u7d22"));
        JPanel top = new JPanel();
        top.setLayout(new BoxLayout(top, 0));
        top.add(key);
        top.add(Box.createHorizontalStrut(11));
        top.add(ctp);
        top.add(Box.createHorizontalGlue());
        top.add(customP);
        JScrollPane scroller = new JScrollPane(this.table, 20, 31);
        scroller.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
        this.setLayout(new BorderLayout(0, 11));
        this.add((Component)top, "North");
        this.add((Component)scroller, "Center");
    }

    private void fetchAdministration(final String category) {
        LogWriter.debug(AdminMasterPanel.class, "master = " + this.master);
        LogWriter.debug(AdminMasterPanel.class, "category = " + category);
        if (category == null) {
            return;
        }
        final SqlMasterDao dao = (SqlMasterDao)SqlDaoFactory.create("dao.master");
        ApplicationContext appCtx = GlobalConstants.getApplicationContext();
        Application app = appCtx.getApplication();
        Task<Object, Void> task = new Task<Object, Void>(app){

            protected Object doInBackground() throws Exception {
                List<AdminEntry> result = dao.getAdminByCategory(category);
                return result;
            }

            protected void succeeded(Object result) {
                LogWriter.debug(AdminMasterPanel.class, "Task succeeded");
                AdminMasterPanel.this.processResult(dao.isNoError(), result, dao.getErrorMessage());
            }

            protected void cancelled() {
                LogWriter.debug(AdminMasterPanel.class, "Task cancelled");
            }

            protected void failed(Throwable cause) {
                LogWriter.warn(AdminMasterPanel.class, cause.getMessage());
            }

            protected void interrupted(InterruptedException e) {
                LogWriter.warn(AdminMasterPanel.class, e.getMessage());
            }
        };
        TaskMonitor taskMonitor = appCtx.getTaskMonitor();
        String message = "\u7528\u6cd5\u691c\u7d22";
        String note = category + "\u3092\u691c\u7d22\u3057\u3066\u3044\u307e\u3059...";
        Window c = SwingUtilities.getWindowAncestor(this);
        TaskTimerMonitor w = new TaskTimerMonitor((Task)task, taskMonitor, c, message, note, 200, 60000);
        taskMonitor.addPropertyChangeListener((PropertyChangeListener)w);
        appCtx.getTaskService().execute((Task)task);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.jScrollPane1.setName("jScrollPane1");
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.setName("table");
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AdminMasterPanel.this.tableMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.table);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 375, -2).addContainerGap(13, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(95, Short.MAX_VALUE).addComponent(this.jScrollPane1, -2, 102, -2).addContainerGap()));
    }

    private void tableMouseClicked(MouseEvent evt) {
        int row;
        AdminEntry o;
        if (evt.getClickCount() == 2 && (o = (AdminEntry)this.tableModel.getObject(row = this.table.getSelectedRow())) != null) {
            MasterItem item = new MasterItem(3, o);
            item.setSstKijunCdSet(o.getSstKijunCdSet());
            this.boundSupport.firePropertyChange("selectedItemProp", null, item);
        }
    }

    protected final class AdminMasterRenderer
    extends MasterRenderer {
        private static final long serialVersionUID = 8567079934909643686L;
        private final int CODE_COLUMN = 0;
        private final int NAME_COLUMN = 1;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int col) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, col);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            JLabel label = (JLabel)c;
            if (value != null && value instanceof AdminEntry) {
                AdminEntry entry = (AdminEntry)value;
                switch (col) {
                    case 0: {
                        label.setText(entry.getCode());
                        break;
                    }
                    case 1: {
                        label.setText(entry.getName());
                    }
                }
            } else {
                label.setBackground(Color.white);
                label.setText(value == null ? "" : value.toString());
            }
            return c;
        }
    }
}

