/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.pvtclientserver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import open.dolphin.client.ModelSender;
import open.dolphin.infomodel.PatientVisitModel;
import open.dolphin.pvtclientserver.IHandler;
import open.dolphin.pvtclientserver.PVTBuilder;
import open.dolphin.utils.DebugDump;

public class IOHandler
implements IHandler {
    private static final int BUFFER_SIZE = 8192;
    private static final int EOT = 4;
    private static final int ACK = 6;
    private byte[] data = new byte[81920];
    private int length;

    @Override
    public void handle(SelectionKey key) throws ClosedChannelException, IOException {
        if (key.isReadable()) {
            try {
                this.read(key);
            }
            catch (SQLException ex) {
                Logger.getLogger(IOHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void read(SelectionKey key) throws ClosedChannelException, IOException, SQLException {
        SocketChannel channel = (SocketChannel)key.channel();
        ByteBuffer buffer = ByteBuffer.allocate(8192);
        buffer.clear();
        int len = channel.read(buffer);
        if (len < 0) {
            channel.close();
            String pvtXml = new String(this.data, 0, this.length - 1, "UTF8");
            DebugDump.dump("receivePvt.log", pvtXml);
            BufferedReader r = new BufferedReader(new StringReader(pvtXml));
            PVTBuilder builder = new PVTBuilder();
            builder.parse(r);
            PatientVisitModel model = builder.getProduct();
            ModelSender.getInstance().offer(model);
        } else {
            buffer.flip();
            buffer.get(this.data, this.length, len);
            this.length += len;
            if (buffer.get(len - 1) == 4) {
                ByteBuffer ackBuf2 = ByteBuffer.wrap(new byte[]{6});
                channel.write(ackBuf2);
            }
        }
    }
}

