/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.DataElement;
import fr.apteryx.imageio.dicom.DataSet;
import fr.apteryx.imageio.dicom.DicomException;
import fr.apteryx.imageio.dicom.DicomMetadata;
import fr.apteryx.imageio.dicom.DicomWarningListener;
import fr.apteryx.imageio.dicom.PeerAE;
import fr.apteryx.imageio.dicom.QueryRetrieveSCP;
import fr.apteryx.imageio.dicom.StorageSCU;
import fr.apteryx.imageio.dicom.Tag;
import fr.apteryx.imageio.dicom.TransferSyntax;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.Node;

public class DicomWriter
extends ImageWriter {
    private static final TransferSyntax[] DEFAULT_PREFERRED_TS = TransferSyntax.ALWAYS_SUPPORTED_OUTPUT;
    public static final int NORMALIZE_NOT_RAW = 0;
    public static final int NORMALIZE_ALL = 1;
    public static final int NORMALIZE_NONE = 2;
    private int normalization = 0;
    private DicomMetadata md;
    private ArrayList sequence;
    final DicomWarningListener wl;
    TransferSyntax[] preferredTS = DEFAULT_PREFERRED_TS;
    private float JPEGQuality = 0.75f;
    private double JPEG2000EncodingRate = 2.0;

    DicomWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
        this.wl = new DicomWarningListener(){

            public void warning(int n, String string, String string2) {
                DicomWriter.this.processWarningOccurred(n, DicomException.localize(string) + ": " + string2);
            }

            public void warning(String string, String string2) {
                this.warning(0, string, string2);
            }
        };
    }

    public boolean canWriteRasters() {
        return true;
    }

    public void setRawMode(boolean bl) {
    }

    public void setNormalization(int n) {
        this.normalization = n;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return new DicomMetadata();
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        Node node;
        if (iIOMetadata == null) {
            return null;
        }
        if (iIOMetadata instanceof DicomMetadata) {
            DicomMetadata dicomMetadata = (DicomMetadata)iIOMetadata;
            if (dicomMetadata.obj.transferSyntax != null) {
                return dicomMetadata;
            }
            DataSet dataSet = new DataSet();
            Iterator iterator = dicomMetadata.obj.ds.values().iterator();
            while (iterator.hasNext()) {
                DataElement dataElement = (DataElement)iterator.next();
                if (dataElement.tag == 2145386512 || Tag.getElementNumber(dataElement.tag) == 0) continue;
                dataSet.add(dataElement);
            }
            return new DicomMetadata(dataSet, dicomMetadata.obj.sopClass, dicomMetadata.obj.sopInstance, dicomMetadata.obj.transferSyntax);
        }
        if (iIOMetadata.isStandardMetadataFormatSupported() && (node = iIOMetadata.getAsTree("javax_imageio_1.0")) != null) {
            try {
                DicomMetadata dicomMetadata = new DicomMetadata(new DataSet(), null, null, null);
                dicomMetadata.mergeTree("javax_imageio_1.0", node);
                return dicomMetadata;
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {
                // empty catch block
            }
        }
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    private void updateFromImage(DicomMetadata dicomMetadata, IIOImage iIOImage) throws DicomException {
        if (iIOImage.hasRaster()) {
            Raster raster = iIOImage.getRaster();
            dicomMetadata.updateFromImage(raster.getWidth(), raster.getHeight(), raster.getSampleModel(), null);
        } else {
            RenderedImage renderedImage = iIOImage.getRenderedImage();
            dicomMetadata.updateFromImage(renderedImage.getWidth(), renderedImage.getHeight(), renderedImage.getSampleModel(), renderedImage.getColorModel());
        }
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.clearAbortRequest();
        DicomMetadata dicomMetadata = this.getMD(iIOMetadata);
        if (dicomMetadata.obj.transferSyntax != null && iIOImage != null) {
            throw new DicomException("ApplicationError", "Cannot write IIOImage when raw values are present");
        }
        if (iIOImage != null) {
            this.updateFromImage(dicomMetadata, iIOImage);
            dicomMetadata.obj.ds.add(2145386512, iIOImage);
        }
        this.normalizeAndWrite(dicomMetadata);
    }

    private void normalizeAndWrite(DicomMetadata dicomMetadata) throws IOException {
        switch (this.normalization) {
            case 1: {
                dicomMetadata.normalize(this.wl);
                break;
            }
            case 0: {
                if (dicomMetadata.obj.transferSyntax != null) break;
                dicomMetadata.normalize(this.wl);
            }
        }
        if (this.output instanceof ImageOutputStream) {
            TransferSyntax transferSyntax = null;
            if (dicomMetadata.obj.transferSyntax == null) {
                transferSyntax = dicomMetadata.obj.selectSuitableTS(this.preferredTS);
                if (transferSyntax == null) {
                    throw new DicomException("ApplicationError", "The selected tranfer syntaxes cannot be used to encode this object");
                }
                dicomMetadata.obj.updateFromTransferSyntax(transferSyntax);
            }
            dicomMetadata.obj.write((ImageOutputStream)this.output, transferSyntax, this);
        } else if (this.output instanceof StorageSCU) {
            ((StorageSCU)this.output).store(dicomMetadata.obj, this, this.wl);
        } else if (this.output instanceof QueryRetrieveSCP.Operation) {
            ((QueryRetrieveSCP.Operation)this.output).sendObject(dicomMetadata.obj, this, this.wl);
        } else {
            throw new IllegalStateException("Output not set");
        }
    }

    public boolean canWriteSequence() {
        return true;
    }

    public boolean canRemoveImage(int n) {
        return this.sequence != null && this.sequence.size() > n;
    }

    public boolean canInsertImage(int n) {
        return this.sequence != null && this.sequence.size() > n;
    }

    public void prepareWriteSequence(IIOMetadata iIOMetadata) {
        this.clearAbortRequest();
        this.md = this.getMD(iIOMetadata);
        this.sequence = new ArrayList();
    }

    public void abort() {
        super.abort();
        this.sequence = null;
        this.md = null;
    }

    public void writeToSequence(IIOImage iIOImage, ImageWriteParam imageWriteParam) throws DicomException {
        if (this.md == null) {
            throw new DicomException("ApplicationError", "prepareWriteSequence were not called");
        }
        if (this.md.obj.transferSyntax != null) {
            throw new DicomException("ApplicationError", "Cannot writetoSequence when raw values are present");
        }
        if (this.sequence.isEmpty()) {
            this.updateFromImage(this.md, iIOImage);
        }
        this.sequence.add(iIOImage);
    }

    public void removeImage(int n) {
        this.sequence.remove(n);
    }

    public void writeInsert(int n, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws DicomException {
        if (this.md == null) {
            throw new DicomException("ApplicationError", "prepareWriteSequence were not called");
        }
        if (this.md.obj.transferSyntax != null) {
            throw new DicomException("ApplicationError", "Cannot writeInsert when raw values are present");
        }
        if (this.sequence.isEmpty()) {
            this.updateFromImage(this.md, iIOImage);
        }
        if (n < 0) {
            this.sequence.add(iIOImage);
        } else {
            this.sequence.add(n, iIOImage);
        }
    }

    public void endWriteSequence() throws IOException {
        if (this.sequence.size() > 1) {
            this.md.obj.ds.add(2145386512, this.sequence);
        } else if (this.sequence.size() == 1) {
            this.md.obj.ds.add(2145386512, this.sequence.get(0));
        }
        this.normalizeAndWrite(this.md);
        this.sequence = null;
        this.md = null;
    }

    private DicomMetadata getMD(IIOMetadata iIOMetadata) {
        return (DicomMetadata)(iIOMetadata == null ? this.getDefaultStreamMetadata(null) : this.convertStreamMetadata(iIOMetadata, null));
    }

    public void dispose() {
        super.dispose();
        this.md = null;
        this.sequence = null;
    }

    public void setOutput(Object object) {
        if (object instanceof PeerAE) {
            object = new StorageSCU((PeerAE)object);
        }
        super.setOutput(object);
    }

    public void setTransferSyntaxes(String[] stringArray) {
        this.preferredTS = stringArray == null || stringArray.length == 0 ? DEFAULT_PREFERRED_TS : TransferSyntax.intersectWithSupported(stringArray);
    }

    public void setTransferSyntax(String string) {
        String[] stringArray;
        if (string == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string;
        }
        this.setTransferSyntaxes(stringArray);
    }

    public void setJPEGQuality(float f) {
        this.JPEGQuality = f;
    }

    public float getJPEGQuality() {
        return this.JPEGQuality;
    }

    public void setJPEG2000EncodingRate(double d) {
        this.JPEG2000EncodingRate = d;
    }

    public double getJPEG2000EncodingRate() {
        return this.JPEG2000EncodingRate;
    }
}

