/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.image;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Stack;
import javax.imageio.stream.ImageInputStream;
import org.dcm4che.image.PixelDataDescription;
import org.dcm4che.image.PixelDataReader;

public class PixelDataReaderImpl
implements PixelDataReader {
    private final int sampleMaskLS;
    private final int sampleMaskRS;
    private final int hOvlMask;
    private final int hOvlMaskRS;
    private final int lOvlMask;
    private final ImageInputStream in;
    private int[][][] data;
    private final long len = -1L;
    private final long initialReadPos;
    private final PixelDataStreamMark initialStreamState;
    private int bOff;
    private int bMask;
    private int cw;
    private long samplesPassed;
    private final Stack markStack = new Stack();
    private final PixelDataDescription pdDesc;
    private final int cols;
    private final int rows;
    private final int nf;
    private final int frameSize;
    private final int size;
    private final int samplesPerFrame;
    private final int ba;
    private final int bs;
    private final int hb;
    private final int spp;
    private final boolean signed;
    private final boolean byPlane;
    private final String pmi;
    private final ByteOrder byteOrder;
    private final int pixelDataVr;

    PixelDataReaderImpl(PixelDataDescription desc, ImageInputStream in) {
        this.pdDesc = desc;
        this.cols = desc.getCols();
        this.rows = desc.getRows();
        this.nf = desc.getNumberOfFrames();
        this.frameSize = desc.getFrameSize();
        this.size = desc.getSize();
        this.samplesPerFrame = desc.getSamplesPerFrame();
        this.ba = desc.getBitsAllocated();
        this.bs = desc.getBitsStored();
        this.hb = desc.getHighBit();
        this.spp = desc.getSamplesPerPixel();
        this.signed = desc.isSigned();
        this.byPlane = desc.isByPlane();
        this.pmi = desc.getPmi();
        this.byteOrder = desc.getByteOrder();
        this.pixelDataVr = desc.getPixelDataVr();
        this.data = null;
        try {
            this.initialReadPos = in.getStreamPosition();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not determine current position in stream");
        }
        this.bOff = 16;
        this.samplesPassed = 0L;
        this.initialStreamState = new PixelDataStreamMark(this.bOff, this.cw, this.bMask, 0L);
        this.in = in;
        this.sampleMaskLS = 32 - this.hb - 1;
        this.sampleMaskRS = 32 - this.bs;
        this.hOvlMask = (1 << this.ba) - (1 << this.hb + 1);
        this.hOvlMaskRS = this.bs;
        this.lOvlMask = (1 << this.hb + 1 - this.bs) - 1;
        if (this.pixelDataVr == 20311) {
            in.setByteOrder(this.byteOrder);
        } else {
            in.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        }
    }

    public int readSample() throws IOException {
        return this.getSampleBitsFromCell(this.readSampleCell());
    }

    public int readSampleCell() throws IOException {
        int bRead;
        int cell = 0;
        for (bRead = 0; bRead < this.ba; bRead += 16 - this.bOff) {
            if (this.bOff == 16) {
                this.cw = this.in.readShort();
                this.bOff = 0;
                this.bMask = 65535;
            }
            cell |= (this.cw & this.bMask) >>> this.bOff << bRead;
            this.bOff = 16;
        }
        if (bRead > this.ba) {
            this.bOff -= bRead - this.ba;
            this.bMask = ~((1 << this.bOff) - 1) & 0xFFFF;
        }
        ++this.samplesPassed;
        return cell;
    }

    public void readFully(int[] samples, int offset, int len) throws IOException {
        int[] arr = this.readFully(len);
        for (int i = 0; i < len; ++i) {
            samples[i + offset] = arr[i];
        }
    }

    public int[] readFully(int len) throws IOException {
        int[] arr = new int[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = this.readSample();
        }
        return arr;
    }

    public void skipSamples(int n) throws IOException {
        this.skipSamples((long)n);
    }

    public void skipSamples(long n) throws IOException {
        long nWords = (long)this.ba * n / 16L;
        this.bOff = (int)((long)this.bOff + (long)this.ba * n % 16L);
        if (this.bOff > 16) {
            ++nWords;
            this.bOff -= 16;
        }
        this.bMask = ~((1 << this.bOff) - 1) & 0xFFFF;
        this.in.skipBytes((nWords - 1L) * 2L);
        this.samplesPassed += n;
        this.cw = this.in.readShort();
    }

    public void skipToNextFrame() throws IOException {
        long numSamplesToSkip = (long)this.samplesPerFrame - this.samplesPassed % (long)this.samplesPerFrame;
        this.skipSamples(numSamplesToSkip);
    }

    public void mark() {
        this.in.mark();
        this.markStack.push(new PixelDataStreamMark(this.bOff, this.cw, this.bMask, this.samplesPassed));
    }

    public void reset() throws IOException {
        if (this.markStack.size() != 0) {
            this.in.reset();
            PixelDataStreamMark mark = (PixelDataStreamMark)this.markStack.pop();
            this.bOff = mark.offset;
            this.cw = mark.currentWord;
            this.bMask = mark.mask;
            this.samplesPassed = mark.samplesPassed;
        }
    }

    public void resetStream() throws IOException {
        this.in.seek(this.initialReadPos);
        this.bOff = this.initialStreamState.offset;
        this.cw = this.initialStreamState.currentWord;
        this.bMask = this.initialStreamState.mask;
        this.samplesPassed = this.initialStreamState.samplesPassed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getSampleInternal(int pixel, int band) throws IOException {
        int sampleIndex = this.byPlane ? pixel / this.frameSize * this.samplesPerFrame + pixel % this.frameSize * this.spp + band : pixel * this.spp + band;
        this.mark();
        int sample = 0;
        try {
            this.resetStream();
            this.skipSamples(sampleIndex);
            sample = this.readSample();
        }
        finally {
            this.reset();
        }
        return sample;
    }

    public int[] getPixel(int i, int j, int k) throws IOException {
        this.checkBounds(i, j, k, 0);
        int[] p = new int[this.spp];
        for (int s = 0; s < this.spp; ++s) {
            p[s] = this.getSampleInternal(i + j * this.cols + k * this.frameSize, s);
        }
        return p;
    }

    public int getSample(int i, int j, int k, int band) throws IOException {
        this.checkBounds(i, j, k, band);
        return this.getSampleInternal(i + j * this.cols + k * this.frameSize, band);
    }

    private void checkBounds(int i, int j, int k, int band) {
        if (i < 0 || i >= this.cols || j < 0 || i >= this.rows || k < 0 || k >= this.nf || band < 0 || band >= this.spp) {
            throw new ArrayIndexOutOfBoundsException("pixel[" + i + "," + j + "," + k + "], band = " + band + " is out of bounds");
        }
    }

    private void checkBounds(int i, int band) {
        if (i < 0 || i >= this.size || band < 0 || band >= this.spp) {
            throw new ArrayIndexOutOfBoundsException("pixel[" + i + "], band = " + band + "is out of bounds");
        }
    }

    private final int getSampleBitsFromCell(int cell) {
        return this.signed ? cell << this.sampleMaskLS >> this.sampleMaskRS : cell << this.sampleMaskLS >>> this.sampleMaskRS;
    }

    private final int getOverlayBitsFromCell(int cell) {
        return (cell & this.hOvlMask) >> this.hOvlMaskRS | cell & this.lOvlMask;
    }

    public PixelDataDescription getPixelDataDescription() {
        return this.pdDesc;
    }

    public DataBuffer getPixelDataBuffer(int frame) {
        return new DataBufferInt(this.getPixelDataArray(frame), this.size);
    }

    public int[][][] getPixelDataArray() {
        if (this.data != null) {
            return this.data;
        }
        throw new IllegalStateException("No pixel data has been read");
    }

    public int[][] getPixelDataArray(int frame) {
        if (frame < 0 || frame >= this.nf) {
            throw new IllegalArgumentException("Invalid frame: " + frame);
        }
        if (this.data != null) {
            return this.data[frame];
        }
        throw new IllegalStateException("No pixel data has been read");
    }

    public void readPixelData() throws IOException {
        this.readPixelData(false);
    }

    public void readPixelData(boolean grabOverlayData) throws IOException {
        if (this.data != null) {
            return;
        }
        this.data = new int[this.nf][this.spp][this.frameSize];
        int numSamplesToRead = this.size * this.spp;
        int s = 0;
        for (int i = 0; i < numSamplesToRead; ++i) {
            int p;
            int cell = this.readSampleCell();
            int f = i / this.samplesPerFrame;
            int ii = i % this.samplesPerFrame;
            if (this.byPlane) {
                s = ii / this.frameSize;
                p = ii % this.frameSize;
                this.data[f][s][p] = grabOverlayData ? cell : this.getSampleBitsFromCell(cell);
                continue;
            }
            p = ii / this.spp;
            this.data[f][s][p] = grabOverlayData ? cell : this.getSampleBitsFromCell(cell);
            s = (s + 1) % this.spp;
        }
    }

    private static final class PixelDataStreamMark {
        public final int offset;
        public final int currentWord;
        public final int mask;
        public final long samplesPassed;

        PixelDataStreamMark(int offset, int currentWord, int mask, long samplesPassed) {
            this.offset = offset;
            this.currentWord = currentWord;
            this.mask = mask;
            this.samplesPassed = samplesPassed;
        }
    }
}

