/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.server;

import java.net.DatagramPacket;
import org.dcm4che.server.SyslogService;
import org.dcm4che.server.UDPServer;
import org.dcm4cheri.server.SyslogMsg;

public class SyslogHandlerImpl
implements UDPServer.Handler {
    private final SyslogService service;

    public SyslogHandlerImpl(SyslogService service) {
        this.service = service;
    }

    public final void handle(DatagramPacket datagram) {
        byte[] buff = datagram.getData();
        try {
            SyslogMsg msg = new SyslogMsg(buff, datagram.getLength());
            this.service.process(msg.getTimestamp(), msg.getHost(), msg.getContent());
        }
        catch (SyslogMsg.InvalidSyslogMsgException e) {
            e.printStackTrace();
        }
    }
}

