/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import open.dolphin.client.KartePane;
import open.dolphin.client.SchemaHolder;
import open.dolphin.client.editor.stamp.StampHolder;
import open.dolphin.client.editor.stamp.StampHolderHandler;
import open.dolphin.infomodel.BundleDolphin;
import open.dolphin.infomodel.ClaimItem;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalVariables;

public class KarteStyledDocument
extends DefaultStyledDocument {
    private boolean topSpace = GlobalVariables.getPreferences().getBoolean("stampSpace", true);
    private final String STAMP_STYLE = "stampHolder";
    private final String SCHEMA_STYLE = "schemaHolder";
    private KartePane kartePane;

    public void setParent(KartePane kartePane) {
        this.kartePane = kartePane;
    }

    public void setLogicalStyle(String str) {
        Style style = this.getStyle(str);
        this.setLogicalStyle(this.getLength(), style);
    }

    public void clearLogicalStyle() {
        this.setLogicalStyle(this.getLength(), null);
    }

    public void makeParagraph() {
        try {
            this.insertString(this.getLength(), System.getProperty("line.separator"), null);
        }
        catch (BadLocationException e) {
            LogWriter.error(this.getClass(), e);
        }
    }

    public void stamp(StampHolder sh) {
        try {
            Style runStyle = this.getStyle("stampHolder");
            if (runStyle == null) {
                runStyle = this.addStyle("stampHolder", null);
            }
            StyleConstants.setComponent(runStyle, (Component)sh);
            int start = this.kartePane.getTextPane().getCaretPosition();
            if (this.topSpace) {
                this.insertString(start, System.getProperty("line.separator"), null);
                this.insertString(start + 1, " ", runStyle);
                this.insertString(start + 2, System.getProperty("line.separator"), null);
                sh.setEntry(this.createPosition(start + 1), this.createPosition(start + 2));
            } else {
                this.insertString(start, " ", runStyle);
                this.insertString(start + 1, System.getProperty("line.separator"), null);
                sh.setEntry(this.createPosition(start), this.createPosition(start + 1));
            }
        }
        catch (BadLocationException be) {
            LogWriter.error(this.getClass(), be);
        }
        catch (NullPointerException ne) {
            LogWriter.error(this.getClass(), ne);
        }
    }

    public void flowStamp(StampHolder sh) {
        try {
            Style runStyle = this.getStyle("stampHolder");
            if (runStyle == null) {
                runStyle = this.addStyle("stampHolder", null);
            }
            StyleConstants.setComponent(runStyle, (Component)sh);
            int start = this.kartePane.getTextPane().getCaretPosition();
            this.insertString(start, " ", runStyle);
            sh.setEntry(this.createPosition(start), this.createPosition(start + 1));
        }
        catch (BadLocationException be) {
            LogWriter.error(this.getClass(), be);
        }
        catch (NullPointerException ne) {
            LogWriter.error(this.getClass(), ne);
        }
    }

    public void removeStamp(int start, int len) {
        try {
            this.remove(start, 1);
        }
        catch (BadLocationException be) {
            LogWriter.error(this.getClass(), be);
        }
    }

    public void insertStamp(Position inPos, StampHolder sh) {
        try {
            Style runStyle = this.getStyle("stampHolder");
            if (runStyle == null) {
                runStyle = this.addStyle("stampHolder", null);
            }
            StyleConstants.setComponent(runStyle, (Component)sh);
            int start = inPos.getOffset();
            this.insertString(start, " ", runStyle);
            sh.setEntry(this.createPosition(start), this.createPosition(start + 1));
        }
        catch (BadLocationException be) {
            LogWriter.error(this.getClass(), be);
        }
    }

    public void stampSchema(SchemaHolder sc) {
        try {
            Style runStyle = this.getStyle("schemaHolder");
            if (runStyle == null) {
                runStyle = this.addStyle("schemaHolder", null);
            }
            StyleConstants.setComponent(runStyle, sc);
            int start = this.kartePane.getTextPane().getCaretPosition();
            this.insertString(start, " ", runStyle);
            this.insertString(start + 1, System.getProperty("line.separator"), null);
            sc.setEntry(this.createPosition(start), this.createPosition(start + 1));
        }
        catch (BadLocationException be) {
            LogWriter.error(this.getClass(), be);
        }
    }

    public void flowSchema(SchemaHolder sh) {
        try {
            Style runStyle = this.getStyle("schemaHolder");
            if (runStyle == null) {
                runStyle = this.addStyle("schemaHolder", null);
            }
            StyleConstants.setComponent(runStyle, sh);
            int start = this.kartePane.getTextPane().getCaretPosition();
            this.insertString(start, " ", runStyle);
            sh.setEntry(this.createPosition(start), this.createPosition(start + 1));
        }
        catch (BadLocationException be) {
            LogWriter.error(this.getClass(), be);
        }
        catch (NullPointerException ne) {
            LogWriter.error(this.getClass(), ne);
        }
    }

    public void insertTextStamp(String text) {
        try {
            this.clearLogicalStyle();
            this.setLogicalStyle("default");
            int pos = this.kartePane.getTextPane().getCaretPosition();
            this.insertString(pos, text, null);
        }
        catch (BadLocationException e) {
            LogWriter.error(this.getClass(), e);
        }
    }

    public void insertFreeString(String text, AttributeSet a) {
        try {
            this.insertString(this.getLength(), text, a);
        }
        catch (BadLocationException e) {
            LogWriter.error(this.getClass(), e);
        }
    }

    public void enumerateAllStampHolders(StampHolderHandler stampHolderHandler) {
        this.enumerateAllStampHolders(this.getDefaultRootElement(), stampHolderHandler);
    }

    private void enumerateAllStampHolders(Element element, StampHolderHandler stampHolderHandler) {
        AttributeSet atts = element.getAttributes().copyAttributes();
        if (atts != null) {
            Enumeration<?> names = atts.getAttributeNames();
            while (names.hasMoreElements()) {
                Object attObject;
                Object nextName = names.nextElement();
                if (nextName == StyleConstants.ResolveAttribute || nextName.toString().startsWith("$") || nextName.toString().equals("foreground") || !((attObject = atts.getAttribute(nextName)) instanceof StampHolder)) continue;
                stampHolderHandler.onStamp((StampHolder)attObject);
            }
        }
        int children = element.getElementCount();
        for (int i = 0; i < children; ++i) {
            this.enumerateAllStampHolders(element.getElement(i), stampHolderHandler);
        }
    }

    public List<ClaimItem> getClaimItems() {
        final ArrayList<ClaimItem> moduleList = new ArrayList<ClaimItem>();
        this.enumerateAllStampHolders(new StampHolderHandler(){

            public void onStamp(StampHolder stampHolder) {
                ClaimItem[] items = ((BundleDolphin)stampHolder.getStamp().getModel()).getClaimItem();
                for (int index = 0; index < items.length; ++index) {
                    moduleList.add(items[index]);
                }
            }
        });
        return moduleList;
    }
}

