/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.EventHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionListener;
import open.dolphin.client.CalendarCardPanel;
import open.dolphin.client.IChart;
import open.dolphin.client.NewKarteParams;
import open.dolphin.client.karte.template.Template;
import open.dolphin.client.karte.template.TemplateManager;
import open.dolphin.infomodel.PVTHealthInsuranceModel;
import open.dolphin.infomodel.SimpleDate;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalVariables;

public final class NewKarteDialog {
    private final String OPEN_ANOTHER = "\u5225\u30a6\u30a3\u30f3\u30c9\u30a6\u3067\u7de8\u96c6";
    private final String ADD_TO_TAB = "\u30bf\u30d6\u30d1\u30cd\u30eb\u3078\u8ffd\u52a0";
    private final String EMPTY_NEW = "\u7a7a\u767d\u306e\u65b0\u898f\u30ab\u30eb\u30c6";
    private final String APPLY_RP = "\u524d\u56de\u51e6\u65b9\u3092\u9069\u7528";
    private final String ALL_COPY = "\u5168\u3066\u30b3\u30d4\u30fc";
    private final String FROM_TEMPLATE = "\u4f7f\u7528";
    private final String DEPARTMENT = "\u8a3a\u7642\u79d1:";
    private final String SELECT_INS = "\u4fdd\u967a\u9078\u629e";
    private final String LAST_CREATE_MODE = "newKarteDialog.lastCreateMode";
    private final String FRAME_MEMORY = "newKarteDialog.openFrame";
    private NewKarteParams params;
    private JButton okButton;
    private JButton cancelButton;
    private JRadioButton emptyNew;
    private JRadioButton applyRp;
    private JRadioButton allCopy;
    private JCheckBox fromTemplate;
    private JComboBox templateList;
    private JList insuranceList;
    private JLabel departmentLabel;
    private JLabel confirmDateLabel;
    private JButton changeConfirmDateBtn;
    private JRadioButton addToTab;
    private JRadioButton openAnother;
    private JCheckBox hospitalCheckBox;
    private Preferences prefs = Preferences.userNodeForPackage(this.getClass());
    private Frame parentFrame;
    private String title;
    private JPanel content;
    private JDialog dialog;
    private NewKarteParams value;

    public NewKarteDialog(Frame parentFrame, String title) {
        this.parentFrame = parentFrame;
        this.title = title;
        this.content = this.createComponent();
    }

    public void setValue(NewKarteParams newParams) {
        this.params = newParams;
        this.setDepartment(this.params.getDepartment());
        this.setInsurance(this.params.getInsurances());
        this.hospitalCheckBox.setSelected(this.params.isHospital());
        int lastCreateMode = this.prefs.getInt("newKarteDialog.lastCreateMode", 0);
        boolean frameMemory = this.prefs.getBoolean("newKarteDialog.openFrame", true);
        switch (this.params.getOption()) {
            case BROWSER_NEW: {
                this.applyRp.setEnabled(false);
                this.allCopy.setEnabled(false);
                this.emptyNew.setSelected(true);
                this.openAnother.setSelected(frameMemory);
                this.addToTab.setSelected(!frameMemory);
                ButtonGroup bg = new ButtonGroup();
                bg.add(this.openAnother);
                bg.add(this.addToTab);
                break;
            }
            case BROWSER_COPY_NEW: {
                this.selectCreateMode(lastCreateMode);
                ButtonGroup bg = new ButtonGroup();
                bg.add(this.emptyNew);
                bg.add(this.applyRp);
                bg.add(this.allCopy);
                this.openAnother.setSelected(frameMemory);
                this.addToTab.setSelected(!frameMemory);
                bg = new ButtonGroup();
                bg.add(this.openAnother);
                bg.add(this.addToTab);
                break;
            }
            case BROWSER_MODIFY: {
                this.insuranceList.setEnabled(false);
                this.applyRp.setEnabled(false);
                this.allCopy.setEnabled(false);
                this.emptyNew.setEnabled(false);
                this.openAnother.setSelected(frameMemory);
                this.addToTab.setSelected(!frameMemory);
                ButtonGroup bg = new ButtonGroup();
                bg.add(this.openAnother);
                bg.add(this.addToTab);
                this.okButton.setEnabled(true);
                break;
            }
            case EDITOR_NEW: {
                this.applyRp.setEnabled(false);
                this.allCopy.setEnabled(false);
                this.emptyNew.setSelected(true);
                this.openAnother.setSelected(true);
                this.openAnother.setEnabled(false);
                this.addToTab.setEnabled(false);
                break;
            }
            case EDITOR_COPY_NEW: {
                this.selectCreateMode(lastCreateMode);
                ButtonGroup bg = new ButtonGroup();
                bg.add(this.applyRp);
                bg.add(this.allCopy);
                bg.add(this.emptyNew);
                this.openAnother.setSelected(true);
                this.openAnother.setEnabled(false);
                this.addToTab.setEnabled(false);
                break;
            }
            case EDITOR_MODIFY: {
                this.insuranceList.setEnabled(false);
                this.applyRp.setEnabled(false);
                this.allCopy.setEnabled(false);
                this.emptyNew.setEnabled(false);
                this.openAnother.setSelected(true);
                this.openAnother.setEnabled(false);
                this.addToTab.setEnabled(false);
            }
        }
    }

    public void start() {
        Object[] options = new Object[]{this.okButton, this.cancelButton};
        JOptionPane jop = new JOptionPane(this.content, -1, -1, null, options, this.okButton);
        this.dialog = jop.createDialog(this.parentFrame, this.title);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                NewKarteDialog.this.insuranceList.requestFocusInWindow();
            }
        });
        this.dialog.setVisible(true);
    }

    public NewKarteParams getValue() {
        return this.value;
    }

    private void createButtons() {
        this.okButton = new JButton((String)UIManager.get("OptionPane.okButtonText"));
        this.okButton.addActionListener(EventHandler.create(ActionListener.class, this, "doOk"));
        this.okButton.setEnabled(false);
        this.cancelButton = new JButton((String)UIManager.get("OptionPane.cancelButtonText"));
        this.cancelButton.addActionListener(EventHandler.create(ActionListener.class, this, "doCancel"));
    }

    private JPanel createDatePanel() {
        JPanel datePanel = new JPanel(new FlowLayout(1, 12, 0));
        datePanel.add(new JLabel("\u8a3a\u7642\u65e5\uff1a"));
        final Date date = new Date();
        final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.confirmDateLabel = new JLabel(format.format(date));
        datePanel.add(this.confirmDateLabel);
        JButton b = new JButton("\u4eca\u306e\u6642\u523b");
        b.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NewKarteDialog.this.confirmDateLabel.setText(format.format(date));
            }
        });
        datePanel.add(b);
        this.changeConfirmDateBtn = new JButton("\u5909\u66f4");
        this.changeConfirmDateBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NewKarteDialog.this.popupCalendar(e);
            }
        });
        datePanel.add(this.changeConfirmDateBtn);
        JPanel titledPanel = new JPanel();
        datePanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 5, 5));
        titledPanel.setLayout(new BorderLayout());
        titledPanel.add((Component)datePanel, "Center");
        titledPanel.setBorder(BorderFactory.createTitledBorder("\u8a3a\u7642\u65e5\u7de8\u96c6"));
        return titledPanel;
    }

    private JPanel createDepartmentLabel() {
        this.departmentLabel = new JLabel();
        JPanel dp = new JPanel(new FlowLayout(1, 11, 0));
        dp.add(new JLabel("\u8a3a\u7642\u79d1:"));
        dp.add(this.departmentLabel);
        return dp;
    }

    private JPanel createHospitalPanel() {
        JPanel divisionPanel = new JPanel();
        divisionPanel.setLayout(new BoxLayout(divisionPanel, 0));
        this.hospitalCheckBox = new JCheckBox("\u5165\u9662");
        divisionPanel.add(this.hospitalCheckBox);
        JPanel titledPanel = new JPanel();
        divisionPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 5, 5));
        titledPanel.setLayout(new BorderLayout());
        titledPanel.add((Component)divisionPanel, "Center");
        titledPanel.setBorder(BorderFactory.createTitledBorder("\u8a3a\u7642\u533a\u5206"));
        return titledPanel;
    }

    private JPanel createInsuranceList() {
        this.insuranceList = new JList();
        this.insuranceList.setFixedCellWidth(200);
        this.insuranceList.setSelectionMode(0);
        this.insuranceList.addListSelectionListener(EventHandler.create(ListSelectionListener.class, this, "insuranceSelectionChanged", "valueIsAdjusting"));
        JPanel ip = new JPanel(new BorderLayout(9, 0));
        ip.setBorder(BorderFactory.createTitledBorder("\u4fdd\u967a\u9078\u629e"));
        ip.add((Component)this.insuranceList, "Center");
        ip.add((Component)new JLabel(GlobalConstants.getImageIcon("addbk_32.gif")), "West");
        return ip;
    }

    private JPanel createModeSelectPanel() {
        this.emptyNew = new JRadioButton("\u7a7a\u767d\u306e\u65b0\u898f\u30ab\u30eb\u30c6");
        this.applyRp = new JRadioButton("\u524d\u56de\u51e6\u65b9\u3092\u9069\u7528");
        this.allCopy = new JRadioButton("\u5168\u3066\u30b3\u30d4\u30fc");
        ActionListener memory = EventHandler.create(ActionListener.class, this, "memoryMode");
        this.emptyNew.addActionListener(memory);
        this.applyRp.addActionListener(memory);
        this.allCopy.addActionListener(memory);
        JPanel modePanel = new JPanel();
        modePanel.setLayout(new BoxLayout(modePanel, 0));
        modePanel.add(this.applyRp);
        modePanel.add(Box.createRigidArea(new Dimension(5, 0)));
        modePanel.add(this.allCopy);
        modePanel.add(Box.createRigidArea(new Dimension(5, 0)));
        modePanel.add(this.emptyNew);
        modePanel.add(Box.createHorizontalGlue());
        JPanel titledPanel = new JPanel();
        modePanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 5, 5));
        titledPanel.setLayout(new BoxLayout(titledPanel, 1));
        titledPanel.add(modePanel);
        titledPanel.setBorder(BorderFactory.createTitledBorder("\u30ab\u30eb\u30c6\u4f5c\u6210\u65b9\u6cd5"));
        return titledPanel;
    }

    private List<Template> getTemplateList() {
        File localStorage = GlobalConstants.getApplicationContext().getLocalStorage().getDirectory();
        File directory = new File(localStorage, "templates");
        TemplateManager manager = new TemplateManager(directory);
        return manager.getList();
    }

    private JPanel createTemplatePanel() {
        this.fromTemplate = new JCheckBox("\u4f7f\u7528");
        this.templateList = new JComboBox();
        for (Template template : this.getTemplateList()) {
            this.templateList.addItem(template);
        }
        this.templateList.setEnabled(false);
        this.fromTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    NewKarteDialog.this.templateList.setEnabled(true);
                    NewKarteDialog.this.emptyNew.setEnabled(false);
                    NewKarteDialog.this.applyRp.setEnabled(false);
                    NewKarteDialog.this.allCopy.setEnabled(false);
                } else {
                    NewKarteDialog.this.templateList.setEnabled(false);
                    NewKarteDialog.this.emptyNew.setEnabled(true);
                    NewKarteDialog.this.applyRp.setEnabled(true);
                    NewKarteDialog.this.allCopy.setEnabled(true);
                }
            }
        });
        JPanel templatePanel = new JPanel();
        templatePanel.setLayout(new BoxLayout(templatePanel, 0));
        templatePanel.add(this.fromTemplate);
        templatePanel.add(Box.createRigidArea(new Dimension(5, 0)));
        templatePanel.add(this.templateList);
        JPanel titledPanel = new JPanel();
        titledPanel.setLayout(new BoxLayout(titledPanel, 1));
        titledPanel.add(templatePanel);
        titledPanel.setBorder(BorderFactory.createTitledBorder("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8"));
        return titledPanel;
    }

    private JPanel createPlaceSelectPanel() {
        this.openAnother = new JRadioButton("\u5225\u30a6\u30a3\u30f3\u30c9\u30a6\u3067\u7de8\u96c6");
        this.addToTab = new JRadioButton("\u30bf\u30d6\u30d1\u30cd\u30eb\u3078\u8ffd\u52a0");
        this.openAnother.addActionListener(EventHandler.create(ActionListener.class, this, "memoryFrame"));
        this.addToTab.addActionListener(EventHandler.create(ActionListener.class, this, "memoryFrame"));
        JPanel openPanel = new JPanel();
        openPanel.setLayout(new BoxLayout(openPanel, 0));
        openPanel.add(this.openAnother);
        openPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        openPanel.add(this.addToTab);
        openPanel.add(Box.createHorizontalGlue());
        JPanel titledPanel = new JPanel();
        openPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 5, 5));
        titledPanel.setLayout(new BorderLayout());
        titledPanel.add((Component)openPanel, "Center");
        titledPanel.setBorder(BorderFactory.createTitledBorder("\u30ab\u30eb\u30c6\u7de8\u96c6\u30a6\u30a4\u30f3\u30c9\u30a6"));
        return titledPanel;
    }

    private void setDepartment(String dept) {
        if (dept != null) {
            String[] depts = dept.split("\\s*,\\s*");
            this.departmentLabel.setText(depts[0]);
        }
    }

    private void setInsurance(Object[] o) {
        int index;
        this.insuranceList.setListData(o);
        if (o != null && o.length > 0 && (index = this.params.getInitialSelectedInsurance()) >= 0 && index < o.length) {
            this.insuranceList.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    private IChart.NewKarteMode getCreateMode() {
        if (this.fromTemplate.isSelected()) {
            return IChart.NewKarteMode.FROM_TEMPLATE;
        }
        if (this.emptyNew.isSelected()) {
            return IChart.NewKarteMode.EMPTY_NEW;
        }
        if (this.applyRp.isSelected()) {
            return IChart.NewKarteMode.APPLY_RP;
        }
        if (this.allCopy.isSelected()) {
            return IChart.NewKarteMode.ALL_COPY;
        }
        return IChart.NewKarteMode.EMPTY_NEW;
    }

    private void selectCreateMode(int mode) {
        this.emptyNew.setSelected(false);
        this.applyRp.setSelected(false);
        this.allCopy.setSelected(false);
        if (mode == 0) {
            this.emptyNew.setSelected(true);
        } else if (mode == 1) {
            this.applyRp.setSelected(true);
        } else if (mode == 2) {
            this.allCopy.setSelected(true);
        }
    }

    protected JPanel createComponent() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.createDepartmentLabel());
        panel.add(Box.createVerticalStrut(11));
        panel.add(this.createInsuranceList());
        panel.add(Box.createVerticalStrut(11));
        panel.add(this.createModeSelectPanel());
        panel.add(Box.createVerticalStrut(11));
        this.fromTemplate = new JCheckBox("\u4f7f\u7528");
        this.fromTemplate.setSelected(false);
        panel.add(this.createPlaceSelectPanel());
        panel.add(Box.createVerticalStrut(11));
        panel.add(this.createHospitalPanel());
        panel.add(Box.createVerticalStrut(11));
        panel.add(this.createDatePanel());
        this.createButtons();
        return panel;
    }

    public void controlFocus(WindowEvent e) {
        this.insuranceList.requestFocusInWindow();
    }

    public void insuranceSelectionChanged(boolean adjusting) {
        if (!adjusting) {
            Object o = this.insuranceList.getSelectedValue();
            boolean ok = o != null;
            this.okButton.setEnabled(ok);
        }
    }

    public void memoryMode() {
        if (this.emptyNew.isSelected()) {
            this.prefs.putInt("newKarteDialog.lastCreateMode", 0);
        } else if (this.applyRp.isSelected()) {
            this.prefs.putInt("newKarteDialog.lastCreateMode", 1);
        } else if (this.allCopy.isSelected()) {
            this.prefs.putInt("newKarteDialog.lastCreateMode", 2);
        }
    }

    public void memoryFrame() {
        boolean openFrame = this.openAnother.isSelected();
        this.prefs.putBoolean("newKarteDialog.openFrame", openFrame);
        Preferences gpref = GlobalVariables.getPreferences();
        gpref.putBoolean("karte.placeMode", openFrame);
    }

    public void doOk() {
        this.params.setDepartment(this.departmentLabel.getText());
        this.params.setPVTHealthInsurance((PVTHealthInsuranceModel)this.insuranceList.getSelectedValue());
        this.params.setCreateMode(this.getCreateMode());
        this.params.setOpenFrame(this.openAnother.isSelected());
        this.params.setHospital(this.hospitalCheckBox.isSelected());
        if (this.fromTemplate.isSelected()) {
            this.params.setSelectedTemplate((Template)this.templateList.getSelectedItem());
        }
        this.params.setConfirmDate(this.confirmDateLabel.getText().replaceFirst(" ", "T"));
        this.value = this.params;
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    public void doCancel() {
        this.value = null;
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    public void popupCalendar(MouseEvent e) {
        final JPopupMenu popup = new JPopupMenu();
        CalendarCardPanel cc = new CalendarCardPanel(GlobalConstants.getEventColorTable());
        cc.addPropertyChangeListener("pickedDate", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("pickedDate")) {
                    SimpleDate sd = (SimpleDate)e.getNewValue();
                    NewKarteDialog.this.confirmDateLabel.setText(SimpleDate.simpleDateToMmldate(sd) + " 00:00:00");
                    popup.setVisible(false);
                }
            }
        });
        cc.setCalendarRange(new int[]{-12, 0});
        popup.insert(cc, 0);
        popup.show(e.getComponent(), e.getX(), e.getY());
    }
}

