/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.infomodel;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.sql.Blob;
import open.dolphin.log.LogWriter;
import org.hibernate.lob.BlobImpl;

public class BeanUtils {
    public static String beanToXml(Object bean) {
        String result = null;
        try {
            result = new String(BeanUtils.getXMLBytes(bean), "UTF-8");
        }
        catch (Exception e) {
            LogWriter.error("beanToXml", "", (Throwable)e);
        }
        return result;
    }

    public static Object xmlToBean(String beanXml) {
        Object result = null;
        try {
            byte[] bytes = beanXml.getBytes("UTF-8");
            XMLDecoder decoder = new XMLDecoder(new BufferedInputStream(new ByteArrayInputStream(bytes)));
            result = decoder.readObject();
        }
        catch (Exception e) {
            LogWriter.error("xmlToBean", "", (Throwable)e);
            result = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getXMLBytes(Object bean) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(stream));
        try {
            encoder.writeObject(bean);
        }
        finally {
            encoder.close();
        }
        return stream.toByteArray();
    }

    public static Blob getXMLBlob(Object bean) {
        return new BlobImpl(BeanUtils.getXMLBytes(bean));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] xmlEncode(Object bean) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(stream));
        try {
            encoder.writeObject(bean);
        }
        finally {
            encoder.close();
        }
        return stream.toByteArray();
    }

    public static Blob xmlEncodeBlob(Object bean) {
        return new BlobImpl(BeanUtils.xmlEncode(bean));
    }

    public static Object xmlDecode(byte[] bytes) {
        XMLDecoder decoder = new XMLDecoder(new BufferedInputStream(new ByteArrayInputStream(bytes)));
        if (decoder != null) {
            return decoder.readObject();
        }
        return null;
    }
}

