/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.service.remote;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityExistsException;
import javax.persistence.NoResultException;
import open.dolphin.infomodel.AppointmentModel;
import open.dolphin.infomodel.DocumentModel;
import open.dolphin.infomodel.FacilityModel;
import open.dolphin.infomodel.LaboModuleValue;
import open.dolphin.infomodel.ObservationModel;
import open.dolphin.infomodel.PatientMemoModel;
import open.dolphin.infomodel.PublishedTreeModel;
import open.dolphin.infomodel.RegisteredDiagnosisModel;
import open.dolphin.infomodel.StampModel;
import open.dolphin.infomodel.StampTreeModel;
import open.dolphin.infomodel.SubscribedTreeModel;
import open.dolphin.infomodel.UserModel;
import open.dolphin.log.LogWriter;
import open.dolphin.service.DolphinService;
import open.dolphin.service.IUserService;
import org.hibernate.HibernateException;

public class RemoteUserService
extends DolphinService
implements IUserService {
    @Override
    public int addUser(UserModel add) {
        block4: {
            this.roleAllowed("admin");
            try {
                this.startTransaction();
                try {
                    this.getUser(add.getUserId());
                    this.endTransaction();
                    throw new EntityExistsException();
                }
                catch (NoResultException e) {
                    this.getSession().persist((Object)add);
                    this.endTransaction();
                }
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block4;
                this.getSession().getTransaction().rollback();
                LogWriter.error(this.getClass(), "Rollback", (Throwable)e);
            }
        }
        return 1;
    }

    @Override
    public UserModel getUser(String userId) {
        UserModel user;
        block4: {
            this.roleAllowed("user");
            user = null;
            try {
                this.startTransaction();
                this.checkIdAsComposite(userId);
                user = (UserModel)this.getSession().createQuery("from UserModel where userid = :uid").setParameter("uid", (Object)userId).uniqueResult();
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block4;
                this.getSession().getTransaction().rollback();
                LogWriter.error(this.getClass(), "Rollback", (Throwable)e);
            }
        }
        if (user == null) {
            throw new NoResultException();
        }
        if (user.getMemberType() != null && user.getMemberType().equals("EXPIRED")) {
            throw new SecurityException("Expired User");
        }
        return user;
    }

    @Override
    public List<UserModel> getAllUser() {
        List users;
        block3: {
            this.roleAllowed("admin");
            users = null;
            try {
                this.startTransaction();
                users = this.getSession().createQuery("from UserModel u where u.userId like :fid").setParameter("fid", (Object)(this.getCallersFacilityId() + "%")).list();
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block3;
                this.getSession().getTransaction().rollback();
                LogWriter.error(this.getClass(), "Rollback", (Throwable)e);
            }
        }
        ArrayList<UserModel> ret = new ArrayList<UserModel>();
        for (UserModel user : users) {
            if (user == null || user.getMemberType() == null || user.getMemberType().equals("EXPIRED")) continue;
            ret.add(user);
        }
        return ret;
    }

    @Override
    public int updateUser(UserModel update) {
        block2: {
            this.roleAllowed("user");
            try {
                this.startTransaction();
                UserModel current = (UserModel)this.getSession().createQuery("from UserModel where id = :id").setParameter("id", (Object)update.getId()).uniqueResult();
                update.setMemberType(current.getMemberType());
                update.setRegisteredDate(current.getRegisteredDate());
                this.getSession().merge((Object)update);
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block2;
                this.getSession().getTransaction().rollback();
                LogWriter.error(this.getClass(), "Rollback", (Throwable)e);
            }
        }
        return 1;
    }

    @Override
    public int removeUser(String removeId) {
        block16: {
            this.roleAllowed("admin");
            try {
                this.startTransaction();
                UserModel remove = this.getUser(removeId);
                long removePk = remove.getId();
                List stamps = this.getSession().createQuery("from StampModel s where s.userId = :pk").setParameter("pk", (Object)removePk).list();
                for (StampModel stamp : stamps) {
                    this.getSession().delete((Object)stamp);
                }
                List subscribedTrees = this.getSession().createQuery("from SubscribedTreeModel s where s.user.id = :pk").setParameter("pk", (Object)removePk).list();
                for (SubscribedTreeModel tree : subscribedTrees) {
                    this.getSession().delete((Object)tree);
                }
                List publishedTrees = this.getSession().createQuery("from PublishedTreeModel p where p.user.id = :pk").setParameter("pk", (Object)removePk).list();
                for (PublishedTreeModel tree : publishedTrees) {
                    this.getSession().delete((Object)tree);
                }
                try {
                    StampTreeModel stampTree = (StampTreeModel)((Object)this.getSession().createQuery("from StampTreeModel s where s.user.id = :pk").setParameter("pk", (Object)removePk).list());
                    this.getSession().delete((Object)stampTree);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (remove.getLicenseModel().getLicense().equals("doctor")) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(new Date());
                    String note = sb.toString();
                    remove.setMemo(note);
                    remove.setPassword("c9dbeb1de83e60eb1eb3675fa7d69a02");
                    remove.setMemberType("EXPIRED");
                } else {
                    this.getSession().delete((Object)remove);
                }
                boolean deleteDoc = false;
                if (deleteDoc) {
                    List documents = this.getSession().createQuery("from DocumentModel d where d.creator.id = :removeId").setParameter("removeId", (Object)removePk).list();
                    System.out.println(documents.size() + " \u4ef6\u306e\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u3092\u524a\u9664\u3057\u307e\u3059\u3002");
                    for (DocumentModel document : documents) {
                        this.getSession().delete((Object)document);
                    }
                    List rds = this.getSession().createQuery("from RegisteredDiagnosisModel d where d.creator.id = :removeId").setParameter("removeId", (Object)removePk).list();
                    System.out.println(rds.size() + " \u4ef6\u306e\u50b7\u75c5\u540d\u3092\u524a\u9664\u3057\u307e\u3059\u3002");
                    for (RegisteredDiagnosisModel rd : rds) {
                        this.getSession().delete((Object)rd);
                    }
                    List observations = this.getSession().createQuery("from ObservationModel o where o.creator.id = :removeId").setParameter("removeId", (Object)removePk).list();
                    System.out.println(observations.size() + " \u4ef6\u306e\u89b3\u6e2c\u3092\u524a\u9664\u3057\u307e\u3059\u3002");
                    for (ObservationModel observation : observations) {
                        this.getSession().delete((Object)observation);
                    }
                    List memos = this.getSession().createQuery("from PatientMemoModel o where o.creator.id = :removeId").setParameter("removeId", (Object)removePk).list();
                    System.out.println(memos.size() + " \u4ef6\u306e\u60a3\u8005\u30e1\u30e2\u3092\u524a\u9664\u3057\u307e\u3059\u3002");
                    for (PatientMemoModel memo : memos) {
                        this.getSession().delete((Object)memo);
                    }
                    List appos = this.getSession().createQuery("from AppointmentModel o where o.creator.id = :removeId").setParameter("removeId", (Object)removePk).list();
                    System.out.println(appos.size() + " \u4ef6\u306e\u4e88\u7d04\u3092\u524a\u9664\u3057\u307e\u3059\u3002");
                    for (AppointmentModel appo : appos) {
                        this.getSession().delete((Object)appo);
                    }
                    List labos = this.getSession().createQuery("from LaboModuleValue o where o.creator.id = :removeId").setParameter("removeId", (Object)removePk).list();
                    System.out.println(labos.size() + " \u4ef6\u306e\u30e9\u30dc\u3092\u524a\u9664\u3057\u307e\u3059\u3002");
                    for (LaboModuleValue lb : labos) {
                        this.getSession().delete((Object)lb);
                    }
                    this.getSession().delete((Object)remove);
                }
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block16;
                this.getSession().getTransaction().rollback();
                LogWriter.error(this.getClass(), "Rollback", (Throwable)e);
            }
        }
        return 1;
    }

    @Override
    public int updateFacility(UserModel update) {
        block2: {
            this.roleAllowed("admin");
            try {
                this.startTransaction();
                FacilityModel updateFacility = update.getFacility();
                FacilityModel current = (FacilityModel)this.getSession().createQuery("from FacilityModel where id = :id").setParameter("id", (Object)updateFacility.getId()).uniqueResult();
                updateFacility.setMemberType(current.getMemberType());
                updateFacility.setRegisteredDate(current.getRegisteredDate());
                this.getSession().merge((Object)updateFacility);
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block2;
                this.getSession().getTransaction().rollback();
                LogWriter.error(this.getClass(), "Rollback", (Throwable)e);
            }
        }
        return 1;
    }
}

