package open.dolphin.client;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.SwingConstants;

/**
 *　カルテエディタパネル　MEMO:画面
 * @author  kazm
 */
public class KartePanelDouble extends PrintablePanel implements IKartePanel {

    private static final Color TIMESTAMP_FORE = Color.BLUE;
    private static final Color TIMESTAMP_HOSPITAL = Color.RED;
    private static final int TIMESTAMP_FONT_SIZE = 14;
    private static final Font TIMESTAMP_FONT = new Font("Dialog", Font.PLAIN, TIMESTAMP_FONT_SIZE);
    private boolean isFocused;
    private PrintKarte printTask;

    /**
     * Creates new form NewJPanel
     *
     * @param isHospital
     */
    public KartePanelDouble(boolean isHospital) {
        initComponents();
        timeStampLabel.setHorizontalAlignment(SwingConstants.CENTER);
        if (isHospital) {
            timeStampLabel.setForeground(TIMESTAMP_HOSPITAL);
        } else {
            timeStampLabel.setForeground(TIMESTAMP_FORE);
        }
        timeStampLabel.setFont(TIMESTAMP_FONT);

        FocusListener fd = new FocusListener() {

            @Override
            public void focusGained(FocusEvent e) {
                isFocused = true;
            }

            @Override
            public void focusLost(FocusEvent e) {
                isFocused = false;
            }
        };

        pTextPane.addFocusListener(fd);
        soaTextPane.addFocusListener(fd);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel2 = new javax.swing.JPanel();
        timeStampLabel = new javax.swing.JLabel();
        soaTextPane = new javax.swing.JTextPane();
        pTextPane = new javax.swing.JTextPane();

        setAutoscrolls(true);

        jPanel2.setMaximumSize(new java.awt.Dimension(55, 26));

        timeStampLabel.setText("jLabel1");
        jPanel2.add(timeStampLabel);

        soaTextPane.setFont(new java.awt.Font("MS UI Gothic", 0, 16));
        soaTextPane.setMargin(new java.awt.Insets(10, 10, 10, 10));
        soaTextPane.setMaximumSize(new java.awt.Dimension(345, 2100));
        soaTextPane.setMinimumSize(new java.awt.Dimension(345, 345));
        soaTextPane.setPreferredSize(new java.awt.Dimension(0, 0));

        pTextPane.setFont(new java.awt.Font("MS UI Gothic", 0, 16));
        pTextPane.setMargin(new java.awt.Insets(10, 10, 10, 10));
        pTextPane.setMaximumSize(new java.awt.Dimension(345, 2100));
        pTextPane.setMinimumSize(new java.awt.Dimension(345, 345));
        pTextPane.setPreferredSize(new java.awt.Dimension(0, 0));

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(soaTextPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 340, Short.MAX_VALUE)
                .add(2, 2, 2)
                .add(pTextPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 339, Short.MAX_VALUE))
            .add(jPanel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 690, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(jPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 26, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(pTextPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 2100, Short.MAX_VALUE)
                    .add(soaTextPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 2100, Short.MAX_VALUE)))
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel2;
    private javax.swing.JTextPane pTextPane;
    private javax.swing.JTextPane soaTextPane;
    private javax.swing.JLabel timeStampLabel;
    // End of variables declaration//GEN-END:variables

    /**
     *
     * @return
     */
    @Override
    public JTextPane getSoaTextPane() {
        return soaTextPane;
    }

    /**
     *
     * @return
     */
    @Override
    public JTextPane getPTextPane() {
        return pTextPane;
    }

    /**
     *
     * @return
     */
    @Override
    public JLabel getTimeStampLabel() {
        return timeStampLabel;
    }

    /**
     *
     * @return
     */
    public boolean isFocused() {
        return isFocused;
    }

    /**
     *
     * @return
     */
    public PrintKarte getPrintTask() {
        return printTask;
    }
}
